/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.render.RenderFallenMount;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityFallenMount
extends EntityHorse
implements IEnderZooEntity.Aggressive {
    @Nonnull
    public static final String NAME = "fallenmount";
    public static final int EGG_BG_COL = 3562021;
    public static final int EGG_FG_COL = 0xA0A0A0;
    private boolean wasRidden = false;
    @Nonnull
    private final EntityAINearestAttackableTarget<EntityPlayer> findTargetAI;
    @Nonnull
    private final EntityAIAttackMelee attackAI;
    private ItemStack armor = ItemStack.field_190927_a;

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        IEnderZooEntity.register(event, NAME, EntityFallenMount.class, 3562021, 0xA0A0A0, IEnderZooEntity.MobID.FMOUNT);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", NAME));
        RenderingRegistry.registerEntityRenderingHandler(EntityFallenMount.class, (IRenderFactory)RenderFallenMount.FACTORY);
    }

    public EntityFallenMount(World world) {
        super(world);
        this.func_70873_a(0);
        this.func_110251_o(true);
        this.field_70714_bg.field_75782_a.clear();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.findTargetAI = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
        this.attackAI = new EntityAIAttackMelee((EntityCreature)this, ((Double)ZooConfig.fallenMountChargeSpeed.get()).doubleValue(), false);
        this.updateAttackAI();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.applyAttributes((EntityLivingBase)this, ZooConfig.fallenMountHealth, ZooConfig.fallenMountAttackDamage);
    }

    protected boolean func_70610_aX() {
        return this.func_110209_cd();
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.field_71071_by.func_70448_g();
        if (itemstack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        return false;
    }

    protected boolean func_70692_ba() {
        return true;
    }

    public boolean func_70878_b(@Nonnull EntityAnimal p_70878_1_) {
        return false;
    }

    public boolean func_184652_a(@Nonnull EntityPlayer player) {
        return false;
    }

    public boolean func_70877_b(@Nonnull ItemStack p_70877_1_) {
        return false;
    }

    public boolean isCreatureType(@Nonnull EnumCreatureType type, boolean forSpawnCount) {
        return type == EnumCreatureType.MONSTER;
    }

    public IEntityLivingData func_180482_a(@Nonnull DifficultyInstance di, @Nullable IEntityLivingData data) {
        this.func_146086_d(ItemStack.field_190927_a);
        this.func_110251_o(true);
        this.func_70873_a(0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(((Double)ZooConfig.fallenMountHealth.get()).doubleValue());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        IAttributeInstance jumpStrength = this.func_110140_aT().func_111152_a("horse.jumpStrength");
        if (jumpStrength != null) {
            jumpStrength.func_111128_a(0.5);
        }
        this.func_70606_j(this.func_110138_aP());
        float chanceOfArmor = ((Float)(this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? ZooConfig.fallenMountChanceArmoredHard : ZooConfig.fallenMountChanceArmored).get()).floatValue();
        if (this.field_70146_Z.nextFloat() <= chanceOfArmor) {
            float occupiedDiffcultyMultiplier = di.func_180170_c();
            float chanceImprovedArmor = ((Float)(this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD ? ZooConfig.fallenMountChanceArmorUpgradeHard : ZooConfig.fallenMountChanceArmorUpgrade).get()).floatValue();
            chanceImprovedArmor *= 1.0f + (occupiedDiffcultyMultiplier /= 1.5f);
            int armorLevel = 0;
            for (int i = 0; i < 2; ++i) {
                if (!(this.field_70146_Z.nextFloat() <= chanceImprovedArmor)) continue;
                ++armorLevel;
            }
            Item armorItem = Items.field_151138_bX;
            switch (armorLevel) {
                case 1: {
                    armorItem = Items.field_151136_bY;
                    break;
                }
                case 2: {
                    armorItem = Items.field_151125_bZ;
                }
            }
            this.armor = new ItemStack(armorItem);
            this.func_146086_d(this.armor);
        } else {
            this.armor = ItemStack.field_190927_a;
            this.func_146086_d(this.armor);
        }
        return data;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    public void func_70636_d() {
        float f;
        super.func_70636_d();
        if (this.field_70170_p.func_72935_r() && !this.field_70170_p.field_72995_K && this.burnInSun() && this.field_70170_p.func_82737_E() % 20L == 0L && (f = this.func_70013_c()) > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175710_j(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v)))) {
            this.func_70015_d(8);
        }
        this.func_110227_p(false);
        if (this.wasRidden != this.isRidden()) {
            this.updateAttackAI();
            this.wasRidden = this.isRidden();
        }
    }

    private boolean burnInSun() {
        if (this.isRidden() && ((Boolean)ZooConfig.fallenMountShadedByRider.get()).booleanValue()) {
            return false;
        }
        return this.func_70658_aO() == 0;
    }

    protected boolean isRidden() {
        return !this.func_184188_bt().isEmpty();
    }

    private void updateAttackAI() {
        this.field_70715_bh.func_85156_a(this.findTargetAI);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.attackAI);
        if (!this.isRidden()) {
            this.field_70715_bh.func_75776_a(2, this.findTargetAI);
            this.field_70714_bg.func_75776_a(4, (EntityAIBase)this.attackAI);
        }
    }

    public boolean func_70652_k(@Nonnull Entity target) {
        if (this.isRidden() || this.field_70128_L) {
            return false;
        }
        super.func_70652_k(target);
        if (!this.func_110209_cd()) {
            this.func_190687_dF();
        }
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), damage);
    }

    public void func_70014_b(@Nonnull NBTTagCompound root) {
        super.func_70014_b(root);
        NBTTagCompound armTag = new NBTTagCompound();
        this.armor.func_77955_b(armTag);
        root.func_74782_a("armor", (NBTBase)armTag);
    }

    public void func_70037_a(@Nonnull NBTTagCompound root) {
        super.func_70037_a(root);
        this.func_110251_o(true);
        this.armor = new ItemStack(root.func_74775_l("armor"));
        this.func_146086_d(this.armor);
    }

    @Nonnull
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", NAME);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }
}

