/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import crazypants.enderio.base.config.config.DarkSteelConfig;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.handler.darksteel.SwordHandler;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.ai.AIFindPlayer;
import crazypants.enderio.zoo.entity.render.RenderEnderminy;
import info.loenwind.autoconfig.factory.IValue;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityEnderminy
extends EntityMob
implements IEnderZooEntity {
    @Nonnull
    public static final String NAME = "enderminy";
    public static final int EGG_BG_COL = 2581069;
    public static final int EGG_FG_COL = 0x212121;
    private static final int MAX_RND_TP_DISTANCE = 32;
    @Nonnull
    private static final DataParameter<Boolean> SCREAMING_INDEX = EntityDataManager.func_187226_a(EntityEnderminy.class, (DataSerializer)DataSerializers.field_187198_h);
    @Nonnull
    private static final UUID attackingSpeedBoostModifierUUID = UUID.fromString("020E0DFB-87AE-4653-9556-831010E291B0");
    @Nonnull
    private static final AttributeModifier attackingSpeedBoostModifier = new AttributeModifier(attackingSpeedBoostModifierUUID, "Attacking speed boost", 6.2, 0).func_111168_a(false);
    private boolean isAggressive;

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", NAME));
        IEnderZooEntity.register(event, NAME, EntityEnderminy.class, 2581069, 0x212121, IEnderZooEntity.MobID.EMINIY);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityEnderminy.class, (IRenderFactory)RenderEnderminy.FACTORY);
    }

    public EntityEnderminy(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.725f);
        this.field_70138_W = 1.0f;
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIFindPlayer(this){

            @Override
            public boolean func_75250_a() {
                return (Boolean)ZooConfig.attackPlayers.get() != false ? super.func_75250_a() : false;
            }
        });
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget<EntityCreeper>((EntityCreature)this, EntityCreeper.class, true, true){

            public boolean func_75250_a() {
                return (Boolean)ZooConfig.attackCreepers.get() != false ? super.func_75250_a() : false;
            }
        });
    }

    protected boolean func_70814_o() {
        return (Boolean)ZooConfig.spawnInLitAreas.get() != false ? true : super.func_70814_o();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.applyAttributes((EntityLivingBase)this, ZooConfig.miniHealth, ZooConfig.miniAttackDamage);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCREAMING_INDEX, (Object)false);
    }

    public boolean func_70601_bi() {
        boolean passedGrassCheck = true;
        if (((Boolean)ZooConfig.spawnOnlyOnGrass.get()).booleanValue()) {
            int k;
            int j;
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            passedGrassCheck = this.field_70170_p.func_180495_p(new BlockPos(i, (j = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b)) - 1, k = MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == Blocks.field_150349_c;
        }
        return passedGrassCheck && this.field_70163_u >= (double)((Integer)ZooConfig.spawnMinY.get()).intValue() && super.func_70601_bi();
    }

    public boolean shouldAttackPlayer(EntityPlayer player) {
        ItemStack itemstack = (ItemStack)player.field_71071_by.field_70460_b.get(3);
        if (itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK)) {
            return false;
        }
        Vec3d relativePlayerEyePos = new Vec3d(this.field_70165_t - player.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e()), this.field_70161_v - player.field_70161_v);
        double distance = relativePlayerEyePos.func_72433_c();
        relativePlayerEyePos = relativePlayerEyePos.func_72432_b();
        Vec3d lookVec = this.func_70676_i(1.0f).func_72432_b();
        double dotTangent = -lookVec.func_72430_b(relativePlayerEyePos);
        return dotTangent > 1.0 - 0.025 / distance;
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (this.field_70146_Z.nextDouble() - 0.5) * 2.0, -this.field_70146_Z.nextDouble(), (this.field_70146_Z.nextDouble() - 0.5) * 2.0, new int[0]);
            }
        }
        this.field_70703_bu = false;
        super.func_70636_d();
    }

    protected void func_70619_bc() {
        if (this.func_70026_G()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        if (this.isScreaming() && !this.isAggressive && this.field_70146_Z.nextInt(100) == 0) {
            this.setScreaming(false);
        }
        super.func_70619_bc();
    }

    protected boolean teleportRandomly(int distance) {
        double d0 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)distance;
        double d1 = this.field_70163_u + (double)this.field_70146_Z.nextInt(distance + 1) - (double)(distance / 2);
        double d2 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)distance;
        return this.teleportTo(d0, d1, d2);
    }

    public boolean teleportRandomly() {
        return this.teleportRandomly(32);
    }

    public boolean teleportToEntity(Entity p_70816_1_) {
        Vec3d vec3 = new Vec3d(this.field_70165_t - p_70816_1_.field_70165_t, this.func_174813_aQ().field_72338_b + (double)(this.field_70131_O / 2.0f) - p_70816_1_.field_70163_u + (double)p_70816_1_.func_70047_e(), this.field_70161_v - p_70816_1_.field_70161_v);
        vec3 = vec3.func_72432_b();
        double d0 = 16.0;
        double d1 = this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72450_a * d0;
        double d2 = this.field_70163_u + (double)(this.field_70146_Z.nextInt(16) - 8) - vec3.field_72448_b * d0;
        double d3 = this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * 8.0 - vec3.field_72449_c * d0;
        return this.teleportTo(d1, d2, d3);
    }

    protected boolean teleportTo(double x, double y, double z) {
        EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        double d3 = this.field_70165_t;
        double d4 = this.field_70163_u;
        double d5 = this.field_70161_v;
        this.field_70165_t = event.getTargetX();
        this.field_70163_u = event.getTargetY();
        this.field_70161_v = event.getTargetZ();
        int xInt = MathHelper.func_76128_c((double)this.field_70165_t);
        int yInt = MathHelper.func_76128_c((double)this.field_70163_u);
        int zInt = MathHelper.func_76128_c((double)this.field_70161_v);
        boolean flag = false;
        if (this.field_70170_p.func_175667_e(new BlockPos(xInt, yInt, zInt))) {
            boolean foundGround = false;
            while (!foundGround && yInt > 0) {
                IBlockState bs = this.field_70170_p.func_180495_p(new BlockPos(xInt, yInt - 1, zInt));
                if (bs.func_185904_a().func_76230_c()) {
                    foundGround = true;
                    continue;
                }
                this.field_70163_u -= 1.0;
                --yInt;
            }
            if (foundGround) {
                this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                if (this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && !this.field_70170_p.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70107_b(d3, d4, d5);
            return false;
        }
        int short1 = 128;
        for (int l = 0; l < short1; ++l) {
            double d6 = (double)l / ((double)short1 - 1.0);
            float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
            double d7 = d3 + (this.field_70165_t - d3) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            double d8 = d4 + (this.field_70163_u - d4) * d6 + this.field_70146_Z.nextDouble() * (double)this.field_70131_O;
            double d9 = d5 + (this.field_70161_v - d5) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 2.0;
            this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, d7, d8, d9, (double)f, (double)f1, (double)f2, new int[0]);
        }
        this.field_70170_p.func_184134_a(d3, d4, d5, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 1.0f, false);
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }

    protected SoundEvent func_184639_G() {
        return this.isScreaming() ? SoundEvents.field_187532_aV : SoundEvents.field_187529_aS;
    }

    @Nonnull
    protected SoundEvent func_184601_bQ(@Nonnull DamageSource source) {
        return SoundEvents.field_187531_aU;
    }

    @Nonnull
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187530_aT;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", NAME);
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    public boolean func_70097_a(@Nonnull DamageSource damageSource, float p_70097_2_) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        this.setScreaming(true);
        if (damageSource instanceof EntityDamageSourceIndirect) {
            this.isAggressive = false;
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return super.func_70097_a(damageSource, p_70097_2_);
        }
        boolean res = super.func_70097_a(damageSource, p_70097_2_);
        if (damageSource instanceof EntityDamageSource && damageSource.func_76346_g() instanceof EntityPlayer && this.func_110143_aJ() > 0.0f) {
            boolean skipTeleport = SwordHandler.isEquippedAndPowered((EntityPlayer)((EntityPlayer)damageSource.func_76346_g()), (IValue)DarkSteelConfig.darkSteelSwordPowerUsePerHit);
            this.isAggressive = true;
            if (this.field_70146_Z.nextInt(3) == 0) {
                for (int i = 0; i < 64; ++i) {
                    if (!skipTeleport && !this.teleportRandomly(16)) continue;
                    this.func_70624_b((EntityLivingBase)((EntityPlayer)damageSource.func_76346_g()));
                    this.doGroupArgo();
                    return true;
                }
            }
        }
        if (res) {
            this.doGroupArgo();
        }
        return res;
    }

    private void doGroupArgo() {
        if (!((Boolean)ZooConfig.miniPackAttackEnabled.get()).booleanValue() || !(this.func_70638_az() instanceof EntityPlayer)) {
            return;
        }
        int range = 16;
        AxisAlignedBB bb = new AxisAlignedBB(this.field_70165_t - (double)range, this.field_70163_u - (double)range, this.field_70161_v - (double)range, this.field_70165_t + (double)range, this.field_70163_u + (double)range, this.field_70161_v + (double)range);
        List minies = this.field_70170_p.func_72872_a(EntityEnderminy.class, bb);
        if (!minies.isEmpty()) {
            for (EntityEnderminy miny : minies) {
                if (miny.func_70638_az() != null) continue;
                miny.func_70624_b(this.func_70638_az());
            }
        }
    }

    public boolean isScreaming() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREAMING_INDEX);
    }

    public void setScreaming(boolean p_70819_1_) {
        this.field_70180_af.func_187227_b(SCREAMING_INDEX, (Object)p_70819_1_);
    }

    @Nonnull
    public static AttributeModifier getAttackingspeedboostmodifier() {
        return attackingSpeedBoostModifier;
    }

    public boolean isAggressive() {
        return this.isAggressive;
    }

    public void setAggressive(boolean isAggressive) {
        this.isAggressive = isAggressive;
    }
}

