/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.zoo.entity;

import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import crazypants.enderio.base.loot.EntityLootHelper;
import crazypants.enderio.zoo.config.ZooConfig;
import crazypants.enderio.zoo.entity.IEnderZooEntity;
import crazypants.enderio.zoo.entity.SpawnUtil;
import crazypants.enderio.zoo.entity.render.RenderDireSlime;
import info.loenwind.autoconfig.factory.IValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderiozoo")
public class EntityDireSlime
extends EntityMagmaCube
implements IEnderZooEntity.Aggressive {
    @Nonnull
    public static final String NAME = "direslime";
    public static final int EGG_BG_COL = 12158300;
    public static final int EGG_FG_COL = 5848361;

    @SubscribeEvent
    public static void onEntityRegister(@Nonnull RegistryEvent.Register<EntityEntry> event) {
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", "direslime_1"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", "direslime_2"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("enderio", "direslime_4"));
        IEnderZooEntity.register(event, NAME, EntityDireSlime.class, 12158300, 5848361, IEnderZooEntity.MobID.DLIME);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onPreInit(EnderIOLifecycleEvent.PreInit event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityDireSlime.class, (IRenderFactory)RenderDireSlime.FACTORY);
    }

    public EntityDireSlime(World world) {
        super(world);
        this.func_70799_a(1, false);
    }

    public void func_70799_a(int size, boolean doFullHeal) {
        super.func_70799_a(size, doFullHeal);
        SlimeConf conf = SlimeConf.getConfForSize(size);
        this.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)conf.getAttackDamage());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)conf.getHealth());
        this.func_70606_j(this.func_110138_aP());
    }

    public void func_70645_a(@Nonnull DamageSource damageSource) {
        SlimeConf nextConf;
        super.func_70645_a(damageSource);
        if (!this.field_70170_p.field_72995_K && damageSource.func_76346_g() instanceof EntityPlayer && (nextConf = SlimeConf.getConfForSize(this.func_70809_q()).bigger()) != null && this.field_70170_p.field_73012_v.nextFloat() <= nextConf.getChance()) {
            EntityDireSlime spawn = new EntityDireSlime(this.field_70170_p);
            spawn.func_70799_a(nextConf.size, true);
            spawn.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            spawn.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            if (SpawnUtil.isSpaceAvailableForSpawn(this.field_70170_p, (EntityLiving)spawn, false)) {
                this.field_70170_p.func_72838_d((Entity)spawn);
            }
        }
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    @Nonnull
    protected EnumParticleTypes func_180487_n() {
        return EnumParticleTypes.BLOCK_CRACK;
    }

    protected boolean spawnCustomParticles() {
        int i = this.func_70809_q();
        for (int j = 0; j < i * 8; ++j) {
            float f = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
            float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.5f;
            float f2 = MathHelper.func_76126_a((float)f) * (float)i * 0.5f * f1;
            float f3 = MathHelper.func_76134_b((float)f) * (float)i * 0.5f * f1;
            EnumParticleTypes enumparticletypes = this.func_180487_n();
            double d0 = this.field_70165_t + (double)f2;
            double d1 = this.field_70161_v + (double)f3;
            this.field_70170_p.func_175688_a(enumparticletypes, d0, this.func_174813_aQ().field_72338_b, d1, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)Blocks.field_150346_d.func_176223_P())});
        }
        return true;
    }

    @Nonnull
    protected EntitySlime func_70802_j() {
        return new EntityDireSlime(this.field_70170_p);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("enderio", "direslime_" + this.func_70809_q());
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        EntityLootHelper.dropLoot((EntityLiving)this, (ResourceLocation)this.func_184647_J(), (DamageSource)source);
        this.func_82160_b(wasRecentlyHit, lootingModifier);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (!this.field_70170_p.func_175623_d(new BlockPos(i, 0, j = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            double d0 = (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * 0.66;
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - this.func_70033_W() + d0));
            return this.field_70170_p.func_175626_b(new BlockPos(i, k, j), 0);
        }
        return 0;
    }

    public float func_70013_c() {
        int j;
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        if (!this.field_70170_p.func_175623_d(new BlockPos(i, 0, j = MathHelper.func_76128_c((double)this.field_70161_v)))) {
            double d0 = (this.func_174813_aQ().field_72337_e - this.func_174813_aQ().field_72338_b) * 0.66;
            int k = MathHelper.func_76128_c((double)(this.field_70163_u - this.func_70033_W() + d0));
            return this.field_70170_p.func_175724_o(new BlockPos(i, k, j));
        }
        return 0.0f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
    }

    protected int func_70805_n() {
        int res = (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        return res;
    }

    protected void func_70105_a(float p_70105_1_, float p_70105_2_) {
        int i = this.func_70809_q();
        super.func_70105_a((float)i, (float)i);
    }

    public void func_70100_b_(@Nonnull EntityPlayer p_70100_1_) {
        int i = this.func_70809_q();
        if (this.func_70685_l((Entity)p_70100_1_) && this.func_70068_e((Entity)p_70100_1_) < (double)i * (double)i && p_70100_1_.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_70805_n())) {
            this.func_184185_a(SoundEvents.field_187870_fk, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        }
    }

    protected float func_70655_b(@Nonnull DamageSource p_70655_1_, float p_70655_2_) {
        if (!p_70655_1_.func_76363_c()) {
            return Math.min(Math.max(p_70655_2_ - 3.0f - (float)this.func_70809_q(), (float)this.func_70809_q()) / 2.0f, p_70655_2_);
        }
        return p_70655_2_;
    }

    public static enum SlimeConf {
        SMALL(1, ZooConfig.direSlime1Health, ZooConfig.direSlime1AttackDamage, ZooConfig.direSlime1Chance),
        MEDIUM(2, ZooConfig.direSlime2Health, ZooConfig.direSlime2AttackDamage, ZooConfig.direSlime2Chance),
        LARGE(4, ZooConfig.direSlime3Health, ZooConfig.direSlime3AttackDamage, ZooConfig.direSlime3Chance);

        public final int size;
        @Nonnull
        public final IValue<Float> health;
        @Nonnull
        public final IValue<Float> attackDamage;
        @Nonnull
        public final IValue<Float> chance;

        private SlimeConf(@Nonnull int size, @Nonnull IValue<Float> health, IValue<Float> attackDamage, IValue<Float> chance) {
            this.size = size;
            this.health = health;
            this.attackDamage = attackDamage;
            this.chance = chance;
        }

        static SlimeConf getConfForSize(int size) {
            for (SlimeConf conf : SlimeConf.values()) {
                if (conf.size != size) continue;
                return conf;
            }
            return SMALL;
        }

        SlimeConf bigger() {
            int index = this.ordinal() + 1;
            if (index >= SlimeConf.values().length) {
                return null;
            }
            return SlimeConf.values()[index];
        }

        public float getAttackDamage() {
            return ((Float)this.attackDamage.get()).floatValue();
        }

        public float getHealth() {
            return ((Float)this.health.get()).floatValue();
        }

        public float getChance() {
            return ((Float)this.chance.get()).floatValue();
        }
    }
}

