/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.jei.laser;

import com.buuz135.industrial.api.recipe.LaserDrillEntry;
import com.buuz135.industrial.proxy.ItemRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class LaserRecipeWrapper
implements IRecipeWrapper {
    private final LaserDrillEntry.LaserDrillEntryExtended entryExtended;
    private int pointer = 0;

    public LaserRecipeWrapper(LaserDrillEntry.LaserDrillEntryExtended entryExtended) {
        this.entryExtended = entryExtended;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, (Object)new ItemStack((Item)ItemRegistry.laserLensItem, 1, this.entryExtended.getLaserMeta()));
        ingredients.setOutput(ItemStack.class, (Object)this.entryExtended.getStack());
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        minecraft.func_110434_K().func_110577_a(new ResourceLocation("industrialforegoing", "textures/gui/machines.png"));
        if (this.pointer > 0) {
            Gui.func_146110_a((int)0, (int)70, (float)17.0f, (float)56.0f, (int)15, (int)15, (float)256.0f, (float)256.0f);
        }
        if (this.pointer < this.entryExtended.getRarities().size() - 1) {
            Gui.func_146110_a((int)137, (int)70, (float)33.0f, (float)56.0f, (int)15, (int)15, (float)256.0f, (float)256.0f);
        }
        minecraft.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/toasts.png"));
        Gui.func_146110_a((int)(recipeWidth / 10 * 2), (int)(30 + (minecraft.field_71466_p.field_78288_b + 2) * 3), (float)216.0f, (float)0.0f, (int)20, (int)20, (float)256.0f, (float)256.0f);
        Gui.func_146110_a((int)(recipeWidth / 10 * 7), (int)(30 + (minecraft.field_71466_p.field_78288_b + 2) * 3), (float)216.0f, (float)0.0f, (int)20, (int)20, (float)256.0f, (float)256.0f);
        minecraft.func_175599_af().func_175042_a(new ItemStack(Blocks.field_180401_cv), recipeWidth / 10 * 7 + 1, 30 + (minecraft.field_71466_p.field_78288_b + 2) * 3 + 3);
        String minY = new TextComponentTranslation("text.industrialforegoing.miny", new Object[0]).func_150261_e() + " " + this.entryExtended.getRarities().get(this.pointer).getMinY();
        String maxY = new TextComponentTranslation("text.industrialforegoing.maxy", new Object[0]).func_150261_e() + " " + this.entryExtended.getRarities().get(this.pointer).getMaxY();
        String wight = new TextComponentTranslation("text.industrialforegoing.weight", new Object[0]).func_150261_e() + " " + this.entryExtended.getRarities().get(this.pointer).getWeight();
        String biomes = new TextComponentTranslation("text.industrialforegoing.biomes", new Object[0]).func_150261_e();
        minecraft.field_71466_p.func_78276_b(TextFormatting.DARK_GRAY + minY, recipeWidth / 10, 30, 0);
        minecraft.field_71466_p.func_78276_b(TextFormatting.DARK_GRAY + wight, recipeWidth / 10, 30 + (minecraft.field_71466_p.field_78288_b + 2), 0);
        minecraft.field_71466_p.func_78276_b(TextFormatting.DARK_GRAY + maxY, recipeWidth / 10 * 6, 30, 0);
        minecraft.field_71466_p.func_78276_b(TextFormatting.DARK_GRAY + "" + TextFormatting.UNDERLINE + biomes, recipeWidth / 2 - minecraft.field_71466_p.func_78256_a(biomes) / 2, 30 + (minecraft.field_71466_p.field_78288_b + 2) * 2, 0);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        if (mouseX > 0 && mouseX < 15 && mouseY > 70 && mouseY < 85 && this.pointer > 0) {
            return Arrays.asList(new TextComponentTranslation("text.industrialforegoing.button.jei.prev_rarity", new Object[0]).func_150261_e());
        }
        if (mouseX > 137 && mouseX < 152 && mouseY > 70 && mouseY < 85 && this.pointer < this.entryExtended.getRarities().size() - 1) {
            return Arrays.asList(new TextComponentTranslation("text.industrialforegoing.button.jei.next_rarity", new Object[0]).func_150261_e());
        }
        if (mouseX > 26 && mouseX < 46 && mouseY > 30 + (Minecraft.func_71410_x().field_71466_p.field_78288_b + 2) * 3 && mouseY < 30 + (Minecraft.func_71410_x().field_71466_p.field_78288_b + 2) * 3 + 20) {
            ArrayList<String> biomes = new ArrayList<String>();
            biomes.add(TextFormatting.UNDERLINE + new TextComponentTranslation("text.industrialforegoing.tooltip.whitelisted_biomes", new Object[0]).func_150260_c());
            if (this.entryExtended.getRarities().get(this.pointer).getWhitelist().isEmpty()) {
                biomes.add("- Any");
            } else {
                this.entryExtended.getRarities().get(this.pointer).getWhitelist().forEach(biome -> biomes.add("- " + biome.func_185359_l()));
            }
            return biomes;
        }
        if (mouseX > 104 && mouseX < 124 && mouseY > 30 + (Minecraft.func_71410_x().field_71466_p.field_78288_b + 2) * 3 && mouseY < 30 + (Minecraft.func_71410_x().field_71466_p.field_78288_b + 2) * 3 + 20) {
            ArrayList<String> biomes = new ArrayList<String>();
            biomes.add(TextFormatting.UNDERLINE + new TextComponentTranslation("text.industrialforegoing.tooltip.blacklisted_biomes", new Object[0]).func_150260_c());
            if (this.entryExtended.getRarities().get(this.pointer).getBlacklist().isEmpty()) {
                biomes.add("- None");
            } else {
                this.entryExtended.getRarities().get(this.pointer).getBlacklist().forEach(biome -> biomes.add("- " + biome.func_185359_l()));
            }
            return biomes;
        }
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        if (mouseX > 0 && mouseX < 15 && mouseY > 70 && mouseY < 85 && this.pointer > 0) {
            --this.pointer;
            return true;
        }
        if (mouseX > 137 && mouseX < 152 && mouseY > 70 && mouseY < 85 && this.pointer < this.entryExtended.getRarities().size() - 1) {
            ++this.pointer;
            return true;
        }
        return false;
    }
}

