/*
 * Decompiled with CFR 0.152.
 */
package knugel.whoosh.network;

import cofh.api.core.ISecurable;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import knugel.whoosh.Whoosh;
import knugel.whoosh.gui.ContainerTransporter;
import knugel.whoosh.item.ItemTransporter;
import knugel.whoosh.util.TeleportPosition;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class PacketWhoosh
extends PacketBase {
    public void handlePacket(EntityPlayer player, boolean isServer) {
        try {
            byte type = this.getByte();
            switch (PacketTypes.values()[type]) {
                case SECURITY_UPDATE: {
                    if (player.field_71070_bA instanceof ISecurable) {
                        ((ISecurable)player.field_71070_bA).setAccess(ISecurable.AccessMode.values()[this.getByte()]);
                    }
                    return;
                }
                case ADD_POS: {
                    ItemStack stack;
                    if (player.field_71070_bA instanceof ContainerTransporter && (stack = ((ContainerTransporter)player.field_71070_bA).getContainerStack()).func_77973_b() instanceof ItemTransporter) {
                        String name = this.getString();
                        BlockPos pos = this.getCoords();
                        int dim = this.getInt();
                        ItemTransporter.appendPoint(stack, new TeleportPosition(pos, dim, name));
                    }
                    return;
                }
                case REMOVE_POS: {
                    ItemStack stack;
                    if (player.field_71070_bA instanceof ContainerTransporter && (stack = ((ContainerTransporter)player.field_71070_bA).getContainerStack()).func_77973_b() instanceof ItemTransporter) {
                        ItemTransporter.removePoint(stack, this.getInt());
                    }
                    return;
                }
                case SET_SELECTED: {
                    ItemStack stack;
                    if (player.field_71070_bA instanceof ContainerTransporter && (stack = ((ContainerTransporter)player.field_71070_bA).getContainerStack()).func_77973_b() instanceof ItemTransporter) {
                        ItemTransporter.setSelected(stack, this.getInt());
                    }
                    return;
                }
                case CYCLE_SELECTED: {
                    ItemStack stack = player.func_184614_ca();
                    if (stack.func_77973_b() instanceof ItemTransporter) {
                        ItemTransporter.cycleSelected(stack, this.getInt());
                    }
                    return;
                }
            }
            Whoosh.LOG.error("Unknown Packet! Internal: WPH, ID: " + type);
        }
        catch (Exception e) {
            Whoosh.LOG.error("Packet payload failure! Please check your config files!");
            e.printStackTrace();
        }
    }

    public static void sendSecurityPacketToServer(ISecurable securable) {
        PacketHandler.sendToServer((PacketBase)PacketWhoosh.getPacket(PacketTypes.SECURITY_UPDATE).addByte(securable.getAccess().ordinal()));
    }

    public static void sendRemovePosPacketToServer(int index) {
        PacketHandler.sendToServer((PacketBase)PacketWhoosh.getPacket(PacketTypes.REMOVE_POS).addInt(index));
    }

    public static void sendAddPosPacketToServer(TeleportPosition pos) {
        PacketHandler.sendToServer((PacketBase)PacketWhoosh.getPacket(PacketTypes.ADD_POS).addString(pos.name).addCoords(pos.position.func_177958_n(), pos.position.func_177956_o(), pos.position.func_177952_p()).addInt(pos.dimension));
    }

    public static void sendSetSelectedPacketToServer(int index) {
        PacketHandler.sendToServer((PacketBase)PacketWhoosh.getPacket(PacketTypes.SET_SELECTED).addInt(index));
    }

    public static void sendCycleSelectedPacketToServer(int direction) {
        PacketHandler.sendToServer((PacketBase)PacketWhoosh.getPacket(PacketTypes.CYCLE_SELECTED).addInt(direction));
    }

    public static PacketBase getPacket(PacketTypes theType) {
        return new PacketWhoosh().addByte(theType.ordinal());
    }

    public static enum PacketTypes {
        SECURITY_UPDATE,
        ADD_POS,
        REMOVE_POS,
        SET_SELECTED,
        CYCLE_SELECTED;

    }
}

