/*
 * Decompiled with CFR 0.152.
 */
package knugel.whoosh.item;

import cofh.api.core.ISecurable;
import cofh.api.fluid.IFluidContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.api.item.INBTCopyIngredient;
import cofh.core.init.CoreEnchantments;
import cofh.core.init.CoreProps;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.RegistrySocial;
import cofh.core.util.capabilities.FluidContainerItemWrapper;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.SecurityHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import cofh.thermalfoundation.init.TFFluids;
import cofh.thermalfoundation.item.ItemMaterial;
import com.mojang.authlib.GameProfile;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import knugel.whoosh.Whoosh;
import knugel.whoosh.util.CapabilityWrapper;
import knugel.whoosh.util.TeleportPosition;
import knugel.whoosh.util.TeleportUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemTransporter
extends ItemMulti
implements IInitializer,
IMultiModeItem,
IEnergyContainerItem,
IFluidContainerItem,
IEnchantableItem,
INBTCopyIngredient {
    private static TIntObjectHashMap<TypeEntry> typeMap = new TIntObjectHashMap();
    public static final int CAPACITY_BASE = 50000;
    public static final int BASE_DIMENSION_COST = 50000;
    public static final int BASE_DIMENSION_FLUID_COST = 250;
    public static final int BASE_BLOCK_COST = 50;
    public static final int BASE_BLOCK_BLINK_COST = 150;
    public static final int BASE_FLUID_BLINK_COST = 50;
    public static final int BASE_COOLDOWN = 5;
    public static final int CREATIVE = 32000;
    public static final int[] CAPACITY = new int[]{1, 2, 5, 10, 15};
    public static final int[] TANK = new int[]{1000, 2000, 5000, 10000, 15000};
    public static final int[] RANGE = new int[]{4, 6, 8, 10, 12};
    public static final boolean[] DIMENSION = new boolean[]{false, false, true, true, true};
    public static int teleportDimensionCost;
    public static int teleportDimensionFluidCost;
    public static int teleportBlockCost;
    public static int teleportBlockBlinkCost;
    public static int teleportFluidBlinkCost;
    public static int cooldownUsage;
    public static boolean requireSneaking;
    public static ItemStack transporterBasic;
    public static ItemStack transporterHardened;
    public static ItemStack transporterReinforced;
    public static ItemStack transporterSignalum;
    public static ItemStack transporterResonant;
    public static ItemStack transporterCreative;

    public ItemTransporter() {
        super("whoosh");
        this.func_77625_d(1);
        this.func_77655_b("transporter");
        this.func_77637_a(Whoosh.tabCommon);
    }

    public int getBaseCapacity(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemTransporter.typeMap.get((int)metadata)).capacity;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        SecurityHelper.addAccessInformation((ItemStack)stack, tooltip);
        tooltip.add(StringHelper.getInfoText((String)("info.whoosh.transporter.a." + this.getMode(stack))));
        tooltip.add(StringHelper.localizeFormat((String)"info.whoosh.transporter.b.0", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
        if (!((TypeEntry)ItemTransporter.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).dimension) {
            tooltip.add(StringHelper.localizeFormat((String)"info.whoosh.transporter.c.0", (Object[])new Object[0]));
        }
        if (this.getMode(stack) == 0) {
            tooltip.add(StringHelper.localizeFormat((String)"info.whoosh.transporter.c.2", (Object[])new Object[]{((TypeEntry)ItemTransporter.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).range}));
        } else if (ItemTransporter.getSelected(stack) != -1) {
            TeleportPosition pos = ItemTransporter.getPositions(stack).get(ItemTransporter.getSelected(stack));
            tooltip.add(StringHelper.localizeFormat((String)"info.whoosh.transporter.c.1", (Object[])new Object[]{pos.name}));
        }
        if (ItemHelper.getItemDamage((ItemStack)stack) == 32000) {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": 1.21G RF");
        } else {
            tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + StringHelper.getScaledNumber((long)this.getEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        }
        if (ItemHelper.getItemDamage((ItemStack)stack) == 32000) {
            tooltip.add(StringHelper.localize((String)"info.cofh.infiniteSource"));
        } else {
            int amount = 0;
            FluidStack fluid = this.getFluid(stack);
            if (fluid != null) {
                amount = fluid.amount;
            }
            tooltip.add(StringHelper.localize((String)"info.cofh.level") + ": " + StringHelper.formatNumber((long)amount) + " / " + StringHelper.formatNumber((long)this.getCapacity(stack)) + " mB");
        }
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            Iterator iterator = this.itemList.iterator();
            while (iterator.hasNext()) {
                int metadata = (Integer)iterator.next();
                if (metadata != 32000) {
                    items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, metadata), (int)0));
                    items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)FluidHelper.setDefaultFluidTag((ItemStack)new ItemStack((Item)this, 1, metadata), (FluidStack)new FluidStack(TFFluids.fluidEnder, this.getTankBaseCapacity(metadata))), (int)this.getBaseCapacity(metadata)));
                    continue;
                }
                items.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)FluidHelper.setDefaultFluidTag((ItemStack)new ItemStack((Item)this, 1, metadata), (FluidStack)new FluidStack(TFFluids.fluidEnder, this.getTankBaseCapacity(metadata))), (int)this.getBaseCapacity(metadata)));
            }
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean func_77616_k(ItemStack stack) {
        return ((TypeEntry)ItemTransporter.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).enchantable;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Energy"}));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return ItemHelper.getItemDamage((ItemStack)stack) != 32000;
        }
        return ItemHelper.getItemDamage((ItemStack)stack) != 32000 && !stack.func_77978_p().func_74767_n("CreativeTab");
    }

    public int func_77619_b() {
        return 10;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return 0xD01010;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player) || hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!ServerHelper.isServerWorld((World)world)) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        if (SecurityHelper.isSecure((ItemStack)stack) && SecurityHelper.isDefaultUUID((UUID)SecurityHelper.getOwner((ItemStack)stack).getId())) {
            SecurityHelper.setOwner((ItemStack)stack, (GameProfile)player.func_146103_bH());
            ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.cofh.secure.item.success", new Object[0]));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (ItemTransporter.canPlayerAccess(stack, player)) {
            long lastUsed = ItemTransporter.getLastUsed(stack);
            if (lastUsed != 0L && world.func_82737_E() - lastUsed < (long)cooldownUsage) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (this.getMode(stack) == 1) {
                if (player.func_70093_af() == requireSneaking) {
                    int index = ItemTransporter.getSelected(stack);
                    if (index == -1) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                    TeleportPosition target = ItemTransporter.getPositions(stack).get(index);
                    int rfCost = TeleportUtil.getRFCost(world, new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v), target);
                    int fluidCost = TeleportUtil.getFluidCost(world, target);
                    TypeEntry type = (TypeEntry)typeMap.get(ItemHelper.getItemDamage((ItemStack)stack));
                    if (target.dimension != world.field_73011_w.getDimension() && !type.dimension) {
                        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.transporter.dimension.warning", new Object[0]));
                        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                    }
                    if (rfCost > this.getEnergyStored(stack)) {
                        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.transporter.rf.warning", new Object[]{rfCost - this.getEnergyStored(stack)}));
                        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                    }
                    if (fluidCost != 0 && (this.getFluid(stack) == null || fluidCost > this.getFluid((ItemStack)stack).amount)) {
                        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.transporter.fluid.warning", new Object[0]));
                        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                    }
                    if (!TeleportUtil.performTeleport(world, player, target)) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                    this.extractEnergy(stack, rfCost, false);
                    this.drain(stack, fluidCost, true);
                    world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                    ItemTransporter.setLastUsed(stack, world.func_82737_E());
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                } else {
                    player.openGui((Object)Whoosh.instance, 0, world, 0, 0, 0);
                }
                return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            } else {
                if (player.func_70093_af() != requireSneaking) return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                int range = ((TypeEntry)ItemTransporter.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).range;
                int rfCost = TeleportUtil.getRFCostBlink(world, player, range);
                int fluidCost = TeleportUtil.getFluidCostBlink(world, player, range);
                if (rfCost > this.getEnergyStored(stack)) {
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.transporter.rf.warning", new Object[]{rfCost - this.getEnergyStored(stack)}));
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
                FluidStack fluid = this.getFluid(stack);
                if (fluidCost != 0 && (fluid == null || fluidCost > fluid.amount)) {
                    ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.transporter.fluid.warning", new Object[]{fluidCost - (fluid == null ? 0 : fluid.amount)}));
                    return new ActionResult(EnumActionResult.FAIL, (Object)stack);
                }
                if (!TeleportUtil.performBlink(world, player, range)) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
                this.extractEnergy(stack, rfCost, false);
                this.drain(stack, fluidCost, true);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                ItemTransporter.setLastUsed(stack, world.func_82737_E());
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        } else {
            if (!SecurityHelper.isSecure((ItemStack)stack)) return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
            ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("chat.cofh.secure.warning", new Object[]{SecurityHelper.getOwnerName((ItemStack)stack)}));
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
    }

    public static boolean canPlayerAccess(ItemStack stack, EntityPlayer player) {
        if (!SecurityHelper.isSecure((ItemStack)stack)) {
            return true;
        }
        String name = player.func_70005_c_();
        ISecurable.AccessMode access = SecurityHelper.getAccess((ItemStack)stack);
        if (access.isPublic() || CoreProps.enableOpSecureAccess && CoreUtils.isOp((String)name)) {
            return true;
        }
        GameProfile profile = SecurityHelper.getOwner((ItemStack)stack);
        UUID ownerID = profile.getId();
        if (SecurityHelper.isDefaultUUID((UUID)ownerID)) {
            return true;
        }
        UUID otherID = SecurityHelper.getID((EntityPlayer)player);
        return ownerID.equals(otherID) || access.isFriendsOnly() && RegistrySocial.playerHasAccess((String)name, (GameProfile)profile);
    }

    private static void createDefaultTag(ItemStack stack) {
        NBTTagCompound tag;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!(tag = stack.func_77978_p()).func_74764_b("Positions")) {
            NBTTagList list = new NBTTagList();
            tag.func_74782_a("Positions", (NBTBase)list);
        }
    }

    public static void appendPoint(ItemStack stack, TeleportPosition pos) {
        ItemTransporter.createDefaultTag(stack);
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagList list = tag.func_150295_c("Positions", 10);
        list.func_74742_a((NBTBase)pos.serializeNBT());
    }

    public static boolean removePoint(ItemStack stack, int index) {
        ItemTransporter.createDefaultTag(stack);
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagList list = tag.func_150295_c("Positions", 10);
        if (index > list.func_74745_c() || index < 0) {
            return false;
        }
        list.func_74744_a(index);
        return true;
    }

    public static List<TeleportPosition> getPositions(ItemStack stack) {
        ItemTransporter.createDefaultTag(stack);
        ArrayList<TeleportPosition> points = new ArrayList<TeleportPosition>();
        NBTTagCompound tag = stack.func_77978_p();
        NBTTagList list = tag.func_150295_c("Positions", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            TeleportPosition p = new TeleportPosition();
            p.deserializeNBT(list.func_150305_b(i));
            points.add(p);
        }
        return points;
    }

    public static int getSelected(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b("Selected")) {
            return -1;
        }
        return tag.func_74762_e("Selected");
    }

    public static void setSelected(ItemStack stack, int index) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74768_a("Selected", index);
    }

    public static void setLastUsed(ItemStack stack, long time) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        tag.func_74772_a("LastUsed", time);
    }

    public static void cycleSelected(ItemStack stack, int direction) {
        if (!stack.func_77942_o()) {
            return;
        }
        int selected = ItemTransporter.getSelected(stack);
        List<TeleportPosition> positions = ItemTransporter.getPositions(stack);
        if (selected == -1 || positions.size() <= 1) {
            return;
        }
        selected = direction < 0 ? ++selected : --selected;
        selected = MathHelper.clamp((int)selected, (int)0, (int)(positions.size() - 1));
        ItemTransporter.setSelected(stack, selected);
    }

    public static long getLastUsed(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0L;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b("LastUsed")) {
            return 0L;
        }
        return tag.func_74763_f("LastUsed");
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (!container.func_77978_p().func_74764_b("Fluid") || maxDrain == 0) {
            return null;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
        if (stack == null) {
            return null;
        }
        int drained = Math.min(stack.amount, maxDrain);
        if (doDrain && ItemHelper.getItemDamage((ItemStack)container) != 32000) {
            if (maxDrain >= stack.amount) {
                container.func_77978_p().func_82580_o("Fluid");
                return stack;
            }
            NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
        }
        stack.amount = drained;
        return stack;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (resource == null) {
            return 0;
        }
        if (!resource.getFluid().getName().equals("ender")) {
            return 0;
        }
        int capacity = this.getCapacity(container);
        if (ItemHelper.getItemDamage((ItemStack)container) == 32000) {
            if (doFill) {
                NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
                fluidTag.func_74768_a("Amount", capacity - 1000);
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
            }
            return resource.amount;
        }
        if (!doFill) {
            if (!container.func_77978_p().func_74764_b("Fluid")) {
                return Math.min(capacity, resource.amount);
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
            if (stack == null) {
                return Math.min(capacity, resource.amount);
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.amount, resource.amount);
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
            if (capacity < resource.amount) {
                fluidTag.func_74768_a("Amount", capacity);
                container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
                return capacity;
            }
            fluidTag.func_74768_a("Amount", resource.amount);
            container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
            return resource.amount;
        }
        NBTTagCompound fluidTag = container.func_77978_p().func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag);
        if (!stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - stack.amount;
        if (resource.amount < filled) {
            stack.amount += resource.amount;
            filled = resource.amount;
        } else {
            stack.amount = capacity;
        }
        container.func_77978_p().func_74782_a("Fluid", (NBTBase)stack.writeToNBT(fluidTag));
        return filled;
    }

    public FluidStack getFluid(ItemStack container) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new NBTTagCompound());
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p().func_74775_l("Fluid"));
    }

    public int getCapacity(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemTransporter.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).tank;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    public int getTankBaseCapacity(int metadata) {
        if (!typeMap.containsKey(metadata)) {
            return 0;
        }
        return ((TypeEntry)ItemTransporter.typeMap.get((int)metadata)).tank;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new CapabilityWrapper(new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this), new FluidContainerItemWrapper(stack, (IFluidContainerItem)this));
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int receive = Math.min(maxReceive, this.getMaxEnergyStored(container) - stored);
        if (!simulate && ItemHelper.getItemDamage((ItemStack)container) != 32000) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate && ItemHelper.getItemDamage((ItemStack)container) != 32000) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack stack) {
        if (!typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack))) {
            return 0;
        }
        int capacity = ((TypeEntry)ItemTransporter.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).capacity;
        int enchant = EnchantmentHelper.func_77506_a((Enchantment)CoreEnchantments.holding, (ItemStack)stack);
        return capacity + capacity * enchant / 2;
    }

    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return typeMap.containsKey(ItemHelper.getItemDamage((ItemStack)stack)) && ((TypeEntry)ItemTransporter.typeMap.get((int)ItemHelper.getItemDamage((ItemStack)stack))).enchantable && enchantment == CoreEnchantments.holding;
    }

    public int getMode(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("Mode");
    }

    public boolean setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("Mode", mode);
        return false;
    }

    public boolean incrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (++curMode >= this.getNumModes(stack)) {
            curMode = 0;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public boolean decrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (--curMode <= 0) {
            curMode = this.getNumModes(stack) - 1;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public int getNumModes(ItemStack stack) {
        return 2;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187750_dc, SoundCategory.PLAYERS, 0.4f, 0.5f + 0.1f * (float)this.getMode(stack));
        ChatHelper.sendIndexedChatMessageToPlayer((EntityPlayer)player, (ITextComponent)new TextComponentTranslation("info.whoosh.transporter.a." + this.getMode(stack), new Object[0]));
    }

    public boolean preInit() {
        ItemTransporter.config();
        ForgeRegistries.ITEMS.register(this.setRegistryName("transporter"));
        transporterBasic = this.addEntryItem(0, "standard0", CAPACITY[0], TANK[0], RANGE[0], DIMENSION[0], EnumRarity.COMMON);
        transporterHardened = this.addEntryItem(1, "standard1", CAPACITY[1], TANK[1], RANGE[1], DIMENSION[1], EnumRarity.COMMON);
        transporterReinforced = this.addEntryItem(2, "standard2", CAPACITY[2], TANK[2], RANGE[2], DIMENSION[2], EnumRarity.UNCOMMON);
        transporterSignalum = this.addEntryItem(3, "standard3", CAPACITY[3], TANK[3], RANGE[3], DIMENSION[3], EnumRarity.UNCOMMON);
        transporterResonant = this.addEntryItem(4, "standard4", CAPACITY[4], TANK[4], RANGE[4], DIMENSION[4], EnumRarity.RARE);
        transporterCreative = this.addEntryItem(32000, "creative", CAPACITY[4], TANK[4], RANGE[4], DIMENSION[4], EnumRarity.EPIC, false);
        Whoosh.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean initialize() {
        RecipeHelper.addShapedRecipe((ItemStack)transporterBasic, (Object[])new Object[]{" G ", "IXI", "RYR", Character.valueOf('G'), "paneGlass", Character.valueOf('I'), "plateLead", Character.valueOf('R'), "enderpearl", Character.valueOf('Y'), "ingotCopper", Character.valueOf('X'), ItemMaterial.powerCoilGold});
        return true;
    }

    private static void config() {
        String category = "Item.Transporter";
        int capacity = 50000;
        String comment = "Adjust this value to change the amount of Energy (in RF) stored by a Basic Transporter. This base value will scale with item level.";
        capacity = Whoosh.CONFIG.getConfiguration().getInt("BaseCapacity", category, capacity, capacity / 5, capacity * 5, comment);
        comment = "Adjust this value to change the amount of Energy (in RF) required to teleport across dimensions.";
        teleportDimensionCost = 50000;
        teleportDimensionCost = Whoosh.CONFIG.getConfiguration().getInt("DimensionCost", category, teleportDimensionCost, 0, Integer.MAX_VALUE, comment);
        comment = "Adjust this value to change the amount of Energy (in RF) required to teleport a distance of 1 block.";
        teleportBlockCost = 50;
        teleportBlockCost = Whoosh.CONFIG.getConfiguration().getInt("BlockCost", category, teleportBlockCost, 0, Integer.MAX_VALUE, comment);
        comment = "Adjust this value to change the amount of Fluid (in mb) required to teleport across dimensions.";
        teleportDimensionFluidCost = 250;
        teleportDimensionFluidCost = Whoosh.CONFIG.getConfiguration().getInt("DimensionFluidCost", category, teleportDimensionFluidCost, 0, Integer.MAX_VALUE, comment);
        comment = "Adjust this value to change the amount of Fluid (in mb) required to blink through blocks.";
        teleportFluidBlinkCost = 50;
        teleportFluidBlinkCost = Whoosh.CONFIG.getConfiguration().getInt("BlinkFluidCost", category, teleportFluidBlinkCost, 0, Integer.MAX_VALUE, comment);
        comment = "Adjust this value to change the amount of Energy (in RF) required to blink a distance of 1 block.";
        teleportBlockBlinkCost = 150;
        teleportBlockBlinkCost = Whoosh.CONFIG.getConfiguration().getInt("BlinkCost", category, teleportBlockBlinkCost, 0, Integer.MAX_VALUE, comment);
        comment = "Adjust this value to change the cooldown (in ticks) between usages.";
        cooldownUsage = 5;
        cooldownUsage = Whoosh.CONFIG.getConfiguration().getInt("Cooldown", category, cooldownUsage, 0, Integer.MAX_VALUE, comment);
        comment = "Require sneaking to teleport.";
        requireSneaking = true;
        requireSneaking = Whoosh.CONFIG.getConfiguration().getBoolean("Sneaking", category, requireSneaking, comment);
        int i = 0;
        while (i < CAPACITY.length) {
            int n = i++;
            CAPACITY[n] = CAPACITY[n] * capacity;
        }
    }

    private void addEntry(int metadata, String name, int capacity, int tank, int range, boolean dimension, boolean enchantable) {
        typeMap.put(metadata, (Object)new TypeEntry(name, capacity, tank, range, dimension, enchantable));
    }

    private ItemStack addEntryItem(int metadata, String name, int capacity, int tank, int range, boolean dimension, EnumRarity rarity) {
        this.addEntry(metadata, name, capacity, tank, range, dimension, true);
        return this.addItem(metadata, name, rarity);
    }

    private ItemStack addEntryItem(int metadata, String name, int capacity, int tank, int range, boolean dimension, EnumRarity rarity, boolean enchantable) {
        this.addEntry(metadata, name, capacity, tank, range, dimension, enchantable);
        return this.addItem(metadata, name, rarity);
    }

    public class TypeEntry {
        public final String name;
        public final int capacity;
        public final int tank;
        public final int range;
        public final boolean dimension;
        public final boolean enchantable;

        TypeEntry(String name, int capacity, int tank, int range, boolean dimension, boolean enchantable) {
            this.name = name;
            this.capacity = capacity;
            this.dimension = dimension;
            this.range = range;
            this.enchantable = enchantable;
            this.tank = tank;
        }
    }
}

