/*
 * Decompiled with CFR 0.152.
 */
package knugel.whoosh.gui;

import cofh.api.core.ISecurable;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.GuiTextList;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.tab.TabBase;
import cofh.core.gui.element.tab.TabInfo;
import cofh.core.gui.element.tab.TabSecurity;
import cofh.core.util.helpers.SecurityHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import knugel.whoosh.gui.ContainerTransporter;
import knugel.whoosh.gui.ElementEnergyItem;
import knugel.whoosh.gui.ElementFluidItem;
import knugel.whoosh.item.ItemTransporter;
import knugel.whoosh.util.TeleportPosition;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiTransporter
extends GuiContainerCore {
    static final String TEXTURE_PATH = "whoosh:textures/gui/transporter.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("whoosh:textures/gui/transporter.png");
    static final int TB_HEIGHT = 12;
    boolean secure;
    EntityPlayer player;
    int selected = -1;
    GuiTextField tbName;
    GuiTextList taPoints;
    GuiTextList taInfo;
    ElementButton addPoint;
    ElementButton removePoint;
    ElementButton pUp;
    ElementButton pDown;
    ElementButton pSelect;
    ElementButton pDeselect;
    ElementEnergyItem energy;
    ElementFluidItem tank;
    int tbNameX = 0;
    int tbNameY = 0;
    int taPX = 0;
    int taPY = 0;
    int taIX = 0;
    int taIY = 0;

    public GuiTransporter(EntityPlayer player, ContainerTransporter container) {
        super((Container)container, TEXTURE);
        this.secure = SecurityHelper.isSecure((ItemStack)container.getContainerStack());
        this.player = player;
        this.name = "gui.whoosh.transporter";
        this.drawInventory = false;
        this.field_147000_g = 109;
        this.field_146999_f = 192;
        this.generateInfo("tab.whoosh.transporter");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab((TabBase)new TabInfo((GuiContainerCore)this, this.myInfo));
        if (this.secure) {
            this.addTab((TabBase)new TabSecurity((GuiContainerCore)this, (ISecurable)this.field_147002_h, SecurityHelper.getID((EntityPlayer)this.player)));
        }
        this.tbNameX = this.field_147003_i + 10;
        this.tbNameY = this.field_147009_r + 24;
        this.taPX = this.field_147003_i + 8;
        this.taPY = this.field_147009_r + 39;
        this.taIX = this.field_147003_i + 96;
        this.taIY = this.field_147009_r + 44;
        String temp = "";
        if (this.tbName != null) {
            temp = this.tbName.func_146179_b();
        }
        this.tbName = new GuiTextField(0, this.field_146289_q, this.tbNameX, this.tbNameY, 83, 12);
        this.tbName.func_146203_f(12);
        this.tbName.func_146180_a(temp);
        this.tbName.func_146185_a(false);
        this.taPoints = new GuiTextList(this.field_146289_q, this.taPX, this.taPY, 83, 6);
        this.taPoints.textLines = this.getPoints();
        this.taPoints.drawBackground = false;
        this.taPoints.drawBorder = false;
        this.taPoints.highlightSelectedLine = true;
        this.taInfo = new GuiTextList(this.field_146289_q, this.taIX, this.taIY, 65, 5);
        this.taInfo.drawBackground = false;
        this.taInfo.drawBorder = false;
        this.addPoint = new ElementButton((GuiContainerCore)this, 95, 20, "SetPoint", 208, 128, 208, 144, 208, 160, 16, 16, TEXTURE_PATH);
        this.removePoint = new ElementButton((GuiContainerCore)this, 111, 20, "RemovePoint", 224, 128, 224, 144, 224, 160, 16, 16, TEXTURE_PATH);
        this.pUp = new ElementButton((GuiContainerCore)this, 130, 20, "PointsUp", 208, 64, 208, 80, 208, 96, 16, 16, TEXTURE_PATH);
        this.pDown = new ElementButton((GuiContainerCore)this, 146, 20, "PointsDown", 224, 64, 224, 80, 224, 96, 16, 16, TEXTURE_PATH);
        this.pSelect = new ElementButton((GuiContainerCore)this, 165, 18, "SelectPoint", 208, 192, 208, 212, 208, 232, 20, 20, TEXTURE_PATH);
        this.pSelect.setDisabled();
        this.pDeselect = new ElementButton((GuiContainerCore)this, 165, 18, "DeselectPoint", 228, 192, 228, 212, 228, 232, 20, 20, TEXTURE_PATH);
        this.pDeselect.setDisabled();
        this.pDeselect.setVisible(false);
        this.energy = new ElementEnergyItem(this, 166, 42, ((ContainerTransporter)this.field_147002_h).getContainerStack());
        this.tank = new ElementFluidItem(this, 175, 43, ((ContainerTransporter)this.field_147002_h).getContainerStack());
        this.addElement((ElementBase)this.addPoint);
        this.addElement((ElementBase)this.removePoint);
        this.addElement((ElementBase)this.pUp);
        this.addElement((ElementBase)this.pDown);
        this.addElement((ElementBase)this.pSelect);
        this.addElement((ElementBase)this.pDeselect);
        this.addElement(this.energy);
        this.addElement(this.tank);
        this.updateButtons();
        Keyboard.enableRepeatEvents((boolean)true);
    }

    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        this.tbName.func_146194_f();
        this.taPoints.drawText();
        this.taInfo.drawText();
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    public void func_73876_c() {
        this.tbName.func_146178_a();
    }

    protected void func_73869_a(char i, int j) {
        this.tbName.func_146201_a(i, j);
        if (j == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
            return;
        }
        this.updateButtons();
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        switch (buttonName) {
            case "SetPoint": {
                ((ContainerTransporter)this.field_147002_h).appendPoint(new TeleportPosition(this.player.func_180425_c(), this.player.field_70170_p.field_73011_w.getDimension(), this.tbName.func_146179_b().trim()));
                this.tbName.func_146180_a("");
                break;
            }
            case "RemovePoint": {
                ContainerTransporter container = (ContainerTransporter)this.field_147002_h;
                int index = this.getPoints().indexOf(this.taPoints.textLines.get(this.taPoints.selectedLine));
                if (index == this.selected) {
                    this.taInfo.textLines = Collections.emptyList();
                    this.selected = -1;
                }
                if (container.getSelected() == index) {
                    container.setSelected(-1);
                }
                if (index == -1) break;
                container.removePoint(index);
                break;
            }
            case "SelectPoint": {
                if (this.selected == -1) break;
                ((ContainerTransporter)this.field_147002_h).setSelected(this.selected);
                break;
            }
            case "DeselectPoint": {
                ((ContainerTransporter)this.field_147002_h).setSelected(-1);
                break;
            }
            case "PointsUp": {
                this.taPoints.scrollDown();
                break;
            }
            case "PointsDown": {
                this.taPoints.scrollUp();
            }
        }
        GuiTransporter.playClickSound((float)0.7f);
        this.updateButtons();
    }

    protected void func_73864_a(int mX, int mY, int mButton) throws IOException {
        int textAreaX = this.taPoints.xPos - this.field_147003_i;
        int textAreaY = this.taPoints.yPos - this.field_147009_r;
        if (textAreaX <= this.mouseX && this.mouseX < textAreaX + this.taPoints.width && this.mouseY >= textAreaY && this.mouseY < textAreaY + this.taPoints.height) {
            String sel;
            int index;
            if (!this.taPoints.mouseClicked(this.mouseX, this.mouseY, mButton, textAreaY).equalsIgnoreCase(this.tbName.func_146179_b()) && (index = this.taPoints.textLines.indexOf(sel = this.taPoints.mouseClicked(this.mouseX, this.mouseY, mButton, textAreaY))) != -1) {
                this.taPoints.selectLine(index);
                List<TeleportPosition> positions = ItemTransporter.getPositions(((ContainerTransporter)this.field_147002_h).getContainerStack());
                this.setInfo(positions.get(index));
                this.selected = index;
                this.tbName.func_146195_b(false);
            }
        } else if (this.tbNameX - this.field_147003_i <= this.mouseX && this.mouseX < this.tbNameX - this.field_147003_i + this.tbName.func_146200_o() && this.mouseY >= this.tbNameY - this.field_147009_r && this.mouseY < this.tbNameY - this.field_147009_r + 12) {
            this.taPoints.selectedLine = -1;
            this.selected = -1;
            this.tbName.func_146195_b(true);
        } else {
            super.func_73864_a(mX, mY, mButton);
        }
        this.updateButtons();
    }

    private void setInfo(TeleportPosition pos) {
        ArrayList<String> info = new ArrayList<String>();
        info.add("X: " + pos.position.func_177958_n());
        info.add("Y: " + pos.position.func_177956_o());
        info.add("Z: " + pos.position.func_177952_p());
        String name = pos.getDimensionName();
        if (name.length() > 10) {
            String partOne = name.substring(0, 10);
            String partTwo = name.substring(10);
            info.add(partOne + "-");
            info.add(partTwo);
        } else {
            info.add(name);
        }
        this.taInfo.textLines = info;
    }

    public void updateButtons() {
        if (this.canScrollUpPoints()) {
            this.pUp.setActive();
        } else {
            this.pUp.setDisabled();
        }
        if (this.canScrollDownPoints()) {
            this.pDown.setActive();
        } else {
            this.pDown.setDisabled();
        }
        if (this.selected == -1) {
            this.taInfo.textLines = Collections.emptyList();
        }
        if (this.taPoints.selectedLine != -1) {
            this.addPoint.setDisabled();
            if (!this.taPoints.textLines.isEmpty()) {
                this.removePoint.setActive();
                int sel = ((ContainerTransporter)this.field_147002_h).getSelected();
                if (this.selected != sel) {
                    this.pSelect.setVisible(true);
                    this.pSelect.setActive();
                    this.pDeselect.setVisible(false);
                    this.pDeselect.setDisabled();
                } else {
                    this.pSelect.setVisible(false);
                    this.pSelect.setDisabled();
                    this.pDeselect.setVisible(true);
                    this.pDeselect.setActive();
                }
            } else {
                this.removePoint.setDisabled();
                this.pSelect.setDisabled();
                this.pSelect.setVisible(true);
                this.pDeselect.setDisabled();
                this.pDeselect.setVisible(false);
            }
        } else {
            if (this.taPoints.textLines.contains(this.tbName.func_146179_b()) || this.tbName.func_146179_b().equals("")) {
                this.addPoint.setDisabled();
            } else {
                this.addPoint.setActive();
            }
            this.removePoint.setDisabled();
            this.pSelect.setDisabled();
        }
        if (this.selected == -1) {
            this.removePoint.setDisabled();
            this.pSelect.setDisabled();
            this.pSelect.setVisible(true);
            this.pDeselect.setDisabled();
            this.pDeselect.setVisible(false);
        }
        this.taPoints.textLines = this.getPoints();
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int textAreaX = this.taPoints.xPos - this.field_147003_i;
        int textAreaY = this.taPoints.yPos - this.field_147009_r;
        if (textAreaX <= this.mouseX && this.mouseX < textAreaX + this.taPoints.width && this.mouseY >= textAreaY && this.mouseY < textAreaY + this.taPoints.height) {
            int wheelDir = Mouse.getEventDWheel();
            if (wheelDir < 0) {
                this.taPoints.scrollUp();
            }
            if (wheelDir > 0) {
                this.taPoints.scrollDown();
            }
        }
    }

    private boolean canScrollUpPoints() {
        return this.taPoints.startLine != 0;
    }

    private boolean canScrollDownPoints() {
        return this.taPoints.textLines.size() > this.taPoints.displayLines && this.taPoints.startLine < this.taPoints.textLines.size() - this.taPoints.displayLines;
    }

    private List<String> getPoints() {
        return ((ContainerTransporter)this.field_147002_h).getPoints().stream().map(x -> x.name).collect(Collectors.toList());
    }
}

