/*
 * Decompiled with CFR 0.152.
 */
package knugel.whoosh.gui;

import cofh.api.fluid.IFluidContainerItem;
import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ElementFluidItem
extends ElementBase {
    protected IFluidContainerItem tank;
    protected ItemStack stack;
    protected boolean isInfinite;
    protected boolean alwaysShowMinimum = false;

    public ElementFluidItem(GuiContainerCore gui, int posX, int posY, ItemStack tank) {
        super(gui, posX, posY);
        this.tank = (IFluidContainerItem)tank.func_77973_b();
        this.stack = tank;
        this.texW = 64;
        this.texH = 64;
        this.sizeX = 8;
        this.sizeY = 54;
    }

    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        int amount = this.getScaled();
        this.gui.drawFluid(this.posX, this.posY + this.sizeY - amount, this.tank.getFluid(this.stack), this.sizeX, amount);
    }

    public void drawForeground(int mouseX, int mouseY) {
    }

    public void addTooltip(List<String> list) {
        if (this.tank.getFluid(this.stack) != null && this.tank.getFluid((ItemStack)this.stack).amount > 0) {
            list.add(StringHelper.getFluidName((FluidStack)this.tank.getFluid(this.stack)));
        }
        if (this.isInfinite) {
            list.add("Infinite Fluid");
        } else if (this.tank.getFluid(this.stack) != null) {
            list.add(StringHelper.formatNumber((long)this.tank.getFluid((ItemStack)this.stack).amount) + " / " + StringHelper.formatNumber((long)this.tank.getCapacity(this.stack)) + " mB");
        }
    }

    protected int getScaled() {
        if (this.tank.getCapacity(this.stack) < 0) {
            return this.sizeY;
        }
        long fraction = 0L;
        if (this.tank.getFluid(this.stack) != null) {
            fraction = (long)this.tank.getFluid((ItemStack)this.stack).amount * (long)this.sizeY / (long)this.tank.getCapacity(this.stack);
        }
        return this.alwaysShowMinimum && this.tank.getFluid((ItemStack)this.stack).amount > 0 ? Math.max(1, MathHelper.ceil((double)fraction)) : MathHelper.ceil((double)fraction);
    }
}

