/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers.machine;

import cofh.thermalexpansion.util.managers.machine.CompactorManager;
import cofh.thermalexpansion.util.parsers.BaseParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class CompactorParser
extends BaseParser {
    public static final String PLATE = "plate";
    public static final String COIN = "coin";
    public static final String MINT = "mint";
    public static final String GEAR = "gear";
    int defaultEnergy = 4000;
    Set<Pair<ItemStack, CompactorManager.Mode>> removeQueue = new ObjectOpenHashSet();

    @Override
    public void parseArray(JsonArray contentArray) {
        for (JsonElement recipe : contentArray) {
            JsonObject content = recipe.getAsJsonObject();
            if (content.has("//")) continue;
            int energy = this.defaultEnergy;
            CompactorManager.Mode mode = CompactorManager.Mode.ALL;
            ItemStack input = CompactorParser.parseItemStack(content.get("input"));
            if (content.has("type")) {
                switch (content.get("type").getAsString()) {
                    case "plate": {
                        mode = CompactorManager.Mode.PLATE;
                        break;
                    }
                    case "mint": 
                    case "coin": {
                        mode = CompactorManager.Mode.COIN;
                        break;
                    }
                    case "gear": {
                        mode = CompactorManager.Mode.GEAR;
                        break;
                    }
                    default: {
                        mode = CompactorManager.Mode.ALL;
                    }
                }
            }
            if (content.has("remove") && content.get("remove").getAsBoolean()) {
                this.removeQueue.add((Pair<ItemStack, CompactorManager.Mode>)Pair.of((Object)input, (Object)((Object)mode)));
                continue;
            }
            ItemStack output = CompactorParser.parseItemStack(content.get("output"));
            if (content.has("energy")) {
                energy = content.get("energy").getAsInt();
            } else if (content.has("energy_mod")) {
                energy = content.get("energy_mod").getAsInt() * this.defaultEnergy / 100;
            }
            if (CompactorManager.addRecipe(energy, input, output, mode) != null) {
                ++this.parseCount;
                continue;
            }
            ++this.errorCount;
        }
    }

    @Override
    public void postProcess() {
        for (Pair<ItemStack, CompactorManager.Mode> removal : this.removeQueue) {
            CompactorManager.removeRecipe((ItemStack)removal.getLeft(), (CompactorManager.Mode)((Object)removal.getRight()));
        }
    }
}

