/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.dynamo.numismatic;

import cofh.core.inventory.ComparableItemStack;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.dynamo.BlockDynamo;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoNumismatic;
import cofh.thermalexpansion.plugins.jei.Drawables;
import cofh.thermalexpansion.plugins.jei.dynamo.BaseFuelCategory;
import cofh.thermalexpansion.plugins.jei.dynamo.numismatic.NumismaticFuelCategoryGem;
import cofh.thermalexpansion.plugins.jei.dynamo.numismatic.NumismaticFuelWrapper;
import cofh.thermalexpansion.util.managers.dynamo.NumismaticManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.item.ItemStack;

public class NumismaticFuelCategory
extends BaseFuelCategory<NumismaticFuelWrapper> {
    public static boolean enable = true;

    public static void register(IRecipeCategoryRegistration registry) {
        String category = "Plugins.JEI";
        if (!(enable = ThermalExpansion.CONFIG_CLIENT.get(category, "Dynamo.Numismatic", enable))) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new NumismaticFuelCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new NumismaticFuelCategoryGem(guiHelper)});
    }

    public static void initialize(IModRegistry registry) {
        if (!enable) {
            return;
        }
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(NumismaticFuelCategory.getRecipes(guiHelper), "thermalexpansion.numismatic");
        registry.addRecipeClickArea(GuiDynamoNumismatic.class, 115, 35, 16, 16, new String[]{"thermalexpansion.numismatic", "thermalexpansion.numismatic_gem"});
        registry.addRecipeCatalyst((Object)BlockDynamo.dynamoNumismatic, new String[]{"thermalexpansion.numismatic"});
        NumismaticFuelCategoryGem.initialize(registry);
    }

    public static List<NumismaticFuelWrapper> getRecipes(IGuiHelper guiHelper) {
        ArrayList<NumismaticFuelWrapper> recipes = new ArrayList<NumismaticFuelWrapper>();
        for (ComparableItemStack fuel : NumismaticManager.getFuels()) {
            ItemStack fuelStack = fuel.toItemStack();
            recipes.add(new NumismaticFuelWrapper(guiHelper, fuelStack, NumismaticManager.getFuelEnergy(fuelStack)));
        }
        return recipes;
    }

    public NumismaticFuelCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(GuiDynamoNumismatic.TEXTURE, 26, 11, 70, 62, 0, 0, 16, 78);
        this.energyMeter = Drawables.getDrawables(guiHelper).getEnergyEmpty();
        this.durationEmpty = Drawables.getDrawables(guiHelper).getScale(0);
        this.localizedName = StringHelper.localize((String)"tile.thermalexpansion.dynamo.numismatic.name");
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.numismatic";
    }

    public void setRecipe(IRecipeLayout recipeLayout, NumismaticFuelWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 33, 23);
        guiItemStacks.set(0, (List)inputs.get(0));
    }
}

