/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.machine;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.ElementDualScaled;
import cofh.core.gui.element.ElementEnergyStored;
import cofh.core.gui.element.ElementFluid;
import cofh.core.gui.element.ElementFluidTank;
import cofh.core.gui.element.ElementSimple;
import cofh.thermalexpansion.block.machine.TileSmelter;
import cofh.thermalexpansion.gui.client.GuiPoweredBase;
import cofh.thermalexpansion.gui.container.machine.ContainerSmelter;
import cofh.thermalexpansion.gui.element.ElementSlotOverlay;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public class GuiSmelter
extends GuiPoweredBase {
    public static final String TEX_PATH = "thermalexpansion:textures/gui/machine/smelter.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/machine/smelter.png");
    private TileSmelter myTile;
    private ElementSlotOverlay[] slotPrimaryInput = new ElementSlotOverlay[2];
    private ElementSlotOverlay[] slotSecondaryInput = new ElementSlotOverlay[2];
    private ElementSlotOverlay[] slotPrimaryOutput = new ElementSlotOverlay[2];
    private ElementSlotOverlay[] slotSecondaryOutput = new ElementSlotOverlay[2];
    private ElementDualScaled progress;
    private ElementDualScaled speed;
    private ElementButton mode;
    private ElementSimple modeOverlay;
    private ElementSimple tankBackground;
    private ElementFluidTank tank;
    private ElementFluid progressFluid;
    private ElementDualScaled progressOverlay;

    public GuiSmelter(InventoryPlayer inventory, TileEntity tile) {
        super((Container)new ContainerSmelter(inventory, tile), tile, inventory.field_70458_d, TEXTURE);
        this.generateInfo("tab.thermalexpansion.machine.smelter");
        this.myTile = (TileSmelter)tile;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.tankBackground = (ElementSimple)this.addElement(new ElementSimple((GuiContainerCore)this, 151, 8).setTextureOffsets(176, 104).setSize(18, 62).setTexture(TEX_PATH, 256, 256));
        this.slotPrimaryInput[0] = (ElementSlotOverlay)this.addElement(new ElementSlotOverlay(this, 32, 26).setSlotInfo(ElementSlotOverlay.SlotColor.BLUE, ElementSlotOverlay.SlotType.STANDARD, ElementSlotOverlay.SlotRender.FULL));
        this.slotPrimaryInput[1] = (ElementSlotOverlay)this.addElement(new ElementSlotOverlay(this, 32, 26).setSlotInfo(ElementSlotOverlay.SlotColor.GREEN, ElementSlotOverlay.SlotType.STANDARD, ElementSlotOverlay.SlotRender.BOTTOM));
        this.slotSecondaryInput[0] = (ElementSlotOverlay)this.addElement(new ElementSlotOverlay(this, 56, 26).setSlotInfo(ElementSlotOverlay.SlotColor.BLUE, ElementSlotOverlay.SlotType.STANDARD, ElementSlotOverlay.SlotRender.FULL));
        this.slotSecondaryInput[1] = (ElementSlotOverlay)this.addElement(new ElementSlotOverlay(this, 56, 26).setSlotInfo(ElementSlotOverlay.SlotColor.PURPLE, ElementSlotOverlay.SlotType.STANDARD, ElementSlotOverlay.SlotRender.BOTTOM));
        this.slotPrimaryOutput[0] = (ElementSlotOverlay)this.addElement(new ElementSlotOverlay(this, 112, 22).setSlotInfo(ElementSlotOverlay.SlotColor.ORANGE, ElementSlotOverlay.SlotType.OUTPUT, ElementSlotOverlay.SlotRender.FULL));
        this.slotPrimaryOutput[1] = (ElementSlotOverlay)this.addElement(new ElementSlotOverlay(this, 112, 22).setSlotInfo(ElementSlotOverlay.SlotColor.RED, ElementSlotOverlay.SlotType.OUTPUT, ElementSlotOverlay.SlotRender.BOTTOM));
        this.slotSecondaryOutput[0] = (ElementSlotOverlay)this.addElement(new ElementSlotOverlay(this, 116, 53).setSlotInfo(ElementSlotOverlay.SlotColor.ORANGE, ElementSlotOverlay.SlotType.STANDARD, ElementSlotOverlay.SlotRender.FULL));
        this.slotSecondaryOutput[1] = (ElementSlotOverlay)this.addElement(new ElementSlotOverlay(this, 116, 53).setSlotInfo(ElementSlotOverlay.SlotColor.YELLOW, ElementSlotOverlay.SlotType.STANDARD, ElementSlotOverlay.SlotRender.BOTTOM));
        if (!this.myTile.smallStorage()) {
            this.addElement((ElementBase)new ElementEnergyStored((GuiContainerCore)this, 8, 8, this.myTile.getEnergyStorage()));
        }
        this.progress = (ElementDualScaled)this.addElement(new ElementDualScaled((GuiContainerCore)this, 79, 34).setMode(1).setSize(24, 16).setTexture("cofh:textures/gui/elements/progress_arrow_right.png", 64, 16));
        this.speed = (ElementDualScaled)this.addElement(new ElementDualScaled((GuiContainerCore)this, 44, 44).setSize(16, 16).setTexture("cofh:textures/gui/elements/scale_flame.png", 32, 16));
        this.mode = (ElementButton)this.addElement((ElementBase)new ElementButton((GuiContainerCore)this, 80, 53, "Mode", 176, 0, 176, 16, 176, 32, 16, 16, TEX_PATH));
        this.modeOverlay = (ElementSimple)this.addElement(new ElementSimple((GuiContainerCore)this, 32, 26).setTextureOffsets(176, 48).setSize(16, 16).setTexture(TEX_PATH, 256, 256));
        this.tank = (ElementFluidTank)this.addElement((ElementBase)new ElementFluidTank((GuiContainerCore)this, 152, 9, (IFluidTank)this.myTile.getTank()).setGauge(0).setAlwaysShow(true));
        this.progressFluid = (ElementFluid)this.addElement(new ElementFluid((GuiContainerCore)this, 79, 34).setFluid(this.myTile.getTankFluid()).setSize(24, 16));
        this.progressOverlay = (ElementDualScaled)this.addElement(new ElementDualScaled((GuiContainerCore)this, 79, 34).setBackground(false).setMode(1).setSize(24, 16).setTexture("cofh:textures/gui/elements/progress_arrow_fluid_right.png", 64, 16));
        this.tankBackground.setVisible(this.myTile.augmentPyrotheum());
        this.tank.setVisible(this.myTile.augmentPyrotheum());
        this.progressFluid.setVisible(this.myTile.fluidArrow());
        this.progressOverlay.setVisible(this.myTile.fluidArrow());
    }

    protected void updateElementInformation() {
        super.updateElementInformation();
        this.slotPrimaryInput[0].setVisible(this.myTile.hasSideType(1) || this.baseTile.hasSideType(8));
        this.slotPrimaryInput[1].setVisible(this.myTile.hasSideType(5));
        this.slotSecondaryInput[0].setVisible(this.myTile.hasSideType(1) || this.baseTile.hasSideType(8));
        this.slotSecondaryInput[1].setVisible(this.myTile.hasSideType(6));
        this.slotPrimaryOutput[0].setVisible(this.myTile.hasSideType(4) || this.baseTile.hasSideType(8));
        this.slotPrimaryOutput[1].setVisible(this.myTile.hasSideType(2));
        this.slotSecondaryOutput[0].setVisible(this.myTile.hasSideType(4) || this.baseTile.hasSideType(8));
        this.slotSecondaryOutput[1].setVisible(this.myTile.hasSideType(3));
        if (!this.baseTile.hasSideType(1) && !this.baseTile.hasSideType(8)) {
            this.slotPrimaryInput[1].setSlotRender(ElementSlotOverlay.SlotRender.FULL);
            this.slotSecondaryInput[1].setSlotRender(ElementSlotOverlay.SlotRender.FULL);
        } else {
            this.slotPrimaryInput[1].setSlotRender(ElementSlotOverlay.SlotRender.BOTTOM);
            this.slotSecondaryInput[1].setSlotRender(ElementSlotOverlay.SlotRender.BOTTOM);
        }
        if (!this.baseTile.hasSideType(4) && !this.baseTile.hasSideType(8)) {
            this.slotPrimaryOutput[1].setSlotRender(ElementSlotOverlay.SlotRender.FULL);
            this.slotSecondaryOutput[1].setSlotRender(ElementSlotOverlay.SlotRender.FULL);
        } else {
            this.slotPrimaryOutput[1].setSlotRender(ElementSlotOverlay.SlotRender.BOTTOM);
            this.slotSecondaryOutput[1].setSlotRender(ElementSlotOverlay.SlotRender.BOTTOM);
        }
        this.progress.setQuantity(this.myTile.getScaledProgress(24));
        this.speed.setQuantity(this.myTile.getScaledSpeed(16));
        if (this.myTile.lockPrimary) {
            this.mode.setToolTip("gui.thermalexpansion.machine.smelter.modeLocked");
            this.mode.setSheetX(176);
            this.mode.setHoverX(176);
            this.modeOverlay.setVisible(true);
        } else {
            this.mode.setToolTip("gui.thermalexpansion.machine.smelter.modeUnlocked");
            this.mode.setSheetX(192);
            this.mode.setHoverX(192);
            this.modeOverlay.setVisible(false);
        }
        this.progressFluid.setSize(this.baseTile.getScaledProgress(24), 16);
        this.progressOverlay.setQuantity(this.baseTile.getScaledProgress(24));
        this.progress.setVisible(!this.myTile.fluidArrow());
        this.tankBackground.setVisible(this.myTile.augmentPyrotheum());
        this.tank.setVisible(this.myTile.augmentPyrotheum());
        this.progressFluid.setVisible(this.myTile.fluidArrow());
        this.progressOverlay.setVisible(this.myTile.fluidArrow());
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        if (buttonName.equalsIgnoreCase("Mode")) {
            if (this.myTile.lockPrimary) {
                GuiSmelter.playClickSound((float)0.6f);
            } else {
                GuiSmelter.playClickSound((float)0.8f);
            }
            this.myTile.setMode(!this.myTile.lockPrimary);
        }
    }
}

