/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.fluid.FluidTankCore;
import cofh.core.init.CoreProps;
import cofh.core.network.PacketBase;
import cofh.core.render.TextureHelper;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoReactant;
import cofh.thermalexpansion.gui.container.dynamo.ContainerDynamoReactant;
import cofh.thermalexpansion.util.managers.dynamo.ReactantManager;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDynamoReactant
extends TileDynamoBase {
    protected static final EnergyConfig ENERGY_CONFIG = new EnergyConfig();
    protected static final HashSet<String> VALID_AUGMENTS = new HashSet();
    public static boolean enable = true;
    public static int basePower = 40;
    public static int fluidAmount = 100;
    private FluidTankCore tank = new FluidTankCore(4000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
    public boolean augmentElemental;

    public static void initialize() {
        VALID_AUGMENTS.addAll(VALID_AUGMENTS_BASE);
        VALID_AUGMENTS.add("dynamoReactantElemental");
        GameRegistry.registerTileEntity(TileDynamoReactant.class, (String)"thermalexpansion:dynamo_reactant");
        TileDynamoReactant.config();
    }

    public static void config() {
        String category = "Dynamo.Reactant";
        enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy generation (in RF/t) for a Reactant Dynamo. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 1000, comment);
        ENERGY_CONFIG.setDefaultParams(basePower, smallStorage);
    }

    public TileDynamoReactant() {
        this.inventory = new ItemStack[1];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
    }

    protected String getTileName() {
        return "tile.thermalexpansion.dynamo.reactant.name";
    }

    @Override
    protected EnergyConfig getEnergyConfig() {
        return ENERGY_CONFIG;
    }

    @Override
    protected HashSet<String> getValidAugments() {
        return VALID_AUGMENTS;
    }

    @Override
    protected boolean canStart() {
        if (this.fuelRF > 0) {
            return true;
        }
        if (this.inventory[0] == null || this.tank.getFluidAmount() < fluidAmount) {
            return false;
        }
        if (!(!this.augmentElemental || ReactantManager.validReactantElemental(this.inventory[0]) && ReactantManager.validFluidElemental(this.tank.getFluid()))) {
            return false;
        }
        return ReactantManager.reactionExists(this.inventory[0], this.tank.getFluid());
    }

    @Override
    protected void processStart() {
        ReactantManager.Reaction reaction = ReactantManager.getReaction(this.inventory[0], this.tank.getFluid());
        this.maxFuelRF = reaction.getEnergy() * this.energyMod / 100;
        this.fuelRF += this.maxFuelRF;
        this.inventory[0] = ItemHelper.consumeItem((ItemStack)this.inventory[0]);
        this.tank.drain(fluidAmount, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseUnderlayTexture() {
        return TextureHelper.getTexture((ResourceLocation)this.renderFluid.getFluid().getStill());
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDynamoReactant(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerDynamoReactant(inventory, (TileEntity)this);
    }

    @Override
    public int getScaledDuration(int scale) {
        if (this.maxFuelRF <= 0) {
            this.maxFuelRF = Math.max(this.fuelRF, ReactantManager.DEFAULT_ENERGY);
        }
        return this.fuelRF * scale / this.maxFuelRF;
    }

    @Override
    public FluidTankCore getTank(int tankIndex) {
        return this.tank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.maxFuelRF = nbt.func_74762_e("FuelMax");
        this.tank.readFromNBT(nbt);
        if (this.maxFuelRF <= 0) {
            this.maxFuelRF = Math.max(this.fuelRF, ReactantManager.DEFAULT_ENERGY);
        }
        if (!ReactantManager.validFluid(this.tank.getFluid())) {
            this.tank.setFluid(null);
        }
        if (this.tank.getFluid() != null) {
            this.renderFluid = this.tank.getFluid();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("FuelMax", this.maxFuelRF);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.maxFuelRF);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.maxFuelRF = payload.getInt();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        FluidStack tempRender = payload.getFluidStack();
        this.renderFluid = tempRender == null ? new FluidStack(FluidRegistry.LAVA, 1000) : tempRender;
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentElemental = false;
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentElemental && "dynamoReactantElemental".equals(id)) {
            this.augmentElemental = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + 4 * this.getBasePower(this.level), smallStorage);
            this.energyMod += 25;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.augmentElemental ? ReactantManager.validReactantElemental(stack) : ReactantManager.validReactant(stack);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return side.ordinal() != this.facing || this.augmentCoilDuct ? CoreProps.SINGLE_INVENTORY : CoreProps.EMPTY_INVENTORY;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{TileDynamoReactant.this.tank.getInfo()});
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || TileDynamoReactant.this.augmentCoilDuct || from.ordinal() != TileDynamoReactant.this.facing) {
                        if (TileDynamoReactant.this.augmentElemental) {
                            if (ReactantManager.validFluidElemental(resource)) {
                                return TileDynamoReactant.this.tank.fill(resource, doFill);
                            }
                            return 0;
                        }
                        if (ReactantManager.validFluid(resource)) {
                            return TileDynamoReactant.this.tank.fill(resource, doFill);
                        }
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || TileDynamoReactant.this.augmentCoilDuct || from.ordinal() != TileDynamoReactant.this.facing) {
                        return TileDynamoReactant.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || TileDynamoReactant.this.augmentCoilDuct || from.ordinal() != TileDynamoReactant.this.facing) {
                        return TileDynamoReactant.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

