/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.wire;

import buildcraft.api.transport.EnumWirePart;
import buildcraft.api.transport.IWireEmitter;
import buildcraft.api.transport.WireNode;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeApi;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.transport.wire.WorldSavedDataWireSystems;
import com.google.common.base.Predicates;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WireSystem {
    public final List<WireElement> elements = new ArrayList<WireElement>();
    public EnumDyeColor color = null;

    public boolean hasElement(WireElement element) {
        return this.elements.contains(element);
    }

    public static boolean canWireConnect(IPipeHolder holder, EnumFacing side) {
        IPipe pipe = holder.getPipe();
        if (pipe == null) {
            return false;
        }
        IPipe oPipe = holder.getNeighbourPipe(side);
        if (oPipe == null) {
            return false;
        }
        if (pipe.isConnected(side)) {
            return true;
        }
        if (holder.getPluggable(side) != null && holder.getPluggable(side).isBlocking() || oPipe.getHolder().getPluggable(side.func_176734_d()) != null && oPipe.getHolder().getPluggable(side.func_176734_d()).isBlocking()) {
            return false;
        }
        if (pipe.getDefinition().flowType == PipeApi.flowStructure || oPipe.getDefinition().flowType == PipeApi.flowStructure) {
            return pipe.getColour() == null || oPipe.getColour() == null || pipe.getColour() == oPipe.getColour();
        }
        return false;
    }

    public static List<WireElement> getConnectedElementsOfElement(IPipeHolder holder, WireElement element) {
        assert (element.wirePart != null);
        WireNode node = new WireNode(element.blockPos, element.wirePart);
        ArrayList<WireElement> list = new ArrayList<WireElement>();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            WireNode oNode = node.offset(face);
            if (oNode.pos != node.pos && !WireSystem.canWireConnect(holder, face)) continue;
            list.add(new WireElement(oNode.pos, oNode.part));
        }
        return list;
    }

    public static List<WireElement> getConnectedElementsOfElement(World world, WireElement element) {
        TileEntity tile;
        if (element.type == WireElement.Type.WIRE_PART && (tile = world.func_175625_s(element.blockPos)) instanceof IPipeHolder) {
            IPipeHolder holder = (IPipeHolder)tile;
            return WireSystem.getConnectedElementsOfElement(holder, element);
        }
        return Collections.emptyList();
    }

    public WireSystem build(WorldSavedDataWireSystems wireSystems, WireElement startElement) {
        long time = System.currentTimeMillis();
        HashMap holdersCache = new HashMap();
        HashSet walked = new HashSet();
        ArrayDeque<WireElement> queue = new ArrayDeque<WireElement>();
        Consumer<WireElement> build = element -> {
            if (!walked.contains(element)) {
                IPipeHolder holder;
                if (!holdersCache.containsKey(element.blockPos)) {
                    TileEntity tile = wireSystems.world.func_175625_s(element.blockPos);
                    IPipeHolder holder2 = null;
                    if (tile instanceof IPipeHolder) {
                        holder2 = (IPipeHolder)tile;
                    }
                    holdersCache.put(element.blockPos, holder2);
                }
                if ((holder = (IPipeHolder)holdersCache.get(element.blockPos)) != null) {
                    if (element.type == WireElement.Type.WIRE_PART) {
                        EnumDyeColor colorOfPart = holder.getWireManager().getColorOfPart(element.wirePart);
                        if (this.color == null && colorOfPart != null) {
                            this.color = colorOfPart;
                        }
                        if (this.color != null && colorOfPart == this.color) {
                            wireSystems.getWireSystemsWithElement((WireElement)element).stream().filter(wireSystem -> wireSystem != this && wireSystem.color == this.color).forEach(wireSystems::removeWireSystem);
                            this.elements.add((WireElement)element);
                            queue.addAll(WireSystem.getConnectedElementsOfElement(wireSystems.world, element));
                            Arrays.stream(EnumFacing.field_82609_l).forEach(side -> queue.add(new WireElement(element.blockPos, (EnumFacing)side)));
                        }
                    } else if (element.type == WireElement.Type.EMITTER_SIDE && holder.getPluggable(element.emitterSide) instanceof IWireEmitter) {
                        this.elements.add(new WireElement(element.blockPos, element.emitterSide));
                    }
                }
                walked.add(element);
            }
        };
        queue.add(startElement);
        while (!queue.isEmpty()) {
            build.accept((WireElement)queue.remove());
        }
        return this;
    }

    public boolean isEmpty() {
        return this.elements.stream().filter(element -> element.type == WireElement.Type.WIRE_PART).count() == 0L;
    }

    public boolean update(WorldSavedDataWireSystems wireSystems) {
        return this.elements.stream().filter(element -> element.type == WireElement.Type.EMITTER_SIDE).map(element -> wireSystems.isEmitterEmitting((WireElement)element, this.color)).reduce(Boolean::logicalOr).orElse(false);
    }

    public List<ChunkPos> getChunkPoses() {
        return this.elements.stream().map(element -> element.blockPos).map(ChunkPos::new).collect(Collectors.toList());
    }

    public boolean isPlayerWatching(EntityPlayerMP player) {
        if (player.field_70170_p instanceof WorldServer) {
            WorldServer world = (WorldServer)player.field_70170_p;
            return this.getChunkPoses().stream().map(chunkPos -> world.func_184164_w().func_187301_b(chunkPos.field_77276_a, chunkPos.field_77275_b)).filter(Objects::nonNull).anyMatch(playerChunkMapEntry -> playerChunkMapEntry.func_187269_a(Predicates.equalTo((Object)player)));
        }
        return false;
    }

    public int getWiresHashCode() {
        return this.elements.stream().filter(element -> element.type == WireElement.Type.WIRE_PART).collect(Collectors.toList()).hashCode();
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList elementsList = new NBTTagList();
        this.elements.stream().map(WireElement::writeToNBT).forEach(arg_0 -> ((NBTTagList)elementsList).func_74742_a(arg_0));
        nbt.func_74782_a("elements", (NBTBase)elementsList);
        nbt.func_74768_a("color", this.color.func_176765_a());
        return nbt;
    }

    public WireSystem readFromNBT(NBTTagCompound nbt) {
        this.elements.clear();
        NBTTagList elementsList = nbt.func_150295_c("elements", 10);
        IntStream.range(0, elementsList.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)elementsList).func_150305_b(arg_0)).map(WireElement::new).forEach(this.elements::add);
        this.color = EnumDyeColor.func_176764_b((int)nbt.func_74762_e("color"));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WireSystem that = (WireSystem)o;
        if (!this.elements.equals(that.elements)) {
            return false;
        }
        return this.color == that.color;
    }

    public int hashCode() {
        int result = this.elements.hashCode();
        result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
        return result;
    }

    public static class WireElement {
        public final Type type;
        public final BlockPos blockPos;
        public final EnumWirePart wirePart;
        public final EnumFacing emitterSide;

        public WireElement(BlockPos blockPos, EnumWirePart wirePart) {
            this.type = Type.WIRE_PART;
            this.blockPos = blockPos;
            this.wirePart = wirePart;
            this.emitterSide = null;
        }

        public WireElement(BlockPos blockPos, EnumFacing emitterSide) {
            this.type = Type.EMITTER_SIDE;
            this.blockPos = blockPos;
            this.wirePart = null;
            this.emitterSide = emitterSide;
        }

        public WireElement(PacketBuffer buf) {
            this.type = Type.values()[buf.readInt()];
            this.blockPos = MessageUtil.readBlockPos(buf);
            if (this.type == Type.WIRE_PART) {
                this.wirePart = EnumWirePart.VALUES[buf.readInt()];
                this.emitterSide = null;
            } else if (this.type == Type.EMITTER_SIDE) {
                this.wirePart = null;
                this.emitterSide = EnumFacing.func_82600_a((int)buf.readInt());
            } else {
                this.wirePart = null;
                this.emitterSide = null;
            }
        }

        public WireElement(NBTTagCompound nbt) {
            this.type = Type.values()[nbt.func_74762_e("type")];
            this.blockPos = NBTUtilBC.readBlockPos(nbt.func_74781_a("blockPos"));
            if (this.blockPos == null) {
                throw new NullPointerException("Cannot read this Wire Systems from NBT!");
            }
            if (this.type == Type.WIRE_PART) {
                this.wirePart = EnumWirePart.VALUES[nbt.func_74762_e("wirePart")];
                this.emitterSide = null;
            } else if (this.type == Type.EMITTER_SIDE) {
                this.wirePart = null;
                this.emitterSide = EnumFacing.func_82600_a((int)nbt.func_74762_e("emitterSide"));
            } else {
                this.wirePart = null;
                this.emitterSide = null;
            }
        }

        public void toBytes(PacketBuffer buf) {
            buf.writeInt(this.type.ordinal());
            MessageUtil.writeBlockPos(buf, this.blockPos);
            if (this.type == Type.WIRE_PART) {
                assert (this.wirePart != null);
                buf.writeInt(this.wirePart.ordinal());
            } else if (this.type == Type.EMITTER_SIDE) {
                assert (this.emitterSide != null);
                buf.writeInt(this.emitterSide.func_176745_a());
            }
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("type", this.type.ordinal());
            nbt.func_74782_a("blockPos", (NBTBase)NBTUtilBC.writeBlockPos(this.blockPos));
            if (this.type == Type.WIRE_PART) {
                assert (this.wirePart != null);
                nbt.func_74768_a("wirePart", this.wirePart.ordinal());
            } else if (this.type == Type.EMITTER_SIDE) {
                assert (this.emitterSide != null);
                nbt.func_74768_a("emitterSide", this.emitterSide.func_176745_a());
            }
            return nbt;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WireElement element = (WireElement)o;
            if (this.type != element.type) {
                return false;
            }
            if (!this.blockPos.equals((Object)element.blockPos)) {
                return false;
            }
            if (this.wirePart != element.wirePart) {
                return false;
            }
            return this.emitterSide == element.emitterSide;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.blockPos.hashCode();
            result = 31 * result + (this.wirePart != null ? this.wirePart.hashCode() : 0);
            result = 31 * result + (this.emitterSide != null ? this.emitterSide.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Element{type=" + (Object)((Object)this.type) + ", blockPos=" + this.blockPos + ", wirePart=" + (Object)((Object)this.wirePart) + ", emitterSide=" + this.emitterSide + '}';
        }

        public static enum Type {
            WIRE_PART,
            EMITTER_SIDE;

        }
    }
}

