/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.statement;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IAction;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITrigger;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.statement.ActionWrapper;
import buildcraft.lib.statement.TriggerWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.tileentity.TileEntity;

public abstract class StatementWrapper
implements IStatement,
Comparable<StatementWrapper> {
    public final IStatement delegate;
    public final EnumPipePart sourcePart;

    public StatementWrapper(IStatement delegate, EnumPipePart sourcePart) {
        this.delegate = delegate;
        this.sourcePart = sourcePart;
    }

    @Override
    public String getUniqueTag() {
        return this.delegate.getUniqueTag();
    }

    @Override
    public int maxParameters() {
        return this.delegate.maxParameters();
    }

    @Override
    public int minParameters() {
        return this.delegate.minParameters();
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return this.delegate.createParameter(index);
    }

    @Override
    public IStatement rotateLeft() {
        return this.delegate.rotateLeft();
    }

    @Override
    public ISprite getSprite() {
        return this.delegate.getSprite();
    }

    public TileEntity getNeighbourTile(IStatementContainer source) {
        return source.getNeighbourTile(this.sourcePart.face);
    }

    public abstract StatementWrapper[] getPossible();

    @Override
    public boolean isPossibleOrdered() {
        return this.delegate.isPossibleOrdered();
    }

    @Override
    public List<String> getTooltip() {
        List<String> list = this.delegate.getTooltip();
        if (this.sourcePart != EnumPipePart.CENTER) {
            list = new ArrayList<String>(list);
            String translated = ColourUtil.getTextFullTooltip(this.sourcePart.face);
            list.add(LocaleUtil.localize("gate.side", translated));
        }
        return list;
    }

    @Override
    public <T> T convertTo(Class<T> clazz) {
        IAction action;
        T t = this.delegate.convertTo(clazz);
        if (t != null) {
            return t;
        }
        if (clazz.isAssignableFrom(TriggerWrapper.class)) {
            ITrigger trigger = this.delegate.convertTo(ITrigger.class);
            if (trigger != null) {
                return clazz.cast(TriggerWrapper.wrap(trigger, this.sourcePart.face));
            }
        } else if (clazz.isAssignableFrom(ActionWrapper.class) && (action = this.delegate.convertTo(IAction.class)) != null) {
            return clazz.cast(ActionWrapper.wrap(action, this.sourcePart.face));
        }
        return null;
    }

    @Override
    public int compareTo(StatementWrapper o) {
        Object[] oPoss;
        Object[] poss;
        if (this.sourcePart != o.sourcePart) {
            return Integer.compare(o.sourcePart.getIndex(), this.sourcePart.getIndex());
        }
        if (this.delegate == o.delegate) {
            return 0;
        }
        if (this.delegate.getClass() == o.delegate.getClass() && Arrays.equals(poss = this.delegate.getPossible(), oPoss = o.delegate.getPossible())) {
            int idxThis = -1;
            int idxThat = -1;
            for (int i = 0; i < poss.length; ++i) {
                if (poss[i] == this.delegate) {
                    idxThis = i;
                }
                if (poss[i] != o.delegate) continue;
                idxThat = i;
            }
            if (idxThis != idxThat && idxThis != -1 && idxThat != -1) {
                return Integer.compare(idxThis, idxThat);
            }
        }
        return this.getUniqueTag().compareTo(o.getUniqueTag());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sourcePart, this.getUniqueTag()});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        StatementWrapper other = (StatementWrapper)obj;
        return this.sourcePart == other.sourcePart && this.getUniqueTag().equals(other.getUniqueTag());
    }
}

