/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.statement;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.lib.misc.data.IReference;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.statement.StatementType;
import buildcraft.lib.statement.StatementTypeParam;
import java.io.IOException;
import java.util.Arrays;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FullStatement<S extends IStatement>
implements IReference<S> {
    public final StatementType<S> type;
    public final int maxParams;
    public boolean canInteract = true;
    private final IStatementChangeListener listener;
    private final IStatementParameter[] params;
    private final ParamRef[] paramRefs;
    private S statement;

    public FullStatement(StatementType<S> type, int maxParams, IStatementChangeListener listener) {
        this.type = type;
        this.statement = (IStatement)type.defaultStatement;
        this.listener = listener;
        this.maxParams = maxParams;
        this.params = new IStatementParameter[maxParams];
        this.paramRefs = new ParamRef[maxParams];
        for (int i = 0; i < maxParams; ++i) {
            this.paramRefs[i] = new ParamRef(this, i);
        }
    }

    public void readFromNbt(NBTTagCompound nbt) {
        this.statement = (IStatement)this.type.readFromNbt(nbt.func_74775_l("s"));
        if (this.statement == null) {
            Arrays.fill(this.params, null);
        } else {
            for (int p = 0; p < this.params.length; ++p) {
                NBTTagCompound pNbt = nbt.func_74775_l(Integer.toString(p));
                this.params[p] = StatementTypeParam.INSTANCE.readFromNbt(pNbt);
            }
        }
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.statement != null) {
            nbt.func_74782_a("s", (NBTBase)this.type.writeToNbt(this.statement));
            for (int p = 0; p < this.params.length; ++p) {
                IStatementParameter param = this.params[p];
                if (param == null) continue;
                nbt.func_74782_a(Integer.toString(p), (NBTBase)StatementTypeParam.INSTANCE.writeToNbt(param));
            }
        }
        return nbt;
    }

    public void readFromBuffer(PacketBufferBC buffer) throws IOException {
        if (buffer.readBoolean()) {
            this.statement = (IStatement)this.type.readFromBuffer(buffer);
            for (int p = 0; p < this.params.length; ++p) {
                this.params[p] = StatementTypeParam.INSTANCE.readFromBuffer(buffer);
            }
        } else {
            this.statement = (IStatement)this.type.defaultStatement;
            Arrays.fill(this.params, null);
        }
    }

    public void writeToBuffer(PacketBufferBC buffer) {
        if (this.statement == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            this.type.writeToBuffer(buffer, this.statement);
            for (int p = 0; p < this.params.length; ++p) {
                IStatementParameter param = this.params[p];
                StatementTypeParam.INSTANCE.writeToBuffer(buffer, param);
            }
        }
    }

    @Override
    public S get() {
        return this.statement;
    }

    @Override
    public void set(S to) {
        this.statement = to;
        if (this.statement == null) {
            Arrays.fill(this.params, null);
            return;
        }
        for (int i = 0; i < this.params.length; ++i) {
            this.params[i] = i > this.statement.maxParameters() ? null : this.statement.createParameter(this.params[i], i);
        }
    }

    @Override
    public boolean canSet(S value) {
        if (value == null) {
            return true;
        }
        return value.minParameters() <= this.params.length;
    }

    @Override
    public S convertToType(Object value) {
        IStatement val = (IStatement)IReference.super.convertToType(value);
        if (value != null && val == null) {
            return (S)((IStatement)this.type.convertToType(value));
        }
        return (S)val;
    }

    @Override
    public Class<S> getHeldType() {
        return this.type.clazz;
    }

    public IReference<IStatementParameter> getParamRef(int i) {
        return this.paramRefs[i];
    }

    public IStatementParameter get(int index) {
        return this.getParamRef(index).get();
    }

    public void set(int index, IStatementParameter param) {
        this.getParamRef(index).set(param);
    }

    public void set(S statement, IStatementParameter[] params) {
        this.set(statement);
        for (int i = Math.min(this.getParamCount(), params.length) - 1; i > 0; --i) {
            this.set(i, params[i]);
        }
    }

    public boolean canSet(int index, IStatementParameter param) {
        return this.getParamRef(index).canSet(param);
    }

    public int getParamCount() {
        return this.params.length;
    }

    public IStatementParameter[] getParameters() {
        return this.params;
    }

    public void postSetFromGui(int paramIndex) {
        if (this.listener != null) {
            this.listener.onChange(this, paramIndex);
        }
    }

    @FunctionalInterface
    public static interface IStatementChangeListener {
        public void onChange(FullStatement<?> var1, int var2);
    }

    static class ParamRef
    implements IReference<IStatementParameter> {
        public final IReference<? extends IStatement> statementRef;
        public final IStatementParameter[] array;
        public final int index;

        public ParamRef(FullStatement<?> full, int index) {
            this.statementRef = full;
            this.array = ((FullStatement)full).params;
            this.index = index;
        }

        @Override
        public IStatementParameter get() {
            return this.array[this.index];
        }

        @Override
        public void set(IStatementParameter to) {
            this.array[this.index] = to;
        }

        @Override
        public boolean canSet(IStatementParameter value) {
            IStatement statement = this.statementRef.get();
            if (statement == null) {
                return false;
            }
            return statement.createParameter(value, this.index) == value;
        }

        @Override
        public Class<IStatementParameter> getHeldType() {
            return IStatementParameter.class;
        }
    }
}

