/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.particle;

import buildcraft.lib.particle.IParticlePositionPipe;
import buildcraft.lib.particle.ParticlePosition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.Vec3d;

public enum ParticleDirectionalSpread implements IParticlePositionPipe
{
    SMALL(0.01),
    MEDIUM(0.02),
    LARGE(0.04),
    MASSIVE(0.08);

    private final double motionDiff;

    private ParticleDirectionalSpread(double motionDiff) {
        this.motionDiff = motionDiff;
    }

    @Override
    public List<ParticlePosition> pipe(ParticlePosition pos) {
        ArrayList<ParticlePosition> list = new ArrayList<ParticlePosition>();
        Vec3d nMotion = this.modifyMotion(pos.motion);
        list.add(new ParticlePosition(pos.position, nMotion));
        return list;
    }

    private Vec3d modifyMotion(Vec3d motion) {
        double dx = this.getRandom();
        double dy = this.getRandom();
        double dz = this.getRandom();
        return motion.func_72441_c(dx, dy, dz);
    }

    private double getRandom() {
        return (Math.random() - 0.5) * this.motionDiff;
    }
}

