/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.particle;

import buildcraft.lib.particle.IParticlePositionPipe;
import buildcraft.lib.particle.ParticlePosition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.GameSettings;

public enum ParticleCountMultiplier implements IParticlePositionPipe
{
    MINIMAL(2),
    DECREASED(7),
    ALL(13);

    private final int numExpanses;

    public static ParticleCountMultiplier getForOption() {
        GameSettings gs = Minecraft.func_71410_x().field_71474_y;
        int count = gs.field_74362_aa % 3;
        if (count == 0) {
            return ALL;
        }
        if (count == 1) {
            return DECREASED;
        }
        return MINIMAL;
    }

    public static IParticlePositionPipe getOptionProvider() {
        return pos -> ParticleCountMultiplier.getForOption().pipe(pos);
    }

    private ParticleCountMultiplier(int numExpanses) {
        this.numExpanses = numExpanses;
    }

    @Override
    public List<ParticlePosition> pipe(ParticlePosition pos) {
        ArrayList<ParticlePosition> list = new ArrayList<ParticlePosition>();
        for (int i = 0; i < this.numExpanses; ++i) {
            list.add(new ParticlePosition(pos.position, pos.motion));
        }
        return list;
    }
}

