/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.mj;

import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.IMjReadable;
import buildcraft.api.mj.IMjReceiver;
import buildcraft.api.mj.MjBattery;
import javax.annotation.Nonnull;

public class MjBatteryReceiver
implements IMjReceiver,
IMjReadable {
    private final MjBattery battery;

    public MjBatteryReceiver(MjBattery battery) {
        this.battery = battery;
    }

    @Override
    public boolean canConnect(@Nonnull IMjConnector other) {
        return true;
    }

    @Override
    public long getPowerRequested() {
        return this.battery.getCapacity() - this.battery.getStored();
    }

    @Override
    public long receivePower(long microJoules, boolean simulate) {
        return this.battery.addPowerChecking(microJoules, simulate);
    }

    @Override
    public long getStored() {
        return this.battery.getStored();
    }

    @Override
    public long getCapacity() {
        return this.battery.getCapacity();
    }
}

