/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

import buildcraft.api.core.IBox;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.StringUtilBC;
import buildcraft.lib.misc.VecUtil;
import buildcraft.lib.misc.data.AxisOrder;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BoxIterator
implements Iterator<BlockPos> {
    @Nonnull
    private final BlockPos min;
    @Nonnull
    private final BlockPos max;
    private final boolean invert;
    private final boolean repeat;
    private AxisOrder order;
    private BlockPos current;
    private boolean hasRepeated = false;

    public BoxIterator(IBox box, AxisOrder order, boolean invert) {
        this(box.min(), box.max(), order, invert);
    }

    public BoxIterator(BlockPos min, BlockPos max, AxisOrder order, boolean invert) {
        this(min, max, invert, false, order, null);
    }

    private BoxIterator(BlockPos min, BlockPos max, boolean invert, boolean repeat, AxisOrder order, BlockPos current) {
        if (min == null) {
            throw new NullPointerException("min");
        }
        if (max == null) {
            throw new NullPointerException("max");
        }
        if (order == null) {
            throw new NullPointerException("order");
        }
        this.min = min;
        this.max = max;
        this.invert = invert;
        this.repeat = repeat;
        this.order = order;
        this.current = current == null ? this.getStart() : current;
    }

    public static BoxIterator readFromNbt(NBTTagCompound nbt) {
        BlockPos min = NBTUtilBC.readBlockPos(nbt.func_74781_a("min"));
        BlockPos max = NBTUtilBC.readBlockPos(nbt.func_74781_a("max"));
        boolean invert = nbt.func_74767_n("invert");
        boolean repeat = false;
        AxisOrder order = AxisOrder.readNbt(nbt.func_74775_l("order"));
        BlockPos current = NBTUtilBC.readBlockPos(nbt.func_74781_a("current"));
        if (min == null || max == null || order == null) {
            return null;
        }
        return new BoxIterator(min, max, invert, repeat, order, current);
    }

    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("min", (NBTBase)NBTUtilBC.writeBlockPos(this.min));
        nbt.func_74782_a("max", (NBTBase)NBTUtilBC.writeBlockPos(this.max));
        nbt.func_74757_a("invert", this.invert);
        nbt.func_74782_a("order", (NBTBase)this.order.writeNBT());
        if (this.current != null) {
            nbt.func_74782_a("current", (NBTBase)NBTUtilBC.writeBlockPos(this.current));
        }
        return nbt;
    }

    private BlockPos getStart() {
        BlockPos pos = BlockPos.field_177992_a;
        pos = this.replace(pos, this.order.first);
        pos = this.replace(pos, this.order.second);
        return this.replace(pos, this.order.third);
    }

    private BlockPos replace(BlockPos toReplace, EnumFacing facing) {
        BlockPos with = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.min : this.max;
        return VecUtil.replaceValue((Vec3i)toReplace, facing.func_176740_k(), VecUtil.getValue((Vec3i)with, facing.func_176740_k()));
    }

    public BlockPos getCurrent() {
        return this.current;
    }

    @Nonnull
    public BlockPos getMin() {
        return this.min;
    }

    @Nonnull
    public BlockPos getMax() {
        return this.max;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public AxisOrder getOrder() {
        return this.order;
    }

    public String toString() {
        return "{BoxIterator [" + StringUtilBC.blockPosToString(this.min) + "] -> [" + StringUtilBC.blockPosToString(this.max) + "] @ " + StringUtilBC.blockPosToString(this.current) + " order: [" + this.order + "]" + (this.invert ? " inverting" : "") + (this.repeat ? " repeating" : "") + " }";
    }

    public BlockPos advance() {
        if (this.current == null) {
            this.current = this.getStart();
            return this.getCurrent();
        }
        this.current = BoxIterator.increment(this.current, this.order.first);
        if (this.shouldReset(this.order.first)) {
            if (this.invert) {
                this.order = this.order.invertFirst();
            }
            this.current = this.replace(this.current, this.order.first);
            this.current = BoxIterator.increment(this.current, this.order.second);
            if (this.shouldReset(this.order.second)) {
                if (this.invert) {
                    this.order = this.order.invertSecond();
                }
                this.current = this.replace(this.current, this.order.second);
                this.current = BoxIterator.increment(this.current, this.order.third);
                if (this.shouldReset(this.order.third)) {
                    if (this.repeat) {
                        if (this.invert) {
                            this.order = this.order.invertThird();
                        }
                        this.current = this.replace(this.current, this.order.third);
                        this.hasRepeated = true;
                    } else {
                        this.current = null;
                    }
                }
            }
        }
        return this.getCurrent();
    }

    private static BlockPos increment(BlockPos pos, EnumFacing facing) {
        int diff = facing.func_176743_c().func_179524_a();
        int value = VecUtil.getValue((Vec3i)pos, facing.func_176740_k()) + diff;
        return VecUtil.replaceValue((Vec3i)pos, facing.func_176740_k(), value);
    }

    private boolean shouldReset(EnumFacing facing) {
        int lstReturned = VecUtil.getValue((Vec3i)this.current, facing.func_176740_k());
        BlockPos goingTo = facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? this.max : this.min;
        int to = VecUtil.getValue((Vec3i)goingTo, facing.func_176740_k());
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            return lstReturned > to;
        }
        return lstReturned < to;
    }

    public boolean contains(BlockPos pos) {
        if (pos.func_177958_n() < this.min.func_177958_n() || pos.func_177958_n() > this.max.func_177958_n()) {
            return false;
        }
        if (pos.func_177956_o() < this.min.func_177956_o() || pos.func_177956_o() > this.max.func_177956_o()) {
            return false;
        }
        return pos.func_177952_p() >= this.min.func_177952_p() && pos.func_177952_p() <= this.max.func_177952_p();
    }

    public boolean willVisit(BlockPos pos) {
        if (!this.contains(pos)) {
            return false;
        }
        if (this.current == null) {
            return true;
        }
        return this.compare(pos) < 0;
    }

    public boolean hasVisited(BlockPos pos) {
        if (!this.contains(pos)) {
            return false;
        }
        if (this.current == null && !this.hasRepeated) {
            return false;
        }
        return this.compare(pos) >= 0;
    }

    private int compare(BlockPos pos) {
        int cmp = this.compare(pos, this.order.third);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.compare(pos, this.order.second);
        if (cmp != 0) {
            return cmp;
        }
        return this.compare(pos, this.order.first);
    }

    private int compare(BlockPos pos, EnumFacing direction) {
        int argVal = VecUtil.getValue((Vec3i)pos, direction.func_176740_k());
        int currentVal = VecUtil.getValue((Vec3i)this.current, direction.func_176740_k());
        return (currentVal - argVal) * direction.func_176743_c().func_179524_a();
    }

    public void moveTo(BlockPos pos) {
        BlockPos size;
        int sizeB;
        if (!this.contains(pos)) {
            throw new IllegalArgumentException("This " + this + " doesn't contain " + pos + "!");
        }
        EnumFacing a = this.order.first;
        EnumFacing b = this.order.second;
        EnumFacing c = this.order.third;
        int valueA = VecUtil.getValue((Vec3i)pos, a.func_176740_k());
        int valueB = VecUtil.getValue((Vec3i)pos, b.func_176740_k());
        int valueC = VecUtil.getValue((Vec3i)pos, c.func_176740_k());
        int boundA = VecUtil.getValue((Vec3i)this.max, (Vec3i)this.min, a);
        int boundB = VecUtil.getValue((Vec3i)this.max, (Vec3i)this.min, b);
        int boundC = VecUtil.getValue((Vec3i)this.max, (Vec3i)this.min, c);
        if (!this.invert) {
            if (valueA != boundA) {
                this.current = pos.func_177972_a(a.func_176734_d());
                return;
            }
            if (valueB != boundB) {
                this.current = pos.func_177972_a(b.func_176734_d());
                this.current = VecUtil.replaceValue((Vec3i)this.current, a.func_176740_k(), VecUtil.getValue((Vec3i)this.min, (Vec3i)this.max, a));
                return;
            }
            if (valueC != boundC) {
                this.current = pos.func_177972_a(c.func_176734_d());
                this.current = VecUtil.replaceValue((Vec3i)this.current, a.func_176740_k(), VecUtil.getValue((Vec3i)this.min, (Vec3i)this.max, a));
                this.current = VecUtil.replaceValue((Vec3i)this.current, b.func_176740_k(), VecUtil.getValue((Vec3i)this.min, (Vec3i)this.max, b));
                return;
            }
            this.current = null;
            return;
        }
        if (this.current == null) {
            this.current = this.getStart();
        }
        int db = this.compare(pos, b);
        int dc = this.compare(pos, c);
        if ((dc * (sizeB = 1 + VecUtil.getValue((Vec3i)(size = this.max.func_177973_b((Vec3i)this.min)), b.func_176740_k())) + db) % 2 == 1) {
            this.order = this.order.invertFirst();
        }
        if (dc % 2 == 1) {
            this.order = this.order.invertSecond();
        }
        a = this.order.first;
        b = this.order.second;
        c = this.order.third;
        boundA = VecUtil.getValue((Vec3i)this.max, (Vec3i)this.min, a);
        boundB = VecUtil.getValue((Vec3i)this.max, (Vec3i)this.min, b);
        boundC = VecUtil.getValue((Vec3i)this.max, (Vec3i)this.min, c);
        if (valueA != boundA) {
            this.current = pos.func_177972_a(this.order.first.func_176734_d());
        } else if (valueB != boundB) {
            this.current = pos.func_177972_a(this.order.second.func_176734_d());
            this.order = this.order.invertFirst();
        } else if (valueC != boundC) {
            this.current = pos.func_177972_a(this.order.third.func_176734_d());
            this.order = this.order.invertFirst();
            this.order = this.order.invertSecond();
        } else {
            this.current = null;
        }
    }

    public boolean hasFinished() {
        return this.current == null;
    }

    @Override
    public boolean hasNext() {
        return !this.hasFinished();
    }

    @Override
    public BlockPos next() {
        BlockPos c = this.current;
        this.advance();
        return c;
    }
}

