/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.IBox;
import buildcraft.lib.client.render.laser.LaserData_BC8;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.PositionUtil;
import buildcraft.lib.misc.VecUtil;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Box
implements IBox {
    @SideOnly(value=Side.CLIENT)
    public LaserData_BC8[] laserData;
    @SideOnly(value=Side.CLIENT)
    public BlockPos lastMin;
    @SideOnly(value=Side.CLIENT)
    public BlockPos lastMax;
    @SideOnly(value=Side.CLIENT)
    public LaserData_BC8.LaserType lastType;
    private BlockPos min;
    private BlockPos max;

    public Box() {
        this.reset();
    }

    public Box(BlockPos min, BlockPos max) {
        this();
        this.min = VecUtil.min(min, max);
        this.max = VecUtil.max(min, max);
    }

    public Box(TileEntity e) {
        this(e.func_174877_v(), e.func_174877_v());
    }

    public void reset() {
        this.min = null;
        this.max = null;
    }

    public boolean isInitialized() {
        return this.min != null && this.max != null;
    }

    public void extendToEncompassBoth(BlockPos newMin, BlockPos newMax) {
        this.min = VecUtil.min(this.min, newMin, newMax);
        this.max = VecUtil.max(this.max, newMin, newMax);
    }

    public void setMin(BlockPos min) {
        if (min == null) {
            return;
        }
        this.min = min;
        this.max = VecUtil.max(min, this.max);
    }

    public void setMax(BlockPos max) {
        if (max == null) {
            return;
        }
        this.min = VecUtil.min(this.min, max);
        this.max = max;
    }

    public void initialize(IBox box) {
        this.reset();
        this.extendToEncompassBoth(box.min(), box.max());
    }

    public void initialize(IAreaProvider a) {
        this.reset();
        this.extendToEncompassBoth(a.min(), a.max());
    }

    public void initialize(NBTTagCompound nbt) {
        this.reset();
        if (nbt.func_74764_b("xMin")) {
            this.min = new BlockPos(nbt.func_74762_e("xMin"), nbt.func_74762_e("yMin"), nbt.func_74762_e("zMin"));
            this.max = new BlockPos(nbt.func_74762_e("xMax"), nbt.func_74762_e("yMax"), nbt.func_74762_e("zMax"));
        } else {
            this.min = NBTUtilBC.readBlockPos(nbt.func_74781_a("min"));
            this.max = NBTUtilBC.readBlockPos(nbt.func_74781_a("max"));
        }
        this.extendToEncompassBoth(this.min, this.max);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.min != null) {
            nbt.func_74782_a("min", (NBTBase)NBTUtilBC.writeBlockPos(this.min));
        }
        if (this.max != null) {
            nbt.func_74782_a("max", (NBTBase)NBTUtilBC.writeBlockPos(this.max));
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return nbt;
    }

    public void initializeCenter(BlockPos center, int size) {
        this.initializeCenter(center, (Vec3i)new BlockPos(size, size, size));
    }

    public void initializeCenter(BlockPos center, Vec3i size) {
        this.extendToEncompassBoth(center.func_177973_b(size), center.func_177971_a(size));
    }

    public List<BlockPos> getBlocksInArea() {
        ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.min, (BlockPos)this.max)) {
            blocks.add(pos);
        }
        return blocks;
    }

    public List<BlockPos> getBlocksOnEdge() {
        return PositionUtil.getAllOnEdge(this.min, this.max);
    }

    @Override
    public Box expand(int amount) {
        if (!this.isInitialized()) {
            return this;
        }
        BlockPos am = new BlockPos(amount, amount, amount);
        this.setMin(this.min().func_177973_b((Vec3i)am));
        this.setMax(this.max().func_177971_a((Vec3i)am));
        return this;
    }

    @Override
    public IBox contract(int amount) {
        return this.expand(-amount);
    }

    @Override
    public boolean contains(Vec3d p) {
        AxisAlignedBB bb = this.getBoundingBox();
        if (p.field_72450_a < bb.field_72340_a || p.field_72450_a >= bb.field_72336_d) {
            return false;
        }
        if (p.field_72448_b < bb.field_72338_b || p.field_72448_b >= bb.field_72337_e) {
            return false;
        }
        return !(p.field_72449_c < bb.field_72339_c) && !(p.field_72449_c >= bb.field_72334_f);
    }

    public boolean contains(BlockPos i) {
        return this.contains(new Vec3d((Vec3i)i));
    }

    @Override
    public BlockPos min() {
        return this.min;
    }

    @Override
    public BlockPos max() {
        return this.max;
    }

    @Override
    public BlockPos size() {
        if (!this.isInitialized()) {
            return BlockPos.field_177992_a;
        }
        return this.max.func_177973_b((Vec3i)this.min).func_177971_a((Vec3i)VecUtil.POS_ONE);
    }

    public BlockPos center() {
        return new BlockPos(this.centerExact());
    }

    public Vec3d centerExact() {
        return new Vec3d((Vec3i)this.size()).func_186678_a(0.5).func_178787_e(new Vec3d((Vec3i)this.min()));
    }

    public String toString() {
        return "Box[min = " + this.min + ", max = " + this.max + "]";
    }

    public Box extendToEncompass(IBox toBeContained) {
        if (toBeContained == null) {
            return this;
        }
        this.extendToEncompassBoth(toBeContained.min(), toBeContained.max());
        return this;
    }

    public AxisAlignedBB getBoundingBox() {
        return new AxisAlignedBB(this.min, this.max.func_177971_a((Vec3i)VecUtil.POS_ONE));
    }

    public Box extendToEncompass(Vec3d toBeContained) {
        this.setMin(VecUtil.min(this.min, VecUtil.convertFloor(toBeContained)));
        this.setMax(VecUtil.max(this.max, VecUtil.convertCeiling(toBeContained)));
        return this;
    }

    public Box extendToEncompass(BlockPos toBeContained) {
        this.setMin(VecUtil.min(this.min, toBeContained));
        this.setMax(VecUtil.max(this.max, toBeContained));
        return this;
    }

    @Override
    public double distanceTo(BlockPos index) {
        return Math.sqrt(this.distanceToSquared(index));
    }

    @Override
    public double distanceToSquared(BlockPos index) {
        return this.closestInsideTo(index).func_177951_i((Vec3i)index);
    }

    public BlockPos closestInsideTo(BlockPos toTest) {
        return VecUtil.max(this.min, VecUtil.min(this.max, toTest));
    }

    @Override
    public BlockPos getRandomBlockPos(Random rand) {
        return PositionUtil.randomBlockPos(rand, this.min, this.max.func_177982_a(1, 1, 1));
    }

    public boolean isCorner(BlockPos pos) {
        return PositionUtil.isCorner(this.min, this.max, pos);
    }

    public boolean isOnEdge(BlockPos pos) {
        return PositionUtil.isOnEdge(this.min, this.max, pos);
    }

    public boolean isOnFace(BlockPos pos) {
        return PositionUtil.isOnFace(this.min, this.max, pos);
    }

    public boolean doesIntersectWith(Box box) {
        if (this.isInitialized() && box.isInitialized()) {
            return this.min.func_177958_n() <= box.max.func_177958_n() && this.max.func_177958_n() >= box.min.func_177958_n() && this.min.func_177956_o() <= box.max.func_177956_o() && this.max.func_177956_o() >= box.min.func_177956_o() && this.min.func_177952_p() <= box.max.func_177952_p() && this.max.func_177952_p() >= box.min.func_177952_p();
        }
        return false;
    }

    @Nullable
    public Box getIntersect(Box box) {
        if (this.doesIntersectWith(box)) {
            BlockPos min2 = VecUtil.max(this.min, box.min);
            BlockPos max2 = VecUtil.min(this.max, box.max);
            return new Box(min2, max2);
        }
        return null;
    }

    public int getBlocksOnEdgeCount() {
        return PositionUtil.getCountOnEdge(this.min(), this.max());
    }

    public void readData(PacketBuffer stream) {
        if (stream.readBoolean()) {
            this.min = MessageUtil.readBlockPos(stream);
            this.max = MessageUtil.readBlockPos(stream);
        } else {
            this.min = null;
            this.max = null;
        }
    }

    public void writeData(PacketBuffer stream) {
        boolean isValid = this.isInitialized();
        stream.writeBoolean(isValid);
        if (isValid) {
            MessageUtil.writeBlockPos(stream, this.min);
            MessageUtil.writeBlockPos(stream, this.max);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Box box = (Box)obj;
        if (!Objects.equal((Object)this.min, (Object)box.min)) {
            return false;
        }
        return Objects.equal((Object)this.max, (Object)box.max);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.min, this.max});
    }
}

