/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.enums.EnumPowerStage;
import buildcraft.api.tiles.IControllable;
import buildcraft.lib.BCLib;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.NodeType;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.pos.PositionAbsolute;
import buildcraft.lib.misc.ColourUtil;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;

public class ExpressionCompat {
    public static final FunctionContext RENDERING = DefaultContexts.RENDERING;
    public static final NodeType<EnumFacing.Axis> ENUM_AXIS = new NodeType<EnumFacing.Axis>("Axis", EnumFacing.Axis.X);
    public static final NodeType<EnumFacing> ENUM_FACING;
    public static final NodeType<EnumDyeColor> ENUM_DYE_COLOUR;
    public static final NodeType<EnumPowerStage> ENUM_POWER_STAGE;
    public static final NodeType<IControllable.Mode> ENUM_CONTROL_MODE;
    public static final NodeType<IGuiPosition> GUI_POSITION;
    public static final NodeType<IGuiArea> GUI_AREA;

    public static void setup() {
    }

    private static long convertColourToAbgr(String c) {
        EnumDyeColor colour = ColourUtil.parseColourOrNull(c);
        if (colour == null) {
            return -1L;
        }
        return 0xFF000000 | ColourUtil.swapArgbToAbgr(ColourUtil.getLightHex(colour));
    }

    private static long convertColourToArgb(String c) {
        EnumDyeColor colour = ColourUtil.parseColourOrNull(c);
        if (colour == null) {
            return -1L;
        }
        return 0xFF000000 | ColourUtil.getLightHex(colour);
    }

    static {
        NodeTypes.addType("Axis", ENUM_AXIS);
        for (EnumFacing.Axis axis : EnumFacing.Axis.values()) {
            ENUM_AXIS.putConstant("" + axis, axis);
        }
        ENUM_FACING = new NodeType<EnumFacing>("Facing", EnumFacing.UP);
        NodeTypes.addType("Facing", ENUM_FACING);
        ENUM_FACING.put_t_t("getOpposite", EnumFacing::func_176734_d);
        ENUM_FACING.put_t_o("getAxis", EnumFacing.Axis.class, EnumFacing::func_176740_k);
        ENUM_FACING.put_t_o("(string)", String.class, EnumFacing::func_176610_l);
        for (EnumFacing enumFacing : EnumFacing.values()) {
            ENUM_FACING.putConstant("" + enumFacing, enumFacing);
        }
        ENUM_DYE_COLOUR = new NodeType<EnumDyeColor>("Dye Colour", EnumDyeColor.WHITE);
        NodeTypes.addType("DyeColor", ENUM_DYE_COLOUR);
        NodeTypes.addType("DyeColour", ENUM_DYE_COLOUR);
        ENUM_DYE_COLOUR.put_t_l("to_argb", c -> 0xFF000000 | ColourUtil.getLightHex(c));
        ENUM_DYE_COLOUR.put_t_o("(string)", String.class, EnumDyeColor::func_176610_l);
        for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
            ENUM_DYE_COLOUR.putConstant("" + enumDyeColor, enumDyeColor);
        }
        ENUM_POWER_STAGE = new NodeType<EnumPowerStage>("Engine Power Stage", EnumPowerStage.BLUE);
        NodeTypes.addType("EnginePowerStage", ENUM_POWER_STAGE);
        ENUM_POWER_STAGE.put_t_o("(string)", String.class, EnumPowerStage::func_176610_l);
        for (EnumPowerStage enumPowerStage : EnumPowerStage.VALUES) {
            ENUM_POWER_STAGE.putConstant("" + (Object)((Object)enumPowerStage), enumPowerStage);
        }
        try {
            IControllable.Mode.ON.name();
        }
        catch (NoSuchFieldError noSuchFieldError) {
            throw BCLib.throwBadClass(noSuchFieldError, IControllable.Mode.class);
        }
        ENUM_CONTROL_MODE = new NodeType<IControllable.Mode>("Controllable Mode", IControllable.Mode.class, IControllable.Mode.ON);
        NodeTypes.addType("ControlMode", ENUM_CONTROL_MODE);
        ENUM_CONTROL_MODE.put_t_o("(string)", String.class, e -> e.lowerCaseName);
        for (IControllable.Mode mode : IControllable.Mode.VALUES) {
            ENUM_CONTROL_MODE.putConstant("" + (Object)((Object)mode), mode);
        }
        GUI_POSITION = new NodeType<PositionAbsolute>("Gui Position", IGuiPosition.class, new PositionAbsolute(0.0, 0.0));
        GUI_AREA = new NodeType<GuiRectangle>("Gui Area", IGuiArea.class, new GuiRectangle(0.0, 0.0));
        NodeTypes.addType("GuiPosition", GUI_POSITION);
        NodeTypes.addType("GuiArea", GUI_AREA);
        GUI_POSITION.put_oo_t("pos", IExpressionNode.INodeDouble.class, IExpressionNode.INodeDouble.class, IGuiPosition::create);
        GUI_POSITION.put_tt_t("+", IGuiPosition::offset);
        GUI_POSITION.put_tt_t("-", (a, b) -> a.offset(() -> -b.getX(), () -> -b.getY()));
        GUI_POSITION.put_too_t("offset", IExpressionNode.INodeDouble.class, IExpressionNode.INodeDouble.class, IGuiPosition::offset);
        GUI_AREA.put_oo_t("area", IExpressionNode.INodeDouble.class, IExpressionNode.INodeDouble.class, IGuiArea::create);
        GUI_AREA.put_oooo_t("area", IExpressionNode.INodeDouble.class, IExpressionNode.INodeDouble.class, IExpressionNode.INodeDouble.class, IExpressionNode.INodeDouble.class, IGuiArea::create);
        GUI_AREA.put_to_t("+", IGuiPosition.class, IGuiArea::offset);
        GUI_AREA.put_ot_t("+", IGuiPosition.class, (b, a) -> a.offset((IGuiPosition)b));
        GUI_AREA.put_to_t("offset", IGuiPosition.class, IGuiArea::offset);
        GUI_AREA.put_too_t("offset", IExpressionNode.INodeDouble.class, IExpressionNode.INodeDouble.class, IGuiArea::offset);
        GUI_AREA.put_to_t("expand", IExpressionNode.INodeDouble.class, IGuiArea::expand);
        GUI_AREA.put_too_t("expand", IExpressionNode.INodeDouble.class, IExpressionNode.INodeDouble.class, IGuiArea::expand);
        GUI_AREA.put_too_t("resize", IExpressionNode.INodeDouble.class, IExpressionNode.INodeDouble.class, IGuiArea::resize);
        RENDERING.put_s_l("convertColourToAbgr", ExpressionCompat::convertColourToAbgr);
        RENDERING.put_s_l("convertColourToArgb", ExpressionCompat::convertColourToArgb);
    }
}

