/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.list;

import buildcraft.api.lists.ListMatchHandler;
import buildcraft.api.lists.ListRegistry;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.StackUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class ListHandler {
    public static final int WIDTH = 9;
    public static final int HEIGHT = 2;

    private ListHandler() {
    }

    public static boolean hasItems(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        for (Line l : ListHandler.getLines(stack)) {
            if (!l.hasItems()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDefault(@Nonnull ItemStack stack) {
        if (!stack.func_77942_o()) {
            return true;
        }
        for (Line l : ListHandler.getLines(stack)) {
            if (l.isDefault()) continue;
            return false;
        }
        return true;
    }

    public static Line[] getLines(@Nonnull ItemStack item) {
        NBTTagCompound data = NBTUtilBC.getItemData(item);
        if (data.func_74764_b("written") && data.func_74764_b("lines")) {
            NBTTagList list = data.func_150295_c("lines", 10);
            Line[] lines = new Line[list.func_74745_c()];
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = Line.fromNBT(list.func_150305_b(i));
            }
            return lines;
        }
        Line[] lines = new Line[2];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = new Line();
        }
        return lines;
    }

    public static void saveLines(@Nonnull ItemStack stackList, Line[] lines) {
        NBTTagCompound data;
        boolean hasLine = false;
        for (Line l : lines) {
            if (l.isDefault()) continue;
            hasLine = true;
            break;
        }
        if (hasLine) {
            data = NBTUtilBC.getItemData(stackList);
            data.func_74757_a("written", true);
            NBTTagList lineList = new NBTTagList();
            for (Line saving : lines) {
                lineList.func_74742_a((NBTBase)saving.toNBT());
            }
            data.func_74782_a("lines", (NBTBase)lineList);
        } else if (stackList.func_77942_o()) {
            data = NBTUtilBC.getItemData(stackList);
            data.func_82580_o("written");
            data.func_82580_o("lines");
            if (data.func_82582_d()) {
                stackList.func_77982_d(null);
            }
        }
    }

    public static boolean matches(@Nonnull ItemStack stackList, @Nonnull ItemStack item) {
        NBTTagCompound data = NBTUtilBC.getItemData(stackList);
        if (data.func_74764_b("written") && data.func_74764_b("lines")) {
            NBTTagList list = data.func_150295_c("lines", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                Line line = Line.fromNBT(list.func_150305_b(i));
                if (!line.matches(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Line {
        public final NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)9, (Object)StackUtil.EMPTY);
        public boolean precise;
        public boolean byType;
        public boolean byMaterial;

        public boolean isDefault() {
            if (this.precise || this.byType || this.byMaterial) {
                return false;
            }
            return !this.hasItems();
        }

        public boolean hasItems() {
            for (ItemStack stack : this.stacks) {
                if (stack.func_190926_b()) continue;
                return true;
            }
            return false;
        }

        public boolean isOneStackMode() {
            return this.byType || this.byMaterial;
        }

        public boolean getOption(int id) {
            return id == 0 ? this.precise : (id == 1 ? this.byType : this.byMaterial);
        }

        public void toggleOption(int id) {
            if (!(this.byType || this.byMaterial || id != 1 && id != 2)) {
                for (int i = 1; i < this.stacks.size(); ++i) {
                    this.stacks.set(i, (Object)StackUtil.EMPTY);
                }
            }
            switch (id) {
                case 0: {
                    this.precise = !this.precise;
                    break;
                }
                case 1: {
                    this.byType = !this.byType;
                    break;
                }
                case 2: {
                    this.byMaterial = !this.byMaterial;
                }
            }
        }

        public boolean matches(@Nonnull ItemStack target) {
            if (this.byType || this.byMaterial) {
                ItemStack compare = (ItemStack)this.stacks.get(0);
                if (compare.func_190926_b()) {
                    return false;
                }
                List<ListMatchHandler> handlers = ListRegistry.getHandlers();
                ListMatchHandler.Type type = this.getSortingType();
                boolean anyHandled = false;
                for (ListMatchHandler h : handlers) {
                    if (h.matches(type, compare, target, this.precise)) {
                        return true;
                    }
                    if (!h.isValidSource(type, target)) continue;
                    anyHandled = true;
                }
                if (!anyHandled && type == ListMatchHandler.Type.TYPE && target.func_77981_g()) {
                    return StackUtil.isMatchingItem(compare, target, false, false);
                }
            } else {
                for (ItemStack s : this.stacks) {
                    if (s == null || !StackUtil.isMatchingItem(s, target, true, this.precise) || this.precise && s.func_77952_i() != target.func_77952_i()) continue;
                    return true;
                }
            }
            return false;
        }

        public ListMatchHandler.Type getSortingType() {
            return this.byType ? (this.byMaterial ? ListMatchHandler.Type.CLASS : ListMatchHandler.Type.TYPE) : ListMatchHandler.Type.MATERIAL;
        }

        public static Line fromNBT(NBTTagCompound data) {
            Line line = new Line();
            if (data != null && data.func_74764_b("st")) {
                NBTTagList l = data.func_150295_c("st", 10);
                for (int i = 0; i < l.func_74745_c(); ++i) {
                    line.stacks.set(i, (Object)new ItemStack(l.func_150305_b(i)));
                }
                line.precise = data.func_74767_n("Fp");
                line.byType = data.func_74767_n("Ft");
                line.byMaterial = data.func_74767_n("Fm");
            }
            return line;
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound data = new NBTTagCompound();
            NBTTagList stackList = new NBTTagList();
            for (ItemStack stack1 : this.stacks) {
                NBTTagCompound stack = new NBTTagCompound();
                if (stack1 != null) {
                    stack1.func_77955_b(stack);
                }
                stackList.func_74742_a((NBTBase)stack);
            }
            data.func_74782_a("st", (NBTBase)stackList);
            data.func_74757_a("Fp", this.precise);
            data.func_74757_a("Ft", this.byType);
            data.func_74757_a("Fm", this.byMaterial);
            return data;
        }

        public void setStack(int slotIndex, @Nonnull ItemStack stack) {
            if (slotIndex == 0 || !this.byType && !this.byMaterial) {
                if (stack.func_190926_b()) {
                    this.stacks.set(slotIndex, (Object)StackUtil.EMPTY);
                } else {
                    stack = stack.func_77946_l();
                    stack.func_190920_e(1);
                    this.stacks.set(slotIndex, (Object)stack);
                }
            }
        }

        @Nonnull
        public ItemStack getStack(int i) {
            if (i < 0 || i >= this.stacks.size()) {
                return StackUtil.EMPTY;
            }
            return (ItemStack)this.stacks.get(i);
        }

        @SideOnly(value=Side.CLIENT)
        public NonNullList<ItemStack> getExamples() {
            NonNullList examples;
            ItemStack firstStack = (ItemStack)this.stacks.get(0);
            if (firstStack.func_190926_b()) {
                return NonNullList.func_191197_a((int)0, (Object)StackUtil.EMPTY);
            }
            NonNullList stackList = NonNullList.func_191196_a();
            List<ListMatchHandler> handlers = ListRegistry.getHandlers();
            ArrayList<ListMatchHandler> handlersCustom = new ArrayList<ListMatchHandler>();
            ListMatchHandler.Type type = this.getSortingType();
            for (ListMatchHandler h : handlers) {
                if (!h.isValidSource(type, firstStack)) continue;
                examples = h.getClientExamples(type, firstStack);
                if (examples != null) {
                    stackList.addAll((Collection)examples);
                    continue;
                }
                handlersCustom.add(h);
            }
            if (handlersCustom.size() > 0) {
                for (Item i : ForgeRegistries.ITEMS) {
                    examples = NonNullList.func_191196_a();
                    i.func_150895_a(CreativeTabs.field_78027_g, examples);
                    block2: for (ItemStack s : examples) {
                        for (ListMatchHandler mh : handlersCustom) {
                            if (!mh.matches(type, firstStack, s, false)) continue;
                            stackList.add((Object)s);
                            continue block2;
                        }
                    }
                }
            }
            Collections.shuffle(stackList);
            return stackList;
        }
    }
}

