/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.guide;

import buildcraft.api.registry.IScriptableRegistry;
import buildcraft.lib.guide.GuideContentsData;
import buildcraft.lib.misc.JsonUtil;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public final class GuideBook {
    public static final IScriptableRegistry.ISimpleEntryDeserializer<GuideBook> DESERIALISER = GuideBook::deserialize;
    public final ResourceLocation name;
    public final ResourceLocation itemIcon;
    public final ITextComponent title;
    public final boolean appendAllEntries;
    public final GuideContentsData data = new GuideContentsData(this);

    private static GuideBook deserialize(ResourceLocation name, JsonObject json, JsonDeserializationContext ctx) {
        ResourceLocation itemIcon = new ResourceLocation("buildcraftcore:guide_main");
        ITextComponent title = JsonUtil.getTextComponent(json, "title", "");
        boolean addAll = JsonUtils.func_151209_a((JsonObject)json, (String)"all_entries", (boolean)true);
        return new GuideBook(name, itemIcon, title, addAll);
    }

    public GuideBook(ResourceLocation name, ResourceLocation itemIcon, ITextComponent title, boolean appendAllEntries) {
        this.name = name;
        this.itemIcon = itemIcon;
        this.title = title;
        this.appendAllEntries = appendAllEntries;
    }

    public String toString() {
        return "GuideBook [ " + this.name + ", title = " + this.title + " ]";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.name.equals((Object)((GuideBook)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

