/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.GenericExpressionCompiler;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.elem.GuiElementText;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.gui.json.JsonGuiInfo;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.LocaleUtil;
import com.google.gson.JsonSyntaxException;

public class ElementTypeText
extends ElementType {
    public static final String NAME = "buildcraftlib:text";
    public static final ElementTypeText INSTANCE = new ElementTypeText();

    private ElementTypeText() {
        super(NAME);
    }

    @Override
    public IGuiElement deserialize0(BuildCraftJsonGui gui, IGuiPosition parent, JsonGuiInfo info, JsonGuiElement json) {
        IExpressionNode.INodeObject<String> text;
        FunctionContext ctx = ElementTypeText.createContext(json);
        IGuiPosition pos = ElementTypeText.resolvePosition(json, "pos", parent, ctx);
        String prop = json.properties.get("text");
        if (prop != null) {
            String localized = LocaleUtil.localize(prop);
            text = new NodeConstantObject<String>(String.class, localized);
        } else {
            prop = json.properties.get("expression");
            if (prop != null) {
                try {
                    text = GenericExpressionCompiler.compileExpressionString(prop, ctx);
                }
                catch (InvalidExpressionException e) {
                    throw new JsonSyntaxException("Invalid expression for '" + json.name + "'", (Throwable)e);
                }
            } else {
                throw new JsonSyntaxException("Require either 'text' or 'expression'!");
            }
        }
        int colour = json.properties.containsKey("colour") ? ElementTypeText.resolveEquationInt(json, "colour", ctx) : ElementTypeText.resolveEquationInt(json, "color", ctx);
        GuiElementText element = new GuiElementText((BuildCraftGui)gui, pos, text, colour);
        element.setCentered("true".equals(json.properties.get("centered")));
        element.setDropShadow("true".equals(json.properties.get("shadow")));
        element.setForeground("true".equals(json.properties.get("foreground")));
        return element;
    }
}

