/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.elem;

import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiElementSimple;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.IInteractionElement;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.MathUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ScrollbarElement
extends GuiElementSimple
implements IInteractionElement {
    private static final int HEIGHT = 14;
    private final GuiIcon background;
    private final GuiIcon scroller;
    private int pos;
    private int len;
    private boolean isClicking;

    public ScrollbarElement(BuildCraftGui gui, IGuiPosition parent, int height, GuiIcon background, GuiIcon scroller) {
        super(gui, new GuiRectangle(0.0, 0.0, 6.0, height).offset(parent));
        this.background = background;
        this.scroller = scroller;
    }

    @Override
    public void drawBackground(float partialTicks) {
        if (this.len > 0) {
            this.background.drawAt(this);
            this.scroller.drawAt(this.offset(0.0, (double)this.pos * (this.getHeight() - 14.0 + 2.0) / (double)this.len));
        }
    }

    private void updatePositionFromMouse() {
        double h = this.getHeight();
        this.setPosition(((this.gui.mouse.getY() - this.getY()) * (double)this.len + h / 2.0) / h);
    }

    @Override
    public void onMouseClicked(int button) {
        if (this.contains(this.gui.mouse) && button == 0) {
            this.isClicking = true;
            this.updatePositionFromMouse();
        }
    }

    @Override
    public void onMouseDragged(int button, long ticksSinceClick) {
        if (this.isClicking && button == 0) {
            this.updatePositionFromMouse();
        }
    }

    @Override
    public void onMouseReleased(int button) {
        if (this.isClicking && button == 0) {
            this.updatePositionFromMouse();
            this.isClicking = false;
        }
    }

    public int getPosition() {
        return this.pos;
    }

    public void setPosition(double pos) {
        this.pos = MathUtil.clamp(pos, 0, this.len);
    }

    public void setLength(int len) {
        this.len = len;
        this.setPosition(this.pos);
    }
}

