/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression;

import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.NodeFuncDoubleDoubleToDouble;
import buildcraft.lib.expression.node.value.NodeConstantDouble;

public class OptimizingInliningHelper {
    public static IExpressionNode tryOptimizedInline(IExpressionNode node) {
        if (OptimizingInliningHelper.isDoubleMultiply(node)) {
            NodeFuncDoubleDoubleToDouble.FuncDoubleDoubleToDouble n = (NodeFuncDoubleDoubleToDouble.FuncDoubleDoubleToDouble)node;
            IExpressionNode.INodeDouble n1 = n.argA.inline();
            IExpressionNode.INodeDouble n2 = n.argB.inline();
            boolean hasConst = false;
            if (n1 instanceof NodeConstantDouble) {
                if (n2 instanceof NodeConstantDouble) {
                    return new NodeConstantDouble(n1.evaluate() * n2.evaluate());
                }
                hasConst = true;
            } else if (n2 instanceof NodeConstantDouble) {
                IExpressionNode.INodeDouble t = n1;
                n1 = n2;
                n2 = t;
                hasConst = true;
            }
            if (hasConst) {
                if (OptimizingInliningHelper.isDoubleMultiply(n2)) {
                    NodeFuncDoubleDoubleToDouble.FuncDoubleDoubleToDouble mul2 = (NodeFuncDoubleDoubleToDouble.FuncDoubleDoubleToDouble)n2;
                    if (mul2.argA instanceof NodeConstantDouble) {
                        double c1 = n1.evaluate();
                        double c2 = mul2.argA.evaluate();
                        return NodeTypes.DoubleFunctions.MUL.create(new NodeConstantDouble(c1 * c2), mul2.argB);
                    }
                } else {
                    return NodeTypes.DoubleFunctions.MUL.create(n1, n2);
                }
            }
        }
        return null;
    }

    public static boolean isDoubleMultiply(IExpressionNode node) {
        NodeFuncBase base;
        return node instanceof NodeFuncBase.IFunctionNode && (base = ((NodeFuncBase.IFunctionNode)((Object)node)).getFunction()) == NodeTypes.DoubleFunctions.MUL;
    }
}

