/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model;

import buildcraft.lib.client.model.MutableVertex;
import buildcraft.lib.expression.VecDouble;
import buildcraft.lib.expression.VecLong;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point2f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class MutableQuad {
    public static final MutableQuad[] EMPTY_ARRAY = new MutableQuad[0];
    public final MutableVertex vertex_0 = new MutableVertex();
    public final MutableVertex vertex_1 = new MutableVertex();
    public final MutableVertex vertex_2 = new MutableVertex();
    public final MutableVertex vertex_3 = new MutableVertex();
    private int tintIndex = -1;
    private EnumFacing face = null;
    private boolean shade = false;
    private TextureAtlasSprite sprite = null;

    public MutableQuad() {
    }

    public MutableQuad(int tintIndex, EnumFacing face) {
        this(tintIndex, face, false);
    }

    public MutableQuad(int tintIndex, EnumFacing face, boolean shade) {
        this.tintIndex = tintIndex;
        this.face = face;
        this.shade = shade;
    }

    public MutableQuad(MutableQuad from) {
        this.copyFrom(from);
    }

    public MutableQuad copyFrom(MutableQuad from) {
        this.tintIndex = from.tintIndex;
        this.face = from.face;
        this.shade = from.shade;
        this.sprite = from.sprite;
        this.vertex_0.copyFrom(from.vertex_0);
        this.vertex_1.copyFrom(from.vertex_1);
        this.vertex_2.copyFrom(from.vertex_2);
        this.vertex_3.copyFrom(from.vertex_3);
        return this;
    }

    public MutableQuad setTint(int tint) {
        this.tintIndex = tint;
        return this;
    }

    public int getTint() {
        return this.tintIndex;
    }

    public MutableQuad setFace(EnumFacing face) {
        this.face = face;
        return this;
    }

    public EnumFacing getFace() {
        return this.face;
    }

    public void setShade(boolean shade) {
        this.shade = shade;
    }

    public boolean isShade() {
        return this.shade;
    }

    public void setSprite(TextureAtlasSprite sprite) {
        this.sprite = sprite;
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public BakedQuad toBakedBlock() {
        int[] data = new int[28];
        this.vertex_0.toBakedBlock(data, 0);
        this.vertex_1.toBakedBlock(data, 7);
        this.vertex_2.toBakedBlock(data, 14);
        this.vertex_3.toBakedBlock(data, 21);
        return new BakedQuad(data, this.tintIndex, this.face, this.sprite, this.shade, DefaultVertexFormats.field_176600_a);
    }

    public BakedQuad toBakedItem() {
        int[] data = new int[28];
        this.vertex_0.toBakedItem(data, 0);
        this.vertex_1.toBakedItem(data, 7);
        this.vertex_2.toBakedItem(data, 14);
        this.vertex_3.toBakedItem(data, 21);
        return new BakedQuad(data, this.tintIndex, this.face, this.sprite, this.shade, DefaultVertexFormats.field_176599_b);
    }

    public MutableQuad fromBakedBlock(BakedQuad quad) {
        this.tintIndex = quad.func_178211_c();
        this.face = quad.func_178210_d();
        this.sprite = quad.func_187508_a();
        this.shade = quad.shouldApplyDiffuseLighting();
        int[] data = quad.func_178209_a();
        int stride = data.length / 4;
        this.vertex_0.fromBakedBlock(data, 0);
        this.vertex_1.fromBakedBlock(data, stride);
        this.vertex_2.fromBakedBlock(data, stride * 2);
        this.vertex_3.fromBakedBlock(data, stride * 3);
        return this;
    }

    public MutableQuad fromBakedItem(BakedQuad quad) {
        this.tintIndex = quad.func_178211_c();
        this.face = quad.func_178210_d();
        this.sprite = quad.func_187508_a();
        this.shade = quad.shouldApplyDiffuseLighting();
        int[] data = quad.func_178209_a();
        int stride = data.length / 4;
        this.vertex_0.fromBakedItem(data, 0);
        this.vertex_1.fromBakedItem(data, stride);
        this.vertex_2.fromBakedItem(data, stride * 2);
        this.vertex_3.fromBakedItem(data, stride * 3);
        return this;
    }

    public void render(BufferBuilder bb) {
        this.vertex_0.render(bb);
        this.vertex_1.render(bb);
        this.vertex_2.render(bb);
        this.vertex_3.render(bb);
    }

    public Vector3f getCalculatedNormal() {
        Vector3f a = new Vector3f((Tuple3f)this.vertex_1.positionvf());
        a.sub((Tuple3f)this.vertex_0.positionvf());
        Vector3f b = new Vector3f((Tuple3f)this.vertex_2.positionvf());
        b.sub((Tuple3f)this.vertex_0.positionvf());
        Vector3f c = new Vector3f();
        c.cross(a, b);
        return c;
    }

    public void setCalculatedNormal() {
        this.normalvf(this.getCalculatedNormal());
    }

    public static float diffuseLight(Vector3f normal) {
        return MutableQuad.diffuseLight(normal.x, normal.y, normal.z);
    }

    public static float diffuseLight(float x, float y, float z) {
        boolean up = y >= 0.0f;
        float xx = x * x;
        float yy = y * y;
        float zz = z * z;
        float t = xx + yy + zz;
        float light = (xx * 0.6f + zz * 0.8f) / t;
        float yyt = yy / t;
        if (!up) {
            yyt = (float)((double)yyt * 0.5);
        }
        return light += yyt;
    }

    public float getCalculatedDiffuse() {
        return MutableQuad.diffuseLight(this.getCalculatedNormal());
    }

    public void setDiffuse(Vector3f normal) {
        float diffuse = MutableQuad.diffuseLight(normal);
        this.colourf(diffuse, diffuse, diffuse, 1.0f);
    }

    public void setCalculatedDiffuse() {
        float diffuse = this.getCalculatedDiffuse();
        this.colourf(diffuse, diffuse, diffuse, 1.0f);
    }

    public MutableQuad copyAndInvertNormal() {
        MutableQuad copy = new MutableQuad(this);
        copy.vertex_0.copyFrom(this.vertex_3).invertNormal();
        copy.vertex_1.copyFrom(this.vertex_2).invertNormal();
        copy.vertex_2.copyFrom(this.vertex_1).invertNormal();
        copy.vertex_3.copyFrom(this.vertex_0).invertNormal();
        return copy;
    }

    public MutableQuad rotateTextureUp(int times) {
        switch (times & 3) {
            case 0: {
                return this;
            }
            case 1: {
                Point2f t = this.vertex_0.tex();
                this.vertex_0.texv((Tuple2f)this.vertex_1.tex());
                this.vertex_1.texv((Tuple2f)this.vertex_2.tex());
                this.vertex_2.texv((Tuple2f)this.vertex_3.tex());
                this.vertex_3.texv((Tuple2f)t);
                return this;
            }
            case 2: {
                Point2f t0 = this.vertex_0.tex();
                Point2f t1 = this.vertex_1.tex();
                this.vertex_0.texv((Tuple2f)this.vertex_2.tex());
                this.vertex_1.texv((Tuple2f)this.vertex_3.tex());
                this.vertex_2.texv((Tuple2f)t0);
                this.vertex_3.texv((Tuple2f)t1);
                return this;
            }
            case 3: {
                Point2f t = this.vertex_3.tex();
                this.vertex_3.texv((Tuple2f)this.vertex_2.tex());
                this.vertex_2.texv((Tuple2f)this.vertex_1.tex());
                this.vertex_1.texv((Tuple2f)this.vertex_0.tex());
                this.vertex_0.texv((Tuple2f)t);
                return this;
            }
        }
        throw new IllegalStateException("'times & 3' was not 0, 1, 2 or 3!");
    }

    public MutableQuad normalf(float x, float y, float z) {
        this.vertex_0.normalf(x, y, z);
        this.vertex_1.normalf(x, y, z);
        this.vertex_2.normalf(x, y, z);
        this.vertex_3.normalf(x, y, z);
        return this;
    }

    public MutableQuad normald(double x, double y, double z) {
        return this.normalf((float)x, (float)y, (float)z);
    }

    public MutableQuad normalvf(Vector3f vec) {
        return this.normalf(vec.x, vec.y, vec.z);
    }

    public MutableQuad normalvd(Vec3d vec) {
        return this.normald(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public MutableQuad normalvd(VecDouble vec) {
        return this.normald(vec.a, vec.b, vec.c);
    }

    public Vector3f normalvf() {
        return new Vector3f(this.vertex_0.normal_x, this.vertex_0.normal_y, this.vertex_0.normal_z);
    }

    public Vec3d normalvd() {
        return new Vec3d((double)this.vertex_0.normal_x, (double)this.vertex_0.normal_y, (double)this.vertex_0.normal_z);
    }

    public MutableQuad colouri(int r, int g, int b, int a) {
        this.vertex_0.colouri(r, g, b, a);
        this.vertex_1.colouri(r, g, b, a);
        this.vertex_2.colouri(r, g, b, a);
        this.vertex_3.colouri(r, g, b, a);
        return this;
    }

    public MutableQuad colouri(int rgba) {
        this.vertex_0.colouri(rgba);
        this.vertex_1.colouri(rgba);
        this.vertex_2.colouri(rgba);
        this.vertex_3.colouri(rgba);
        return this;
    }

    public MutableQuad colourf(float r, float g, float b, float a) {
        this.vertex_0.colourf(r, g, b, a);
        this.vertex_1.colourf(r, g, b, a);
        this.vertex_2.colourf(r, g, b, a);
        this.vertex_3.colourf(r, g, b, a);
        return this;
    }

    public MutableQuad colourvl(VecLong vec) {
        return this.colouri((int)vec.a, (int)vec.b, (int)vec.c, (int)vec.d);
    }

    public MutableQuad colourvf(Tuple4f vec) {
        return this.colourf(vec.x, vec.y, vec.z, vec.w);
    }

    public MutableQuad multColourd(double r, double g, double b, double a) {
        this.vertex_0.multColourd(r, g, b, a);
        this.vertex_1.multColourd(r, g, b, a);
        this.vertex_2.multColourd(r, g, b, a);
        this.vertex_3.multColourd(r, g, b, a);
        return this;
    }

    public MutableQuad multColourd(double by) {
        int m = (int)(by * 255.0);
        return this.multColouri(m);
    }

    public MutableQuad multColouri(int by) {
        this.vertex_0.multColouri(by);
        this.vertex_1.multColouri(by);
        this.vertex_2.multColouri(by);
        this.vertex_3.multColouri(by);
        return this;
    }

    public MutableQuad multColouri(int r, int g, int b, int a) {
        this.vertex_0.multColouri(r &= 0xFF, g &= 0xFF, b &= 0xFF, a &= 0xFF);
        this.vertex_1.multColouri(r, g, b, a);
        this.vertex_2.multColouri(r, g, b, a);
        this.vertex_3.multColouri(r, g, b, a);
        return this;
    }

    public MutableQuad multShade() {
        if (this.isShade()) {
            this.setShade(false);
            this.vertex_0.multShade();
            this.vertex_1.multShade();
            this.vertex_2.multShade();
            this.vertex_3.multShade();
        }
        return this;
    }

    public MutableQuad texFromSprite(TextureAtlasSprite sprite) {
        this.vertex_0.texFromSprite(sprite);
        this.vertex_1.texFromSprite(sprite);
        this.vertex_2.texFromSprite(sprite);
        this.vertex_3.texFromSprite(sprite);
        return this;
    }

    public MutableQuad lighti(int block, int sky) {
        this.vertex_0.lighti(block, sky);
        this.vertex_1.lighti(block, sky);
        this.vertex_2.lighti(block, sky);
        this.vertex_3.lighti(block, sky);
        return this;
    }

    public MutableQuad lighti(int combined) {
        this.vertex_0.lighti(combined);
        this.vertex_1.lighti(combined);
        this.vertex_2.lighti(combined);
        this.vertex_3.lighti(combined);
        return this;
    }

    public MutableQuad lightf(float block, float sky) {
        return this.lighti((int)(block * 15.0f), (int)(sky * 15.0f));
    }

    public MutableQuad lightvf(Tuple2f vec) {
        return this.lightf(vec.x, vec.y);
    }

    public MutableQuad maxLighti(int block, int sky) {
        this.vertex_0.maxLighti(block, sky);
        this.vertex_1.maxLighti(block, sky);
        this.vertex_2.maxLighti(block, sky);
        this.vertex_3.maxLighti(block, sky);
        return this;
    }

    public MutableQuad transform(Matrix4f transformation) {
        this.vertex_0.transform(transformation);
        this.vertex_1.transform(transformation);
        this.vertex_2.transform(transformation);
        this.vertex_3.transform(transformation);
        return this;
    }

    public MutableQuad translatei(int x, int y, int z) {
        return this.translatef(x, y, z);
    }

    public MutableQuad translatef(float x, float y, float z) {
        this.vertex_0.translatef(x, y, z);
        this.vertex_1.translatef(x, y, z);
        this.vertex_2.translatef(x, y, z);
        this.vertex_3.translatef(x, y, z);
        return this;
    }

    public MutableQuad translated(double x, double y, double z) {
        return this.translatef((float)x, (float)y, (float)z);
    }

    public MutableQuad translatevi(Vec3i vec) {
        return this.translatei(vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p());
    }

    public MutableQuad translatevf(Vector3f vec) {
        return this.translatef(vec.x, vec.y, vec.z);
    }

    public MutableQuad translatevd(Vec3d vec) {
        return this.translated(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public MutableQuad scalef(float scale) {
        this.vertex_0.scalef(scale);
        this.vertex_1.scalef(scale);
        this.vertex_2.scalef(scale);
        this.vertex_3.scalef(scale);
        return this;
    }

    public MutableQuad scaled(double scale) {
        return this.scalef((float)scale);
    }

    public MutableQuad scalef(float x, float y, float z) {
        this.vertex_0.scalef(x, y, z);
        this.vertex_1.scalef(x, y, z);
        this.vertex_2.scalef(x, y, z);
        this.vertex_3.scalef(x, y, z);
        return this;
    }

    public MutableQuad scaled(double x, double y, double z) {
        return this.scalef((float)x, (float)y, (float)z);
    }

    public void rotateX(float angle) {
        this.vertex_0.rotateX(angle);
        this.vertex_1.rotateX(angle);
        this.vertex_2.rotateX(angle);
        this.vertex_3.rotateX(angle);
    }

    public void rotateY(float angle) {
        this.vertex_0.rotateY(angle);
        this.vertex_1.rotateY(angle);
        this.vertex_2.rotateY(angle);
        this.vertex_3.rotateY(angle);
    }

    public void rotateZ(float angle) {
        this.vertex_0.rotateZ(angle);
        this.vertex_1.rotateZ(angle);
        this.vertex_2.rotateZ(angle);
        this.vertex_3.rotateZ(angle);
    }

    public void rotateDirectlyX(float cos, float sin) {
        this.vertex_0.rotateDirectlyX(cos, sin);
        this.vertex_1.rotateDirectlyX(cos, sin);
        this.vertex_2.rotateDirectlyX(cos, sin);
        this.vertex_3.rotateDirectlyX(cos, sin);
    }

    public void rotateDirectlyY(float cos, float sin) {
        this.vertex_0.rotateDirectlyY(cos, sin);
        this.vertex_1.rotateDirectlyY(cos, sin);
        this.vertex_2.rotateDirectlyY(cos, sin);
        this.vertex_3.rotateDirectlyY(cos, sin);
    }

    public void rotateDirectlyZ(float cos, float sin) {
        this.vertex_0.rotateDirectlyZ(cos, sin);
        this.vertex_1.rotateDirectlyZ(cos, sin);
        this.vertex_2.rotateDirectlyZ(cos, sin);
        this.vertex_3.rotateDirectlyZ(cos, sin);
    }

    public MutableQuad rotate(EnumFacing from, EnumFacing to, float ox, float oy, float oz) {
        if (from == to) {
            return this;
        }
        this.translatef(-ox, -oy, -oz);
        switch (from.func_176740_k()) {
            case X: {
                int mult = from.func_82601_c();
                switch (to.func_176740_k()) {
                    case X: {
                        this.rotateY_180();
                        break;
                    }
                    case Y: {
                        this.rotateZ_90(mult * to.func_96559_d());
                        break;
                    }
                    case Z: {
                        this.rotateY_90(mult * to.func_82599_e());
                    }
                }
                break;
            }
            case Y: {
                int mult = from.func_96559_d();
                switch (to.func_176740_k()) {
                    case X: {
                        this.rotateZ_90(-mult * to.func_82601_c());
                        break;
                    }
                    case Y: {
                        this.rotateZ_180();
                        break;
                    }
                    case Z: {
                        this.rotateX_90(mult * to.func_82599_e());
                    }
                }
                break;
            }
            case Z: {
                int mult = -from.func_82599_e();
                switch (to.func_176740_k()) {
                    case X: {
                        this.rotateY_90(mult * to.func_82601_c());
                        break;
                    }
                    case Y: {
                        this.rotateX_90(mult * to.func_96559_d());
                        break;
                    }
                    case Z: {
                        this.rotateY_180();
                    }
                }
                break;
            }
        }
        this.translatef(ox, oy, oz);
        return this;
    }

    public MutableQuad rotateX_90(float scale) {
        this.vertex_0.rotateX_90(scale);
        this.vertex_1.rotateX_90(scale);
        this.vertex_2.rotateX_90(scale);
        this.vertex_3.rotateX_90(scale);
        return this;
    }

    public MutableQuad rotateY_90(float scale) {
        this.vertex_0.rotateY_90(scale);
        this.vertex_1.rotateY_90(scale);
        this.vertex_2.rotateY_90(scale);
        this.vertex_3.rotateY_90(scale);
        return this;
    }

    public MutableQuad rotateZ_90(float scale) {
        this.vertex_0.rotateZ_90(scale);
        this.vertex_1.rotateZ_90(scale);
        this.vertex_2.rotateZ_90(scale);
        this.vertex_3.rotateZ_90(scale);
        return this;
    }

    public MutableQuad rotateX_180() {
        this.vertex_0.rotateX_180();
        this.vertex_1.rotateX_180();
        this.vertex_2.rotateX_180();
        this.vertex_3.rotateX_180();
        return this;
    }

    public MutableQuad rotateY_180() {
        this.vertex_0.rotateY_180();
        this.vertex_1.rotateY_180();
        this.vertex_2.rotateY_180();
        this.vertex_3.rotateY_180();
        return this;
    }

    public MutableQuad rotateZ_180() {
        this.vertex_0.rotateZ_180();
        this.vertex_1.rotateZ_180();
        this.vertex_2.rotateZ_180();
        this.vertex_3.rotateZ_180();
        return this;
    }

    public String toString() {
        return "MutableQuad [vertices=" + this.vToS() + ", tintIndex=" + this.tintIndex + ", face=" + this.face + "]";
    }

    private String vToS() {
        return "[ " + this.vertex_0 + ", " + this.vertex_1 + ", " + this.vertex_2 + ", " + this.vertex_3 + " ]";
    }
}

