/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.marker.volume;

import buildcraft.core.marker.volume.Lock;
import buildcraft.core.marker.volume.MessageVolumeBoxes;
import buildcraft.core.marker.volume.VolumeBox;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.net.MessageManager;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class WorldSavedDataVolumeBoxes
extends WorldSavedData {
    private static final String DATA_NAME = "buildcraft_volume_boxes";
    private static World currentWorld;
    public final World world = currentWorld;
    public final List<VolumeBox> volumeBoxes = new ArrayList<VolumeBox>();

    public WorldSavedDataVolumeBoxes() {
        super(DATA_NAME);
    }

    public WorldSavedDataVolumeBoxes(String name) {
        super(name);
    }

    public VolumeBox getVolumeBoxAt(BlockPos pos) {
        return this.volumeBoxes.stream().filter(volumeBox -> volumeBox.box.contains(pos)).findFirst().orElse(null);
    }

    public void addVolumeBox(BlockPos pos) {
        this.volumeBoxes.add(new VolumeBox(this.world, pos));
    }

    public VolumeBox getVolumeBoxFromId(UUID id) {
        return this.volumeBoxes.stream().filter(volumeBox -> volumeBox.id.equals(id)).findFirst().orElse(null);
    }

    public VolumeBox getCurrentEditing(EntityPlayer player) {
        return this.volumeBoxes.stream().filter(volumeBox -> volumeBox.isEditingBy(player)).findFirst().orElse(null);
    }

    public void tick() {
        AtomicBoolean dirty = new AtomicBoolean(false);
        this.volumeBoxes.stream().filter(VolumeBox::isEditing).forEach(volumeBox -> {
            EntityPlayer player = volumeBox.getPlayer(this.world);
            if (player == null) {
                volumeBox.pauseEditing();
                dirty.set(true);
            } else {
                AxisAlignedBB oldAabb = volumeBox.box.getBoundingBox();
                volumeBox.box.reset();
                volumeBox.box.extendToEncompass(volumeBox.getHeld());
                BlockPos lookingAt = new BlockPos(player.func_174791_d().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(player.func_70040_Z().func_186678_a(volumeBox.getDist())));
                volumeBox.box.extendToEncompass(lookingAt);
                if (!volumeBox.box.getBoundingBox().equals((Object)oldAabb)) {
                    dirty.set(true);
                }
            }
        });
        for (VolumeBox volumeBox2 : this.volumeBoxes) {
            List locksToRemove = new ArrayList<Lock>(volumeBox2.locks).stream().filter(lock -> !lock.cause.stillWorks(this.world)).collect(Collectors.toList());
            if (locksToRemove.isEmpty()) continue;
            volumeBox2.locks.removeAll(locksToRemove);
            dirty.set(true);
        }
        if (dirty.get()) {
            this.func_76185_a();
        }
    }

    public void func_76185_a() {
        super.func_76185_a();
        MessageManager.sendToDimension(new MessageVolumeBoxes(this.volumeBoxes), this.world.field_73011_w.getDimension());
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74782_a("volumeBoxes", (NBTBase)NBTUtilBC.writeCompoundList(this.volumeBoxes.stream().map(VolumeBox::writeToNBT)));
        return nbt;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.volumeBoxes.clear();
        NBTUtilBC.readCompoundList(nbt.func_74781_a("volumeBoxes")).map(volumeBoxTag -> new VolumeBox(this.world, (NBTTagCompound)volumeBoxTag)).forEach(this.volumeBoxes::add);
    }

    public static WorldSavedDataVolumeBoxes get(World world) {
        if (world.field_72995_K) {
            throw new IllegalArgumentException("Tried to create a world saved data instance on the client!");
        }
        MapStorage storage = world.getPerWorldStorage();
        currentWorld = world;
        WorldSavedDataVolumeBoxes instance = (WorldSavedDataVolumeBoxes)storage.func_75742_a(WorldSavedDataVolumeBoxes.class, DATA_NAME);
        if (instance == null) {
            instance = new WorldSavedDataVolumeBoxes();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)instance);
        }
        currentWorld = null;
        return instance;
    }
}

