/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.item;

import buildcraft.api.blocks.CustomPaintHelper;
import buildcraft.lib.client.render.font.SpecialColourFontRenderer;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.ParticleUtil;
import buildcraft.lib.misc.SoundUtil;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.misc.VecUtil;
import gnu.trove.map.hash.TIntObjectHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemPaintbrush_BC8
extends ItemBC_Neptune {
    private static final String DAMAGE = "damage";
    private static final int MAX_USES = 64;

    public ItemPaintbrush_BC8(String id) {
        super(id);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Override
    protected void addSubItems(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        for (int i = 0; i < 17; ++i) {
            subItems.add((Object)new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addModelVariants(TIntObjectHashMap<ModelResourceLocation> variants) {
        this.addVariant(variants, 0, "clean");
        for (EnumDyeColor colour : EnumDyeColor.values()) {
            this.addVariant(variants, colour.func_176765_a() + 1, colour.func_176610_l());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = StackUtil.asNonNull(player.func_184586_b(hand));
        Brush brush = new Brush(stack);
        Vec3d hitPos = VecUtil.add(new Vec3d((double)hitX, (double)hitY, (double)hitZ), (Vec3i)pos);
        if (brush.useOnBlock(world, pos, world.func_180495_p(pos), hitPos, facing, player)) {
            ItemStack newStack = brush.save(stack);
            if (!newStack.func_190926_b()) {
                player.func_184611_a(hand, newStack);
            }
            player.field_71069_bz.func_75142_b();
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public Brush getBrushFromStack(ItemStack stack) {
        return new Brush(stack);
    }

    public String func_77653_i(ItemStack stack) {
        Brush brush = this.getBrushFromStack(stack);
        String colourComponent = "";
        if (brush.colour != null) {
            colourComponent = ColourUtil.getTextFullTooltipSpecial(brush.colour) + " ";
        }
        return colourComponent + super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return SpecialColourFontRenderer.INSTANCE;
    }

    public int getDamage(ItemStack stack) {
        Brush brush = new Brush(stack);
        return 64 - brush.usesLeft;
    }

    public void setDamage(ItemStack stack, int damage) {
    }

    public boolean isDamaged(ItemStack stack) {
        Brush brush = new Brush(stack);
        return brush.colour != null && brush.usesLeft < 64;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.isDamaged(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        Brush brush = new Brush(stack);
        return 1.0 - (double)brush.usesLeft / 64.0;
    }

    public int getMetadata(ItemStack stack) {
        return super.getDamage(stack);
    }

    public class Brush {
        public EnumDyeColor colour;
        public int usesLeft;

        public Brush(EnumDyeColor colour) {
            this.colour = colour;
            this.usesLeft = 64;
        }

        public Brush(ItemStack stack) {
            int meta = stack.func_77960_j();
            if (meta > 0 && meta <= 16) {
                this.colour = EnumDyeColor.func_176764_b((int)(meta - 1));
                NBTTagCompound nbt = stack.func_77978_p();
                this.usesLeft = nbt == null ? 64 : 64 - nbt.func_74771_c(ItemPaintbrush_BC8.DAMAGE);
            } else {
                this.usesLeft = 0;
            }
        }

        @Nonnull
        public ItemStack save() {
            return this.save(StackUtil.EMPTY);
        }

        @Nonnull
        public ItemStack save(@Nonnull ItemStack existing) {
            ItemStack stack = existing;
            if (existing.func_190926_b() || existing.func_77960_j() != this.getMeta()) {
                stack = new ItemStack((Item)ItemPaintbrush_BC8.this, 1, this.getMeta());
            }
            if (this.usesLeft != 64 && this.colour != null) {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                    stack.func_77982_d(nbt);
                }
                nbt.func_74774_a(ItemPaintbrush_BC8.DAMAGE, (byte)(64 - this.usesLeft));
            }
            return stack == existing ? StackUtil.EMPTY : stack;
        }

        public int getMeta() {
            return this.usesLeft <= 0 || this.colour == null ? 0 : this.colour.func_176765_a() + 1;
        }

        public boolean useOnBlock(World world, BlockPos pos, IBlockState state, Vec3d hitPos, EnumFacing side, EntityPlayer player) {
            if (this.colour != null && this.usesLeft <= 0) {
                return false;
            }
            EnumActionResult result = CustomPaintHelper.INSTANCE.attemptPaintBlock(world, pos, state, hitPos, side, this.colour);
            if (result == EnumActionResult.SUCCESS) {
                ParticleUtil.showChangeColour(world, hitPos, this.colour);
                SoundUtil.playChangeColour(world, pos, this.colour);
                if (!player.func_184812_l_()) {
                    --this.usesLeft;
                }
                if (this.usesLeft <= 0) {
                    this.colour = null;
                    this.usesLeft = 0;
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return "[" + this.usesLeft + " of " + (this.colour == null ? "nothing" : this.colour.func_176610_l()) + "]";
        }
    }
}

