/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.item;

import buildcraft.api.items.IItemFluidShard;
import buildcraft.lib.fluid.BCFluid;
import buildcraft.lib.item.ItemBC_Neptune;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.StackUtil;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFragileFluidContainer
extends ItemBC_Neptune
implements IItemFluidShard {
    public static final int MAX_FLUID_HELD = 500;

    public ItemFragileFluidContainer(String id) {
        super(id);
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FragileFluidHandler(stack);
    }

    @Override
    protected void addSubItems(CreativeTabs tab, NonNullList<ItemStack> items) {
    }

    public String func_77653_i(ItemStack stack) {
        String localized;
        FluidStack fluid = ItemFragileFluidContainer.getFluid(stack);
        if (fluid == null) {
            localized = "ERROR! NULL FLUID!";
        } else if (fluid.getFluid() instanceof BCFluid) {
            BCFluid bcFluid = (BCFluid)fluid.getFluid();
            if (bcFluid.isHeatable()) {
                String localized2 = bcFluid.getBareLocalizedName(fluid);
                String whole = LocaleUtil.localize(this.func_77658_a() + ".name", localized2);
                return whole + LocaleUtil.localize("buildcraft.fluid.heat_" + bcFluid.getHeatValue());
            }
            localized = fluid.getLocalizedName();
        } else {
            localized = fluid.getLocalizedName();
        }
        return LocaleUtil.localize(this.func_77658_a() + ".name", localized);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        FluidStack fluid;
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        NBTTagCompound fluidTag = stack.func_179543_a("fluid");
        if (fluidTag != null && (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidTag)) != null && fluid.amount > 0) {
            tooltip.add(LocaleUtil.localizeFluidStaticAmount(fluid.amount, 500));
        }
    }

    @Override
    public void addFluidDrops(NonNullList<ItemStack> toDrop, FluidStack fluid) {
        if (fluid == null) {
            return;
        }
        int amount = fluid.amount;
        if (amount >= 500) {
            FluidStack fluid2 = fluid.copy();
            fluid2.amount = 500;
            while (amount >= 500) {
                ItemStack stack = new ItemStack((Item)this);
                ItemFragileFluidContainer.setFluid(stack, fluid2);
                amount -= 500;
                toDrop.add((Object)stack);
            }
        }
        if (amount > 0) {
            ItemStack stack = new ItemStack((Item)this);
            ItemFragileFluidContainer.setFluid(stack, new FluidStack(fluid, amount));
            toDrop.add((Object)stack);
        }
    }

    static void setFluid(ItemStack container, FluidStack fluid) {
        NBTTagCompound nbt = NBTUtilBC.getItemData(container);
        nbt.func_74782_a("fluid", (NBTBase)fluid.writeToNBT(new NBTTagCompound()));
    }

    @Nullable
    static FluidStack getFluid(ItemStack container) {
        if (container.func_190926_b()) {
            return null;
        }
        NBTTagCompound fluidNbt = container.func_179543_a("fluid");
        if (fluidNbt == null) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidNbt);
    }

    public class FragileFluidHandler
    implements IFluidHandlerItem,
    ICapabilityProvider {
        @Nonnull
        private ItemStack container;

        public FragileFluidHandler(ItemStack container) {
            this.container = container;
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return this.getCapability(capability, facing) != null;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)this;
            }
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return new IFluidTankProperties[]{new FluidTankProperties(ItemFragileFluidContainer.getFluid(this.container), 500, false, true)};
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        public FluidStack drain(FluidStack resource, boolean doDrain) {
            FluidStack fluid = ItemFragileFluidContainer.getFluid(this.container);
            if (fluid == null || resource == null) {
                return null;
            }
            if (!fluid.isFluidEqual(resource)) {
                return null;
            }
            return this.drain(resource.amount, doDrain);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            FluidStack fluid = ItemFragileFluidContainer.getFluid(this.container);
            if (fluid == null || maxDrain <= 0) {
                return null;
            }
            int toDrain = Math.min(maxDrain, fluid.amount);
            FluidStack f = new FluidStack(fluid, toDrain);
            if (doDrain) {
                fluid.amount -= toDrain;
                if (fluid.amount <= 0) {
                    fluid = null;
                    this.container = StackUtil.EMPTY;
                } else {
                    ItemFragileFluidContainer.setFluid(this.container, fluid);
                }
            }
            return f;
        }

        public ItemStack getContainer() {
            return this.container;
        }
    }
}

