/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.core.BCCoreConfig;
import buildcraft.lib.config.EnumRestartRequirement;
import net.minecraftforge.common.config.Property;

public class BCBuildersConfig {
    public static int bptStoreExternalThreshold = 20000;
    public static int quarryFrameMinHeight = 4;
    public static boolean quarryFrameMoveBoth;
    public static int quarryMaxTasksPerTick;
    public static int quarryTaskPowerDivisor;
    public static double quarryMaxFrameMoveSpeed;
    public static double quarryMaxBlockMineRate;
    public static boolean enableStencil;
    private static Property propBptStoreExternalThreshold;
    private static Property propQuarryFrameMinHeight;
    private static Property propQuarryFrameMoveBoth;
    private static Property propQuarryMaxTasksPerTick;
    private static Property propQuarryPowerDivisor;
    private static Property propQuarryMaxFrameSpeed;
    private static Property propQuarryMaxBlockMineRate;
    private static Property propEnableStencil;
    static Property internalStencilCrashTest;

    public static void preInit() {
        EnumRestartRequirement none = EnumRestartRequirement.NONE;
        EnumRestartRequirement game = EnumRestartRequirement.GAME;
        propBptStoreExternalThreshold = BCCoreConfig.config.get("general", "bptStoreExternalThreshold", 20000);
        none.setTo(propBptStoreExternalThreshold);
        propQuarryFrameMinHeight = BCCoreConfig.config.get("general", "quarryFrameMinHeight", 4);
        propQuarryFrameMinHeight.setComment("The minimum height that all quarry frames must be. A value of 1 will look strange when it drills the uppermost layer.");
        propQuarryFrameMinHeight.setMinValue(1);
        none.setTo(propQuarryFrameMinHeight);
        propQuarryFrameMoveBoth = BCCoreConfig.config.get("display", "quarryFrameMoveBoth", false);
        propQuarryFrameMoveBoth.setComment("If true then the quarry frame will move with both of its axis rather than just one.");
        none.setTo(propQuarryFrameMoveBoth);
        propQuarryMaxTasksPerTick = BCCoreConfig.config.get("general", "quarryMaxTasksPerTick", 4);
        propQuarryMaxTasksPerTick.setComment("The maximum number of tasks that the quarry will do per tick.\n(Where a task is either breaking a block, or moving the frame)");
        propQuarryMaxTasksPerTick.setMinValue(1).setMaxValue(20);
        none.setTo(propQuarryMaxTasksPerTick);
        propQuarryPowerDivisor = BCCoreConfig.config.get("general", "quarryPowerDivisor", 2);
        propQuarryPowerDivisor.setComment("1 divided by this value is added to the power cost for each additional task done per tick.\nA value of 0 disables this behaviour.");
        propQuarryPowerDivisor.setMinValue(0).setMaxValue(100);
        none.setTo(propQuarryPowerDivisor);
        propQuarryMaxFrameSpeed = BCCoreConfig.config.get("general", "quarryMaxFrameSpeed", 0.0);
        propQuarryMaxFrameSpeed.setComment("The maximum number of blocks that a quarry is allowed to move, per second.\nA value of 0 means no limit.");
        propQuarryMaxFrameSpeed.setMinValue(0.0).setMaxValue(5120.0);
        none.setTo(propQuarryMaxFrameSpeed);
        propQuarryMaxBlockMineRate = BCCoreConfig.config.get("general", "quarryMaxBlockMineRate", 0.0);
        propQuarryMaxBlockMineRate.setComment("The maximum number of blocks that the quarry is allowed to mine each second.\nA value of 0 means no limit, and a value of 0.5 will mine up to half a block per second.");
        propQuarryMaxBlockMineRate.setMinValue(0.0).setMaxValue(1000.0);
        none.setTo(propQuarryMaxBlockMineRate);
        propEnableStencil = BCCoreConfig.config.get("display", "enableStencil", true);
        propEnableStencil.setComment("If true then the architect table will correctly hide it's translucent parts behind surrounding terrain. (This looks better)");
        none.setTo(propEnableStencil);
        internalStencilCrashTest = BCCoreConfig.config.get("internal", "force_disable_stencil", false);
        internalStencilCrashTest.setComment("Use display.enableStencil instead of this!");
        none.setTo(internalStencilCrashTest);
        BCCoreConfig.config.getCategory("internal").setShowInGui(false);
        BCCoreConfig.saveConfigs();
        BCBuildersConfig.reloadConfig(EnumRestartRequirement.GAME);
        BCCoreConfig.addReloadListener(BCBuildersConfig::reloadConfig);
    }

    public static void reloadConfig(EnumRestartRequirement restarted) {
        bptStoreExternalThreshold = propBptStoreExternalThreshold.getInt();
        quarryFrameMinHeight = propQuarryFrameMinHeight.getInt();
        quarryFrameMoveBoth = propQuarryFrameMoveBoth.getBoolean();
        enableStencil = propEnableStencil.getBoolean();
    }

    static {
        quarryMaxTasksPerTick = 4;
        quarryTaskPowerDivisor = 2;
        quarryMaxFrameMoveSpeed = 0.0;
        quarryMaxBlockMineRate = 0.0;
        enableStencil = true;
    }
}

