/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.statements;

import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class StatementParameterItemStack
implements IStatementParameter {
    @Nonnull
    private static final ItemStack EMPTY_STACK;
    public static final StatementParameterItemStack EMPTY;
    @Nonnull
    protected final ItemStack stack;

    public StatementParameterItemStack() {
        this.stack = EMPTY_STACK;
    }

    public StatementParameterItemStack(@Nonnull ItemStack stack) {
        this.stack = stack;
    }

    public StatementParameterItemStack(NBTTagCompound nbt) {
        ItemStack read = new ItemStack(nbt.func_74775_l("stack"));
        this.stack = read.func_190926_b() ? EMPTY_STACK : read;
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        if (!this.stack.func_190926_b()) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.stack.func_77955_b(tagCompound);
            compound.func_74782_a("stack", (NBTBase)tagCompound);
        }
    }

    @Override
    public ISprite getSprite() {
        return null;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public StatementParameterItemStack onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        if (stack.func_190926_b()) {
            return EMPTY;
        }
        ItemStack newStack = stack.func_77946_l();
        newStack.func_190920_e(1);
        return new StatementParameterItemStack(newStack);
    }

    public boolean equals(Object object) {
        if (object instanceof StatementParameterItemStack) {
            StatementParameterItemStack param = (StatementParameterItemStack)object;
            return ItemStack.func_77989_b((ItemStack)this.stack, (ItemStack)param.stack) && ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)param.stack);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        throw new UnsupportedOperationException("Don't call getDescription directly!");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltip() {
        if (this.stack.func_190926_b()) {
            return ImmutableList.of();
        }
        List tooltip = this.stack.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
        if (!tooltip.isEmpty()) {
            tooltip.set(0, this.stack.func_77953_t().field_77937_e + (String)tooltip.get(0));
            for (int i = 1; i < tooltip.size(); ++i) {
                tooltip.set(i, TextFormatting.GRAY + (String)tooltip.get(i));
            }
        }
        return tooltip;
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:stack";
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }

    @Override
    public IStatementParameter[] getPossible(IStatementContainer source) {
        return null;
    }

    static {
        ItemStack stack = ItemStack.field_190927_a;
        if (stack == null) {
            throw new Error("Somehow ItemStack.EMPTY was null!");
        }
        EMPTY_STACK = stack;
        EMPTY = new StatementParameterItemStack();
    }
}

