/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.utils;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeDesert;
import net.minecraft.world.chunk.Chunk;

public class MusePlayerUtils {
    public static RayTraceResult raytraceEntities(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        RayTraceResult pickedEntity = null;
        Vec3d playerPosition = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d playerLook = player.func_70040_Z();
        Vec3d playerViewOffset = new Vec3d(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance, playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance, playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance);
        AxisAlignedBB boxToScan = player.func_174813_aQ().func_72321_a(playerLook.field_72450_a * reachDistance, playerLook.field_72448_b * reachDistance, playerLook.field_72449_c * reachDistance);
        List entitiesHit = world.func_72839_b((Entity)player, boxToScan);
        double closestEntity = reachDistance;
        if (entitiesHit == null || entitiesHit.isEmpty()) {
            return null;
        }
        for (Entity entityHit : entitiesHit) {
            if (entityHit == null || !entityHit.func_70067_L() || entityHit.func_174813_aQ() == null) continue;
            float border = entityHit.func_70111_Y();
            AxisAlignedBB aabb = entityHit.func_174813_aQ().func_72321_a((double)border, (double)border, (double)border);
            RayTraceResult raytraceResult = aabb.func_72327_a(playerPosition, playerViewOffset);
            if (raytraceResult == null) continue;
            if (aabb.func_72318_a(playerPosition)) {
                if (!(0.0 < closestEntity) && closestEntity != 0.0 || (pickedEntity = new RayTraceResult(entityHit)) == null) continue;
                pickedEntity.field_72307_f = raytraceResult.field_72307_f;
                closestEntity = 0.0;
                continue;
            }
            double distance = playerPosition.func_72438_d(raytraceResult.field_72307_f);
            if (!(distance < closestEntity) && closestEntity != 0.0) continue;
            pickedEntity = new RayTraceResult(entityHit);
            pickedEntity.field_72307_f = raytraceResult.field_72307_f;
            closestEntity = distance;
        }
        return pickedEntity;
    }

    public static RayTraceResult raytraceBlocks(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        Vec3d playerPosition = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Vec3d playerLook = player.func_70040_Z();
        Vec3d playerViewOffset = new Vec3d(playerPosition.field_72450_a + playerLook.field_72450_a * reachDistance, playerPosition.field_72448_b + playerLook.field_72448_b * reachDistance, playerPosition.field_72449_c + playerLook.field_72449_c * reachDistance);
        return world.func_72933_a(playerPosition, playerViewOffset);
    }

    public static RayTraceResult doCustomRayTrace(World world, EntityPlayer player, boolean collisionFlag, double reachDistance) {
        RayTraceResult pickedBlock = MusePlayerUtils.raytraceBlocks(world, player, collisionFlag, reachDistance);
        RayTraceResult pickedEntity = MusePlayerUtils.raytraceEntities(world, player, collisionFlag, reachDistance);
        if (pickedBlock == null) {
            return pickedEntity;
        }
        if (pickedEntity == null) {
            return pickedBlock;
        }
        Vec3d playerPosition = new Vec3d(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        double dBlock = pickedBlock.field_72307_f.func_72438_d(playerPosition);
        double dEntity = pickedEntity.field_72307_f.func_72438_d(playerPosition);
        if (dEntity < dBlock) {
            return pickedEntity;
        }
        return pickedBlock;
    }

    public static void teleportEntity(EntityPlayer entityPlayer, RayTraceResult rayTraceResult) {
        if (rayTraceResult != null && entityPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)entityPlayer;
            if (player.field_71135_a.field_147371_a.func_150724_d()) {
                switch (rayTraceResult.field_72313_a) {
                    case ENTITY: {
                        player.func_70634_a(rayTraceResult.field_72307_f.field_72450_a, rayTraceResult.field_72307_f.field_72448_b, rayTraceResult.field_72307_f.field_72449_c);
                        break;
                    }
                    case BLOCK: {
                        double hitx = rayTraceResult.field_72307_f.field_72450_a;
                        double hity = rayTraceResult.field_72307_f.field_72448_b;
                        double hitz = rayTraceResult.field_72307_f.field_72449_c;
                        switch (rayTraceResult.field_178784_b) {
                            case DOWN: {
                                hity -= 2.0;
                                break;
                            }
                            case UP: {
                                break;
                            }
                            case NORTH: {
                                hitx -= 0.5;
                                break;
                            }
                            case SOUTH: {
                                hitx += 0.5;
                                break;
                            }
                            case WEST: {
                                hitz += 0.5;
                                break;
                            }
                            case EAST: {
                                hitz -= 0.5;
                            }
                        }
                        player.func_70634_a(hitx, hity, hitz);
                        break;
                    }
                }
            }
        }
    }

    public static double getPlayerCoolingBasedOnMaterial(@Nonnull EntityPlayer player) {
        if (player.func_180799_ab()) {
            return 0.0;
        }
        double cool = 2.0 - (double)(MusePlayerUtils.getBiome(player).func_180626_a(new BlockPos((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v)) / 2.0f);
        if (player.func_70090_H()) {
            cool += 0.5;
        }
        if ((int)player.field_70163_u > 128) {
            cool += 0.5;
        }
        if (!player.field_70170_p.func_72935_r() && MusePlayerUtils.getBiome(player) instanceof BiomeDesert) {
            cool += 0.8;
        }
        if (player.field_70170_p.func_180494_b(player.func_180425_c()).func_76738_d() && player.field_70170_p.func_72896_J() && player.field_70170_p.func_175710_j(player.func_180425_c().func_177982_a(0, 1, 0))) {
            cool += 0.2;
        }
        return cool;
    }

    public static Biome getBiome(EntityPlayer player) {
        Chunk chunk = player.field_70170_p.func_175726_f(player.func_180425_c());
        return chunk.func_177411_a(player.func_180425_c(), player.field_70170_p.func_72959_q());
    }
}

