/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.common.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.TreeMap;
import net.machinemuse.numina.network.MuseByteBufferUtils;
import net.machinemuse.powersuits.common.ModuleManager;
import net.machinemuse.powersuits.common.config.MPSSettings;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorBoots;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorChestplate;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorHelmet;
import net.machinemuse.powersuits.item.armor.ItemPowerArmorLeggings;
import net.machinemuse.powersuits.item.tool.ItemPowerFist;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class MPSServerSettings {
    public final boolean useOldAutoFeeder;
    public final double maximumFlyingSpeedmps;
    public final double maximumArmorPerPiece;
    public final double getSalvageChance;
    public final boolean useThermalExpansionRecipes;
    public final boolean useEnderIORecipes;
    public final boolean useTechRebornRecipes;
    public static boolean useIC2Recipes;
    public final double baseMaxHeatPowerFist;
    public final double baseMaxHeatHelmet;
    public final double baseMaxHeatChest;
    public final double baseMaxHeatLegs;
    public final double baseMaxHeatFeet;
    public final int maxArmorModules;
    public final int maxEnergyStorageModules;
    public final int maxEnergyGenModules;
    public final int maxToolModules;
    public final int maxWeaponModules;
    public final int maxMovementModules;
    public final int maxCosmeticModules;
    public final int maxVisionModules;
    public final int maxEnvironmentalModules;
    public final int maxSpecialModules;
    public final int maxMiningEnhancementModules;
    public final Map<String, Boolean> allowedModules;
    public final Map<String, Double> propertyDouble;
    public final Map<String, Integer> propertyInteger;
    public final boolean useLegacyCosmeticSystem;
    public final boolean allowHighPollyArmorModuels;
    public final boolean allowPowerFistCustomization;
    public final BiMap<String, NBTTagCompound> cosmeticPresetsPowerFist;
    public final BiMap<String, NBTTagCompound> cosmeticPresetsPowerArmorHelmet;
    public final BiMap<String, NBTTagCompound> cosmeticPresetsPowerArmorChestplate;
    public final BiMap<String, NBTTagCompound> cosmeticPresetsPowerArmorLeggings;
    public final BiMap<String, NBTTagCompound> cosmeticPresetsPowerArmorBoots;

    public MPSServerSettings() {
        this.useOldAutoFeeder = MPSSettings.general.useOldAutoFeeder;
        this.maximumFlyingSpeedmps = MPSSettings.general.getMaximumFlyingSpeedmps;
        this.maximumArmorPerPiece = MPSSettings.general.getMaximumArmorPerPiece;
        this.getSalvageChance = MPSSettings.general.getSalvageChance;
        this.useThermalExpansionRecipes = MPSSettings.recipesAllowed.useThermalExpansionRecipes;
        this.useEnderIORecipes = MPSSettings.recipesAllowed.useEnderIORecipes;
        this.useTechRebornRecipes = MPSSettings.recipesAllowed.useTechRebornRecipes;
        useIC2Recipes = MPSSettings.recipesAllowed.useIC2Recipes;
        MPSSettings.loadCustomInstallCosts();
        this.baseMaxHeatPowerFist = MPSSettings.general.baseMaxHeatPowerFist;
        this.baseMaxHeatHelmet = MPSSettings.general.baseMaxHeatHelmet;
        this.baseMaxHeatChest = MPSSettings.general.baseMaxHeatChest;
        this.baseMaxHeatLegs = MPSSettings.general.baseMaxHeatLegs;
        this.baseMaxHeatFeet = MPSSettings.general.baseMaxHeatFeet;
        this.allowedModules = new TreeMap<String, Boolean>(MPSSettings.modules.allowedModules);
        this.propertyDouble = new TreeMap<String, Double>(MPSSettings.modules.propertyDouble);
        this.propertyInteger = new TreeMap<String, Integer>(MPSSettings.modules.propertyInteger);
        this.maxArmorModules = MPSSettings.limits.maxArmorModules;
        this.maxEnergyStorageModules = MPSSettings.limits.maxEnergyStorageModules;
        this.maxEnergyGenModules = MPSSettings.limits.maxEnergyGenModules;
        this.maxToolModules = MPSSettings.limits.maxToolModules;
        this.maxWeaponModules = MPSSettings.limits.maxWeaponModules;
        this.maxMovementModules = MPSSettings.limits.maxMovementModules;
        this.maxCosmeticModules = MPSSettings.limits.maxCosmeticModules;
        this.maxVisionModules = MPSSettings.limits.maxVisionModules;
        this.maxEnvironmentalModules = MPSSettings.limits.maxEnvironmentalModules;
        this.maxSpecialModules = MPSSettings.limits.maxSpecialModules;
        this.maxMiningEnhancementModules = MPSSettings.limits.maxMiningEnhancementModules;
        this.useLegacyCosmeticSystem = MPSSettings.cosmetics.useLegacyCosmeticSystem;
        this.allowHighPollyArmorModuels = MPSSettings.cosmetics.allowHighPollyArmorModuels;
        this.allowPowerFistCustomization = MPSSettings.cosmetics.allowPowerFistCustomization;
        this.cosmeticPresetsPowerFist = MPSSettings.cosmetics.getCosmeticPresetsPowerFist();
        this.cosmeticPresetsPowerArmorHelmet = MPSSettings.cosmetics.getCosmeticPresetsPowerArmorHelmet();
        this.cosmeticPresetsPowerArmorChestplate = MPSSettings.cosmetics.getCosmeticPresetsPowerArmorChestplate();
        this.cosmeticPresetsPowerArmorLeggings = MPSSettings.cosmetics.getCosmeticPresetsPowerArmorLeggings();
        this.cosmeticPresetsPowerArmorBoots = MPSSettings.cosmetics.getCosmeticPresetsPowerArmorBoots();
    }

    public MPSServerSettings(ByteBuf datain) {
        this.useOldAutoFeeder = datain.readBoolean();
        this.maximumFlyingSpeedmps = datain.readDouble();
        this.maximumArmorPerPiece = datain.readDouble();
        this.getSalvageChance = datain.readDouble();
        this.baseMaxHeatPowerFist = datain.readDouble();
        this.baseMaxHeatHelmet = datain.readDouble();
        this.baseMaxHeatChest = datain.readDouble();
        this.baseMaxHeatLegs = datain.readDouble();
        this.baseMaxHeatFeet = datain.readDouble();
        this.useThermalExpansionRecipes = datain.readBoolean();
        this.useEnderIORecipes = datain.readBoolean();
        this.useTechRebornRecipes = datain.readBoolean();
        useIC2Recipes = datain.readBoolean();
        ModuleManager.INSTANCE.setCustomInstallCosts(MuseByteBufferUtils.readMap((ByteBuf)datain, String.class, ItemStack[].class));
        this.allowedModules = MuseByteBufferUtils.readMap((ByteBuf)datain, String.class, Boolean.class);
        this.propertyDouble = MuseByteBufferUtils.readMap((ByteBuf)datain, String.class, Double.class);
        this.propertyInteger = MuseByteBufferUtils.readMap((ByteBuf)datain, String.class, Integer.class);
        this.maxArmorModules = datain.readInt();
        this.maxEnergyStorageModules = datain.readInt();
        this.maxEnergyGenModules = datain.readInt();
        this.maxToolModules = datain.readInt();
        this.maxWeaponModules = datain.readInt();
        this.maxMovementModules = datain.readInt();
        this.maxCosmeticModules = datain.readInt();
        this.maxVisionModules = datain.readInt();
        this.maxEnvironmentalModules = datain.readInt();
        this.maxSpecialModules = datain.readInt();
        this.maxMiningEnhancementModules = datain.readInt();
        this.useLegacyCosmeticSystem = datain.readBoolean();
        this.allowHighPollyArmorModuels = datain.readBoolean();
        this.allowPowerFistCustomization = datain.readBoolean();
        this.cosmeticPresetsPowerFist = HashBiMap.create((Map)MuseByteBufferUtils.readMap((ByteBuf)datain, String.class, NBTTagCompound.class));
        this.cosmeticPresetsPowerArmorHelmet = HashBiMap.create((Map)MuseByteBufferUtils.readMap((ByteBuf)datain, String.class, NBTTagCompound.class));
        this.cosmeticPresetsPowerArmorChestplate = HashBiMap.create((Map)MuseByteBufferUtils.readMap((ByteBuf)datain, String.class, NBTTagCompound.class));
        this.cosmeticPresetsPowerArmorLeggings = HashBiMap.create((Map)MuseByteBufferUtils.readMap((ByteBuf)datain, String.class, NBTTagCompound.class));
        this.cosmeticPresetsPowerArmorBoots = HashBiMap.create((Map)MuseByteBufferUtils.readMap((ByteBuf)datain, String.class, NBTTagCompound.class));
    }

    public void writeToBuffer(ByteBuf packet) {
        packet.writeBoolean(this.useOldAutoFeeder);
        packet.writeDouble(this.maximumFlyingSpeedmps);
        packet.writeDouble(this.maximumArmorPerPiece);
        packet.writeDouble(this.getSalvageChance);
        packet.writeDouble(this.baseMaxHeatPowerFist);
        packet.writeDouble(this.baseMaxHeatHelmet);
        packet.writeDouble(this.baseMaxHeatChest);
        packet.writeDouble(this.baseMaxHeatLegs);
        packet.writeDouble(this.baseMaxHeatFeet);
        packet.writeBoolean(this.useThermalExpansionRecipes);
        packet.writeBoolean(this.useEnderIORecipes);
        packet.writeBoolean(this.useTechRebornRecipes);
        packet.writeBoolean(useIC2Recipes);
        MuseByteBufferUtils.writeMap((ByteBuf)packet, ModuleManager.INSTANCE.getCustomInstallCostsForServerToClientConfig(), (boolean)true);
        MuseByteBufferUtils.writeMap((ByteBuf)packet, this.allowedModules, (boolean)true);
        MuseByteBufferUtils.writeMap((ByteBuf)packet, this.propertyDouble, (boolean)true);
        MuseByteBufferUtils.writeMap((ByteBuf)packet, this.propertyInteger, (boolean)true);
        packet.writeInt(this.maxArmorModules);
        packet.writeInt(this.maxEnergyStorageModules);
        packet.writeInt(this.maxEnergyGenModules);
        packet.writeInt(this.maxToolModules);
        packet.writeInt(this.maxWeaponModules);
        packet.writeInt(this.maxMovementModules);
        packet.writeInt(this.maxCosmeticModules);
        packet.writeInt(this.maxVisionModules);
        packet.writeInt(this.maxEnvironmentalModules);
        packet.writeInt(this.maxSpecialModules);
        packet.writeInt(this.maxMiningEnhancementModules);
        packet.writeBoolean(this.useLegacyCosmeticSystem);
        packet.writeBoolean(this.allowHighPollyArmorModuels);
        packet.writeBoolean(this.allowPowerFistCustomization);
        MuseByteBufferUtils.writeMap((ByteBuf)packet, this.cosmeticPresetsPowerFist, (boolean)true);
        MuseByteBufferUtils.writeMap((ByteBuf)packet, this.cosmeticPresetsPowerArmorHelmet, (boolean)true);
        MuseByteBufferUtils.writeMap((ByteBuf)packet, this.cosmeticPresetsPowerArmorChestplate, (boolean)true);
        MuseByteBufferUtils.writeMap((ByteBuf)packet, this.cosmeticPresetsPowerArmorLeggings, (boolean)true);
        MuseByteBufferUtils.writeMap((ByteBuf)packet, this.cosmeticPresetsPowerArmorBoots, (boolean)true);
    }

    public void updateCosmeticInfo(ResourceLocation location, String name, NBTTagCompound cosmeticInfo) {
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)location);
        if (item instanceof ItemPowerFist) {
            this.cosmeticPresetsPowerFist.put((Object)name, (Object)cosmeticInfo);
        } else if (item instanceof ItemPowerArmorHelmet) {
            this.cosmeticPresetsPowerArmorHelmet.put((Object)name, (Object)cosmeticInfo);
        } else if (item instanceof ItemPowerArmorChestplate) {
            this.cosmeticPresetsPowerArmorChestplate.put((Object)name, (Object)cosmeticInfo);
        } else if (item instanceof ItemPowerArmorLeggings) {
            this.cosmeticPresetsPowerArmorLeggings.put((Object)name, (Object)cosmeticInfo);
        } else if (item instanceof ItemPowerArmorBoots) {
            this.cosmeticPresetsPowerArmorBoots.put((Object)name, (Object)cosmeticInfo);
        }
    }
}

