/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.block;

import java.util.Random;
import net.machinemuse.numina.math.Colour;
import net.machinemuse.powersuits.block.TileEntityLuxCapacitor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockLuxCapacitor
extends BlockDirectional {
    public static final Colour defaultColor = new Colour(0.4, 0.2, 0.9);
    public static final IUnlistedProperty<Colour> COLOR = new IUnlistedProperty<Colour>(){

        public String getName() {
            return "luxCapColor";
        }

        public boolean isValid(Colour value) {
            return value != null;
        }

        public Class<Colour> getType() {
            return Colour.class;
        }

        public String valueToString(Colour value) {
            return value != null ? value.hexColour() : defaultColor.hexColour();
        }
    };
    protected static final AxisAlignedBB LUXCAPACITOR_EAST_AABB = new AxisAlignedBB(0.75, 0.0625, 0.0625, 1.0, 0.9375, 0.9375);
    protected static final AxisAlignedBB LUXCAPACITOR_WEST_AABB = new AxisAlignedBB(0.0, 0.0625, 0.0625, 0.25, 0.9375, 0.9375);
    protected static final AxisAlignedBB LUXCAPACITOR_SOUTH_AABB = new AxisAlignedBB(0.0625, 0.0625, 0.75, 0.9375, 0.9375, 1.0);
    protected static final AxisAlignedBB LUXCAPACITOR_NORTH_AABB = new AxisAlignedBB(0.0625, 0.0625, 0.0, 0.9375, 0.9375, 0.25);
    protected static final AxisAlignedBB LUXCAPACITOR_UP_AABB = new AxisAlignedBB(0.0625, 0.75, 0.0625, 0.9375, 1.0, 0.9375);
    protected static final AxisAlignedBB LUXCAPACITOR_DOWN_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.25, 0.9375);
    public static final String translationKey = "powersuits" + "." + "luxCapacitor";

    public BlockLuxCapacitor(ResourceLocation regName) {
        super(Material.field_151594_q);
        this.setRegistryName(regName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.DOWN));
        this.func_149663_c(translationKey);
        this.func_149711_c(0.05f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149713_g(0);
        this.func_149715_a(1.0f);
        this.func_149675_a(false);
        this.setHarvestLevel("pickaxe", 0);
        GameRegistry.registerTileEntity(TileEntityLuxCapacitor.class, (ResourceLocation)regName);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            default: {
                return LUXCAPACITOR_DOWN_AABB;
            }
            case UP: {
                return LUXCAPACITOR_UP_AABB;
            }
            case NORTH: {
                return LUXCAPACITOR_NORTH_AABB;
            }
            case SOUTH: {
                return LUXCAPACITOR_SOUTH_AABB;
            }
            case WEST: {
                return LUXCAPACITOR_WEST_AABB;
            }
            case EAST: 
        }
        return LUXCAPACITOR_EAST_AABB;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (this.canPlaceAt((IBlockAccess)worldIn, pos, facing)) {
            return ((IExtendedBlockState)this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing)).withProperty(COLOR, (Object)defaultColor);
        }
        for (EnumFacing enumfacing : EnumFacing.field_82609_l) {
            if (enumfacing == facing || !this.canPlaceAt((IBlockAccess)worldIn, pos, enumfacing)) continue;
            return ((IExtendedBlockState)this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)enumfacing)).withProperty(COLOR, (Object)defaultColor);
        }
        return ((IExtendedBlockState)this.func_176223_P()).withProperty(COLOR, (Object)defaultColor);
    }

    public BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{field_176387_N}, new IUnlistedProperty[]{COLOR});
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityLuxCapacitor && state instanceof IExtendedBlockState) {
            return ((IExtendedBlockState)state).withProperty(COLOR, (Object)((TileEntityLuxCapacitor)te).getColor());
        }
        return state;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : field_176387_N.func_177700_c()) {
            if (!this.canPlaceAt((IBlockAccess)worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceAt(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        if (!worldIn.func_180495_p(pos).func_177230_c().func_176200_f(worldIn, pos)) {
            return false;
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        BlockFaceShape blockfaceshape = iblockstate.func_193401_d(worldIn, blockpos, facing);
        return iblockstate.isSideSolid(worldIn, pos, facing) && blockfaceshape == BlockFaceShape.SOLID;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        if (state instanceof IExtendedBlockState) {
            return new TileEntityLuxCapacitor((Colour)((IExtendedBlockState)state).getValue(COLOR));
        }
        return new TileEntityLuxCapacitor();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }
}

