/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.utils;

public class FloatAverager {
    private float[] values;
    private int current;
    private int size;

    public FloatAverager(int maxSize) {
        this.size = maxSize;
        this.values = new float[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            this.values[i] = 0.0f;
        }
    }

    public FloatAverager(int maxSize, float initialValue) {
        this.size = maxSize;
        this.values = new float[maxSize];
        for (int i = 0; i < maxSize; ++i) {
            this.values[i] = initialValue;
        }
    }

    public float average() {
        float accumulator = 0.0f;
        for (int i = 0; i < this.size; ++i) {
            accumulator += this.values[i];
        }
        return accumulator / (float)this.size;
    }

    public void add(float value) {
        this.values[this.current++] = value;
        if (this.current >= this.size) {
            this.current = 0;
        }
    }

    public void setAll(float value) {
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = value;
        }
    }
}

