/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.ConnectionPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerClient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.ChunkLoadingCallback;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.EnumPacketDirection;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import org.apache.logging.log4j.LogManager;

public class ConnectionEvents {
    private static boolean clientConnected = false;

    protected static EnumConnectionState registerPacket(EnumPacketDirection direction, Class<? extends Packet<? extends INetHandler>> packetClass) {
        BiMap bimap = (BiMap)EnumConnectionState.PLAY.field_179247_h.get(direction);
        if (bimap == null) {
            bimap = HashBiMap.create();
            EnumConnectionState.PLAY.field_179247_h.put(direction, bimap);
        }
        if (bimap.containsValue(packetClass)) {
            String s = direction + " packet " + packetClass + " is already known to ID " + bimap.inverse().get(packetClass);
            LogManager.getLogger().fatal(s);
            throw new IllegalArgumentException(s);
        }
        bimap.put((Object)bimap.size(), packetClass);
        return EnumConnectionState.PLAY;
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ChunkLoadingCallback.onPlayerLogout(event.player);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ChunkLoadingCallback.onPlayerLogin(event.player);
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP thePlayer = (EntityPlayerMP)event.player;
            GCPlayerStats stats = GCPlayerStats.get((Entity)thePlayer);
            SpaceStationWorldData.checkAllStations(thePlayer, stats);
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SPACESTATION_CLIENT_ID, GCCoreUtil.getDimensionID(thePlayer.field_70170_p), new Object[]{WorldUtil.spaceStationDataToString(stats.getSpaceStationDimensionData())}), thePlayer);
            SpaceRace raceForPlayer = SpaceRaceManager.getSpaceRaceFromPlayer(PlayerUtil.getName((EntityPlayer)thePlayer));
            if (raceForPlayer != null) {
                SpaceRaceManager.sendSpaceRaceData(thePlayer.field_71133_b, thePlayer, raceForPlayer);
            }
        }
        if (event.player.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation && event.player instanceof EntityPlayerMP) {
            ((WorldProviderSpaceStation)event.player.field_70170_p.field_73011_w).getSpinManager().sendPackets((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onConnectionReceived(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        if (ConfigManagerCore.enableDebug) {
            Integer[] idList = (Integer[])WorldUtil.getPlanetList().get(0);
            String ids = "";
            for (int j = 0; j < idList.length; ++j) {
                ids = ids + idList[j].toString() + " ";
            }
            GCLog.info("Galacticraft server sending dimension IDs to connecting client: " + ids);
        }
        event.getManager().func_179290_a((Packet)ConnectionPacket.createDimPacket(WorldUtil.getPlanetListInts()));
        event.getManager().func_179290_a((Packet)ConnectionPacket.createSSPacket(WorldUtil.getSpaceStationListInts()));
        event.getManager().func_179290_a((Packet)ConnectionPacket.createConfigPacket(ConfigManagerCore.getServerConfigOverride()));
    }

    @SubscribeEvent
    public void onConnectionOpened(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        if (!event.isLocal()) {
            clientConnected = true;
        }
    }

    @SubscribeEvent
    public void onConnectionClosed(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        TickHandlerClient.menuReset = true;
        if (clientConnected) {
            clientConnected = false;
            WorldUtil.unregisterPlanets();
            WorldUtil.unregisterSpaceStations();
            ConfigManagerCore.restoreClientConfigOverrideable();
        }
    }

    static {
        EnumConnectionState.field_150761_f.put(PacketSimple.class, EnumConnectionState.PLAY);
        ConnectionEvents.registerPacket(EnumPacketDirection.CLIENTBOUND, PacketSimple.class);
    }
}

