/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.items;

import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteorChunk;
import micdoodle8.mods.galacticraft.core.items.ISortableItem;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryItem;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMeteorChunk
extends Item
implements ISortableItem {
    public static final String[] names = new String[]{"meteor_chunk", "meteor_chunk_hot"};
    public static final int METEOR_BURN_TIME = 900;

    public ItemMeteorChunk(String assetName) {
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.field_77777_bU = 16;
        this.func_77637_a(CreativeTabs.field_78035_l);
        this.func_77655_b(assetName);
    }

    public CreativeTabs func_77640_w() {
        return GalacticraftCore.galacticraftItemsTab;
    }

    public void func_77663_a(ItemStack itemstack, World world, Entity entity, int par4, boolean par5) {
        if (itemstack.func_77952_i() == 1 && !world.field_72995_K) {
            if (itemstack.func_77942_o()) {
                float meteorBurnTime = itemstack.func_77978_p().func_74760_g("MeteorBurnTimeF");
                if (meteorBurnTime >= 0.5f) {
                    itemstack.func_77978_p().func_74776_a("MeteorBurnTimeF", meteorBurnTime -= 0.5f);
                } else {
                    itemstack.func_77964_b(0);
                    itemstack.func_77982_d(null);
                }
            } else {
                itemstack.func_77982_d(new NBTTagCompound());
                itemstack.func_77978_p().func_74776_a("MeteorBurnTimeF", 900.0f);
            }
        }
    }

    public void func_77622_d(ItemStack itemstack, World world, EntityPlayer entityPlayer) {
        super.func_77622_d(itemstack, world, entityPlayer);
        if (itemstack.func_77952_i() == 1) {
            if (!itemstack.func_77942_o()) {
                itemstack.func_77982_d(new NBTTagCompound());
            }
            itemstack.func_77978_p().func_74776_a("MeteorBurnTimeF", 900.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == GalacticraftCore.galacticraftItemsTab || tab == CreativeTabs.field_78027_g) {
            list.add((Object)new ItemStack((Item)this, 1, 0));
            list.add((Object)new ItemStack((Item)this, 1, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (itemstack.func_77952_i() > 0) {
            float burnTime = 0.0f;
            if (itemstack.func_77942_o()) {
                float meteorBurnTime = itemstack.func_77978_p().func_74760_g("MeteorBurnTimeF");
                burnTime = (float)Math.round(meteorBurnTime / 10.0f) / 2.0f;
            } else {
                burnTime = 45.0f;
            }
            tooltip.add(GCCoreUtil.translate("item.hot_description.name") + " " + burnTime + GCCoreUtil.translate("gui.seconds"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        return ClientProxyCore.galacticraftItem;
    }

    public String func_77667_c(ItemStack itemStack) {
        return "item." + names[itemStack.func_77952_i()];
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!player.field_71075_bZ.field_75098_d) {
            itemStack.func_190918_g(1);
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187737_v, SoundCategory.NEUTRAL, 1.0f, 1.0E-4f / (Item.field_77697_d.nextFloat() * 0.1f));
        if (!world.field_72995_K) {
            EntityMeteorChunk meteor = new EntityMeteorChunk(world, (EntityLivingBase)player, 1.0f);
            if (itemStack.func_77952_i() > 0) {
                meteor.func_70015_d(20);
                meteor.isHot = true;
            }
            meteor.canBePickedUp = player.field_71075_bZ.field_75098_d ? 2 : 1;
            world.func_72838_d((Entity)meteor);
        }
        player.func_184609_a(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @Override
    public EnumSortCategoryItem getCategory(int meta) {
        return EnumSortCategoryItem.GENERAL;
    }
}

