/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.voice;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Set;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.voice.VoiceConnection;

public class VoiceServerManager {
    private Set<VoiceConnection> connections = new HashSet<VoiceConnection>();
    private ServerSocket serverSocket;
    private Thread listenThread;
    private boolean foundLocal = false;
    private boolean running;

    public void start() {
        Mekanism.logger.info("VoiceServer: Starting up server...");
        try {
            this.running = true;
            this.serverSocket = new ServerSocket(MekanismConfig.current().general.VOICE_PORT.val());
            this.listenThread = new ListenThread();
            this.listenThread.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            Mekanism.logger.info("VoiceServer: Shutting down server...");
            try {
                this.listenThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.foundLocal = false;
            try {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            Mekanism.logger.error("VoiceServer: Error while shutting down server.", (Throwable)e);
        }
        this.running = false;
    }

    public void removeConnection(VoiceConnection connection) {
        this.connections.remove(connection);
    }

    public boolean isFoundLocal() {
        return this.foundLocal;
    }

    public void setFoundLocal(boolean found) {
        this.foundLocal = found;
    }

    public void sendToPlayers(short byteCount, byte[] audioData, VoiceConnection connection) {
        if (connection.getPlayer() == null) {
            return;
        }
        int channel = connection.getCurrentChannel();
        if (channel == 0) {
            return;
        }
        for (VoiceConnection iterConn : this.connections) {
            if (iterConn.getPlayer() == null || iterConn == connection || !iterConn.canListen(channel)) continue;
            iterConn.sendToPlayer(byteCount, audioData, connection);
        }
    }

    private class ListenThread
    extends Thread {
        private ListenThread() {
            this.setDaemon(true);
            this.setName("VoiceServer Listen Thread");
        }

        @Override
        public void run() {
            while (VoiceServerManager.this.running) {
                try {
                    Socket s = VoiceServerManager.this.serverSocket.accept();
                    VoiceConnection connection = new VoiceConnection(s);
                    connection.start();
                    VoiceServerManager.this.connections.add(connection);
                    Mekanism.logger.info("VoiceServer: Accepted new connection.");
                }
                catch (NullPointerException | SocketException s) {
                }
                catch (Exception e) {
                    Mekanism.logger.error("VoiceServer: Error while accepting connection.", (Throwable)e);
                }
            }
        }
    }
}

