/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.prefab;

import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismItems;
import mekanism.common.SideData;
import mekanism.common.block.states.BlockStateMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.DoubleMachineInput;
import mekanism.common.recipe.machines.DoubleMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.prefab.TileEntityUpgradeableMachine;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class TileEntityDoubleElectricMachine<RECIPE extends DoubleMachineRecipe<RECIPE>>
extends TileEntityUpgradeableMachine<DoubleMachineInput, ItemStackOutput, RECIPE> {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};

    public TileEntityDoubleElectricMachine(String soundPath, BlockStateMachine.MachineType type, int ticksRequired) {
        super(soundPath, type, 4, ticksRequired, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "guibasicmachine.png"));
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{2}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{3}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Extra", EnumColor.PURPLE, new int[]{1}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{4, 1, 0, 3, 0, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = NonNullList.func_191197_a((int)5, (Object)ItemStack.field_190927_a);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(2));
    }

    @Override
    protected void upgradeInventory(TileEntityFactory factory) {
        factory.inventory.set(5, this.inventory.get(0));
        factory.inventory.set(4, this.inventory.get(1));
        factory.inventory.set(8, this.inventory.get(2));
        factory.inventory.set(1, this.inventory.get(3));
        factory.inventory.set(0, this.inventory.get(4));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(3, this);
            boolean inactive = false;
            MachineRecipe recipe = this.getRecipe();
            if (this.canOperate((RECIPE)recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                ++this.operatingTicks;
                if (this.operatingTicks >= this.ticksRequired) {
                    this.operate((RECIPE)recipe);
                    this.operatingTicks = 0;
                }
                this.electricityStored -= this.energyPerTick;
            } else {
                inactive = true;
                this.setActive(false);
            }
            if (inactive && this.getRecipe() == null) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public boolean func_94041_b(int slotID, @Nonnull ItemStack itemstack) {
        block6: {
            block5: {
                if (slotID == 2) {
                    return false;
                }
                if (slotID == 4) {
                    return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
                }
                if (slotID != 0) break block5;
                for (DoubleMachineInput input : this.getRecipes().keySet()) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)input.itemStack, (ItemStack)itemstack)) continue;
                    return true;
                }
                break block6;
            }
            if (slotID == 3) {
                return ChargeUtils.canBeDischarged(itemstack);
            }
            if (slotID != 1) break block6;
            for (DoubleMachineInput input : this.getRecipes().keySet()) {
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)input.extraStack, (ItemStack)itemstack)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public DoubleMachineInput getInput() {
        return new DoubleMachineInput((ItemStack)this.inventory.get(0), (ItemStack)this.inventory.get(1));
    }

    @Override
    public RECIPE getRecipe() {
        DoubleMachineInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((DoubleMachineInput)((DoubleMachineRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getRecipe(input, this.getRecipes());
        }
        return (RECIPE)((DoubleMachineRecipe)this.cachedRecipe);
    }

    @Override
    public void operate(RECIPE recipe) {
        ((DoubleMachineRecipe)recipe).operate((NonNullList<ItemStack>)this.inventory, 0, 1, 2);
        this.func_70296_d();
    }

    @Override
    public boolean canOperate(RECIPE recipe) {
        return recipe != null && ((DoubleMachineRecipe)recipe).canOperate((NonNullList<ItemStack>)this.inventory, 0, 1, 2);
    }

    @Override
    public boolean func_180461_b(int slotID, @Nonnull ItemStack itemstack, @Nonnull EnumFacing side) {
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws NoSuchMethodException {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.isActive};
            }
            case 3: {
                return new Object[]{this.facing};
            }
            case 4: {
                return new Object[]{this.canOperate((RECIPE)this.getRecipe())};
            }
            case 5: {
                return new Object[]{this.maxEnergy};
            }
            case 6: {
                return new Object[]{this.maxEnergy - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }
}

