/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.forgeenergy;

import mekanism.common.base.IEnergyWrapper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;

public class ForgeEnergyIntegration
implements IEnergyStorage {
    public IEnergyWrapper tileEntity;
    public EnumFacing side;

    public ForgeEnergyIntegration(IEnergyWrapper tile, EnumFacing facing) {
        this.tileEntity = tile;
        this.side = facing;
    }

    public static double fromForge(int forge) {
        return (double)forge * MekanismConfig.current().general.FROM_FORGE.val();
    }

    public static int toForge(double joules) {
        return MekanismUtils.clampToInt(joules * MekanismConfig.current().general.TO_FORGE.val());
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return ForgeEnergyIntegration.toForge(this.tileEntity.acceptEnergy(this.side, ForgeEnergyIntegration.fromForge(maxReceive), simulate));
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return ForgeEnergyIntegration.toForge(this.tileEntity.pullEnergy(this.side, ForgeEnergyIntegration.fromForge(maxExtract), simulate));
    }

    public int getEnergyStored() {
        return ForgeEnergyIntegration.toForge(this.tileEntity.getEnergy());
    }

    public int getMaxEnergyStored() {
        return ForgeEnergyIntegration.toForge(this.tileEntity.getMaxEnergy());
    }

    public boolean canExtract() {
        return this.tileEntity.sideIsOutput(this.side);
    }

    public boolean canReceive() {
        return this.tileEntity.sideIsConsumer(this.side);
    }
}

