/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.tank;

import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.util.FluidContainerUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class TankCache
extends MultiblockCache<SynchronizedTankData> {
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public FluidStack fluid;
    public FluidContainerUtils.ContainerEditMode editMode = FluidContainerUtils.ContainerEditMode.BOTH;

    @Override
    public void apply(SynchronizedTankData data) {
        data.inventory = this.inventory;
        data.fluidStored = this.fluid;
        data.editMode = this.editMode;
    }

    @Override
    public void sync(SynchronizedTankData data) {
        this.inventory = data.inventory;
        this.fluid = data.fluidStored;
        this.editMode = data.editMode;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        this.editMode = FluidContainerUtils.ContainerEditMode.values()[nbtTags.func_74762_e("editMode")];
        NBTTagList tagList = nbtTags.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
        for (int tagCount = 0; tagCount < tagList.func_74745_c(); ++tagCount) {
            NBTTagCompound tagCompound = tagList.func_150305_b(tagCount);
            byte slotID = tagCompound.func_74771_c("Slot");
            if (slotID < 0 || slotID >= 2) continue;
            this.inventory.set((int)slotID, (Object)new ItemStack(tagCompound));
        }
        if (nbtTags.func_74764_b("cachedFluid")) {
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cachedFluid"));
        }
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        nbtTags.func_74768_a("editMode", this.editMode.ordinal());
        NBTTagList tagList = new NBTTagList();
        for (int slotCount = 0; slotCount < 2; ++slotCount) {
            if (((ItemStack)this.inventory.get(slotCount)).func_190926_b()) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)slotCount);
            ((ItemStack)this.inventory.get(slotCount)).func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTags.func_74782_a("Items", (NBTBase)tagList);
        if (this.fluid != null) {
            nbtTags.func_74782_a("cachedFluid", (NBTBase)this.fluid.writeToNBT(new NBTTagCompound()));
        }
    }
}

