/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

public abstract class SplitInfo<TYPE extends Number> {
    protected int toSplitAmong;
    public boolean amountPerChanged = false;

    private SplitInfo(int totalTargets) {
        this.toSplitAmong = totalTargets;
    }

    public abstract void send(TYPE var1);

    public abstract TYPE getAmountPerTarget();

    public abstract TYPE getTotalSent();

    public static class DoubleSplitInfo
    extends SplitInfo<Double> {
        private double amountToSplit;
        private double amountPerTarget;
        private double sentSoFar;

        public DoubleSplitInfo(double amountToSplit, int totalTargets) {
            super(totalTargets);
            this.amountToSplit = amountToSplit;
            this.amountPerTarget = this.toSplitAmong == 0 ? 0.0 : amountToSplit / (double)this.toSplitAmong;
            this.sentSoFar = 0.0;
        }

        @Override
        public void send(Double amountNeeded) {
            this.amountToSplit -= amountNeeded.doubleValue();
            this.sentSoFar += amountNeeded.doubleValue();
            --this.toSplitAmong;
            if (amountNeeded != this.amountPerTarget && this.toSplitAmong != 0) {
                double amountPerLast = this.amountPerTarget;
                this.amountPerTarget = this.amountToSplit / (double)this.toSplitAmong;
                if (!this.amountPerChanged && this.amountPerTarget != amountPerLast) {
                    this.amountPerChanged = true;
                }
            }
        }

        @Override
        public Double getAmountPerTarget() {
            return this.amountPerTarget;
        }

        @Override
        public Double getTotalSent() {
            return this.sentSoFar;
        }
    }

    public static class IntegerSplitInfo
    extends SplitInfo<Integer> {
        private int amountToSplit;
        private int amountPerTarget;
        private int sentSoFar;

        public IntegerSplitInfo(int amountToSplit, int totalTargets) {
            super(totalTargets);
            this.amountToSplit = amountToSplit;
            this.amountPerTarget = this.toSplitAmong == 0 ? 0 : amountToSplit / this.toSplitAmong;
            this.sentSoFar = 0;
        }

        @Override
        public void send(Integer amountNeeded) {
            this.amountToSplit -= amountNeeded.intValue();
            this.sentSoFar += amountNeeded.intValue();
            --this.toSplitAmong;
            if (amountNeeded != this.amountPerTarget && this.toSplitAmong != 0) {
                int amountPerLast = this.amountPerTarget;
                this.amountPerTarget = this.amountToSplit / this.toSplitAmong;
                if (!this.amountPerChanged && this.amountPerTarget != amountPerLast) {
                    this.amountPerChanged = true;
                }
            }
        }

        @Override
        public Integer getAmountPerTarget() {
            return this.amountPerTarget;
        }

        @Override
        public Integer getTotalSent() {
            return this.sentSoFar;
        }
    }
}

