/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import mekanism.api.gas.Gas;
import mekanism.api.gas.GasTank;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiTankGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.LangUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGasGauge
extends GuiTankGauge<Gas, GasTank> {
    public GuiGasGauge(IGasInfoHandler handler, GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(type, gui, def, x, y, handler);
    }

    public static GuiGasGauge getDummy(GuiGauge.Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        GuiGasGauge gauge = new GuiGasGauge(null, type, gui, def, x, y);
        gauge.dummy = true;
        return gauge;
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.GAS;
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        if (((GasTank)this.infoHandler.getTank()).getGas() == null || ((GasTank)this.infoHandler.getTank()).getMaxGas() == 0) {
            return 0;
        }
        return ((GasTank)this.infoHandler.getTank()).getStored() * (this.height - 2) / ((GasTank)this.infoHandler.getTank()).getMaxGas();
    }

    @Override
    public TextureAtlasSprite getIcon() {
        if (this.dummy) {
            return ((Gas)this.dummyType).getSprite();
        }
        return this.infoHandler.getTank() != null && ((GasTank)this.infoHandler.getTank()).getGas() != null && ((GasTank)this.infoHandler.getTank()).getGas().getGas() != null ? ((GasTank)this.infoHandler.getTank()).getGas().getGas().getSprite() : null;
    }

    @Override
    public String getTooltipText() {
        if (this.dummy) {
            return ((Gas)this.dummyType).getLocalizedName();
        }
        return ((GasTank)this.infoHandler.getTank()).getGas() != null ? ((GasTank)this.infoHandler.getTank()).getGas().getGas().getLocalizedName() + ": " + ((GasTank)this.infoHandler.getTank()).getStored() : LangUtils.localize("gui.empty");
    }

    @Override
    protected void applyRenderColor() {
        if (this.dummy) {
            MekanismRenderer.color((Gas)this.dummyType);
        } else {
            MekanismRenderer.color(((GasTank)this.infoHandler.getTank()).getGas());
        }
    }

    public static interface IGasInfoHandler
    extends GuiTankGauge.ITankInfoHandler<GasTank> {
    }
}

