/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiFilterHolder;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.IOreDictFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiDigitalMinerConfig
extends GuiFilterHolder<TileEntityDigitalMiner, MinerFilter> {
    private GuiTextField radiusField;
    private GuiTextField minField;
    private GuiTextField maxField;
    private GuiButton newFilterButton;
    private GuiButton backButton;
    private GuiButton setRadiButton;
    private GuiButton setMinButton;
    private GuiButton setMaxButton;
    private GuiButton inverseButton;

    public GuiDigitalMinerConfig(EntityPlayer player, TileEntityDigitalMiner tile) {
        super(tile, new ContainerNull(player, tile));
    }

    @Override
    protected HashList<MinerFilter> getFilters() {
        return ((TileEntityDigitalMiner)this.tileEntity).filters;
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.radiusField.func_146178_a();
        this.minField.func_146178_a();
        this.maxField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.radiusField.func_146192_a(mouseX, mouseY, button);
        this.minField.func_146192_a(mouseX, mouseY, button);
        this.maxField.func_146192_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - this.field_147003_i;
            int yAxis = mouseY - this.field_147009_r;
            if (xAxis >= 154 && xAxis <= 166 && yAxis >= this.getScroll() + 18 && yAxis <= this.getScroll() + 18 + 15) {
                if (this.needsScrollBars()) {
                    this.dragOffset = yAxis - (this.getScroll() + 18);
                    this.isDragging = true;
                } else {
                    this.scroll = 0.0f;
                }
            }
            for (int i = 0; i < 4; ++i) {
                int index = this.getFilterIndex() + i;
                IFilter filter = ((TileEntityDigitalMiner)this.tileEntity).filters.get(index);
                if (filter == null) continue;
                int yStart = i * 29 + 18;
                if (xAxis < 56 || xAxis > 152 || yAxis < yStart || yAxis > yStart + 29) continue;
                int arrowX = 140;
                if (index > 0 && xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 14 && yAxis <= yStart + 20) {
                    this.sendDataFromClick(TileNetworkList.withContents(11, index));
                    return;
                }
                if (index < ((TileEntityDigitalMiner)this.tileEntity).filters.size() - 1 && xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 21 && yAxis <= yStart + 27) {
                    this.sendDataFromClick(TileNetworkList.withContents(12, index));
                    return;
                }
                if (filter instanceof IItemStackFilter) {
                    this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, 1, index, SoundEvents.field_187909_gi);
                    continue;
                }
                if (filter instanceof IOreDictFilter) {
                    this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, 2, index, SoundEvents.field_187909_gi);
                    continue;
                }
                if (filter instanceof IMaterialFilter) {
                    this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, 3, index, SoundEvents.field_187909_gi);
                    continue;
                }
                if (!(filter instanceof IModIDFilter)) continue;
                this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, 6, index, SoundEvents.field_187909_gi);
            }
        }
    }

    private void sendPacket(PacketDigitalMinerGui.MinerGuiPacket type, int guiID, int extra, @Nullable SoundEvent sound) {
        Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(type, Coord4D.get(this.tileEntity), guiID, extra, 0));
        if (sound != null) {
            SoundHandler.playSound(sound);
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMinerConfig.png");
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.newFilterButton = new GuiButton(0, this.field_147003_i + 56, this.field_147009_r + 136, 96, 20, LangUtils.localize("gui.newFilter"));
        this.field_146292_n.add(this.newFilterButton);
        this.backButton = new GuiButtonDisableableImage(1, this.field_147003_i + 5, this.field_147009_r + 5, 11, 11, 176, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.backButton);
        this.setRadiButton = new GuiButtonDisableableImage(2, this.field_147003_i + 39, this.field_147009_r + 67, 11, 11, 187, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.setRadiButton);
        this.setMinButton = new GuiButtonDisableableImage(3, this.field_147003_i + 39, this.field_147009_r + 92, 11, 11, 187, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.setMinButton);
        this.setMaxButton = new GuiButtonDisableableImage(4, this.field_147003_i + 39, this.field_147009_r + 117, 11, 11, 187, 11, -11, this.getGuiLocation());
        this.field_146292_n.add(this.setMaxButton);
        this.inverseButton = new GuiButtonDisableableImage(5, this.field_147003_i + 11, this.field_147009_r + 141, 14, 14, 198, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.inverseButton);
        String prevRad = this.radiusField != null ? this.radiusField.func_146179_b() : "";
        String prevMin = this.minField != null ? this.minField.func_146179_b() : "";
        String prevMax = this.maxField != null ? this.maxField.func_146179_b() : "";
        this.radiusField = new GuiTextField(1, this.field_146289_q, this.field_147003_i + 12, this.field_147009_r + 67, 26, 11);
        this.radiusField.func_146203_f(Integer.toString(MekanismConfig.current().general.digitalMinerMaxRadius.val()).length());
        this.radiusField.func_146180_a(prevRad);
        this.minField = new GuiTextField(2, this.field_146289_q, this.field_147003_i + 12, this.field_147009_r + 92, 26, 11);
        this.minField.func_146203_f(3);
        this.minField.func_146180_a(prevMin);
        this.maxField = new GuiTextField(3, this.field_146289_q, this.field_147003_i + 12, this.field_147009_r + 117, 26, 11);
        this.maxField.func_146203_f(3);
        this.maxField.func_146180_a(prevMax);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.newFilterButton.field_146127_k) {
            this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER, 5, 0, null);
        } else if (guibutton.field_146127_k == this.backButton.field_146127_k) {
            this.sendPacket(PacketDigitalMinerGui.MinerGuiPacket.SERVER, 4, 0, null);
        } else if (guibutton.field_146127_k == this.setRadiButton.field_146127_k) {
            this.setRadius();
        } else if (guibutton.field_146127_k == this.setMinButton.field_146127_k) {
            this.setMinY();
        } else if (guibutton.field_146127_k == this.setMaxButton.field_146127_k) {
            this.setMaxY();
        } else if (guibutton.field_146127_k == this.inverseButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(10)));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMinerConfig"), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.filters") + ":", 11, 19, 52480);
        this.field_146289_q.func_78276_b("T: " + ((TileEntityDigitalMiner)this.tileEntity).filters.size(), 11, 28, 52480);
        this.field_146289_q.func_78276_b("I: " + (((TileEntityDigitalMiner)this.tileEntity).inverse ? LangUtils.localize("gui.on") : LangUtils.localize("gui.off")), 11, 131, 52480);
        this.field_146289_q.func_78276_b("Radi: " + ((TileEntityDigitalMiner)this.tileEntity).getRadius(), 11, 58, 52480);
        this.field_146289_q.func_78276_b("Min: " + ((TileEntityDigitalMiner)this.tileEntity).minY, 11, 83, 52480);
        this.field_146289_q.func_78276_b("Max: " + ((TileEntityDigitalMiner)this.tileEntity).maxY, 11, 108, 52480);
        for (int i = 0; i < 4; ++i) {
            IFilter filter = ((TileEntityDigitalMiner)this.tileEntity).filters.get(this.getFilterIndex() + i);
            if (filter == null) continue;
            int yStart = i * 29 + 18;
            if (filter instanceof IItemStackFilter) {
                this.renderItem(((IItemStackFilter)filter).getItemStack(), 59, yStart + 3);
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter"), 78, yStart + 2, 0x404040);
                continue;
            }
            if (filter instanceof IOreDictFilter) {
                IOreDictFilter oreFilter = (IOreDictFilter)filter;
                if (!this.oreDictStacks.containsKey(oreFilter)) {
                    this.updateStackList(oreFilter);
                }
                this.renderItem(((GuiFilterHolder.StackData)this.oreDictStacks.get((Object)filter)).renderStack, 59, yStart + 3);
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.oredictFilter"), 78, yStart + 2, 0x404040);
                continue;
            }
            if (filter instanceof IMaterialFilter) {
                this.renderItem(((IMaterialFilter)filter).getMaterialItem(), 59, yStart + 3);
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.materialFilter"), 78, yStart + 2, 0x404040);
                continue;
            }
            if (!(filter instanceof IModIDFilter)) continue;
            IModIDFilter modFilter = (IModIDFilter)filter;
            if (!this.modIDStacks.containsKey(modFilter)) {
                this.updateStackList(modFilter);
            }
            this.renderItem(((GuiFilterHolder.StackData)this.modIDStacks.get((Object)filter)).renderStack, 59, yStart + 3);
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.modIDFilter"), 78, yStart + 2, 0x404040);
        }
        if (this.inverseButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.digitalMiner.inverse"), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.radiusField.func_146194_f();
        this.minField.func_146194_f();
        this.maxField.func_146194_f();
        MekanismRenderer.resetColor();
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.radiusField.func_146206_l() && !this.minField.func_146206_l() && !this.maxField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28) {
            if (this.radiusField.func_146206_l()) {
                this.setRadius();
            } else if (this.minField.func_146206_l()) {
                this.setMinY();
            } else if (this.maxField.func_146206_l()) {
                this.setMaxY();
            }
        }
        if (Character.isDigit(c) || GuiDigitalMinerConfig.isTextboxKey(c, i)) {
            this.radiusField.func_146201_a(c, i);
            this.minField.func_146201_a(c, i);
            this.maxField.func_146201_a(c, i);
        }
    }

    private void setRadius() {
        if (!this.radiusField.func_146179_b().isEmpty()) {
            int toUse = Math.max(0, Math.min(Integer.parseInt(this.radiusField.func_146179_b()), MekanismConfig.current().general.digitalMinerMaxRadius.val()));
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(6, toUse)));
            this.radiusField.func_146180_a("");
        }
    }

    private void setMinY() {
        if (!this.minField.func_146179_b().isEmpty()) {
            int toUse = Math.max(0, Math.min(Integer.parseInt(this.minField.func_146179_b()), ((TileEntityDigitalMiner)this.tileEntity).maxY));
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(7, toUse)));
            this.minField.func_146180_a("");
        }
    }

    private void setMaxY() {
        if (!this.maxField.func_146179_b().isEmpty()) {
            int toUse = Math.max(((TileEntityDigitalMiner)this.tileEntity).minY, Math.min(Integer.parseInt(this.maxField.func_146179_b()), 255));
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(8, toUse)));
            this.maxField.func_146180_a("");
        }
    }
}

