/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Arrays;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerChanceMachine;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.tile.TileEntityChanceMachine;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiChanceMachine<RECIPE extends ChanceMachineRecipe<RECIPE>>
extends GuiMekanismTile<TileEntityChanceMachine<RECIPE>> {
    public GuiChanceMachine(InventoryPlayer inventory, TileEntityChanceMachine<RECIPE> tile) {
        super(tile, new ContainerChanceMachine<RECIPE>(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab(this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityChanceMachine)this.tileEntity).energyPerTick);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityChanceMachine)this.tileEntity).getMaxEnergy() - ((TileEntityChanceMachine)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.INPUT, this, resource, 55, 16));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 55, 52).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT_WIDE, this, resource, 111, 30));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityChanceMachine)GuiChanceMachine.this.tileEntity).getScaledProgress();
            }
        }, this.getProgressType(), this, resource, 77, 37));
    }

    public GuiProgress.ProgressBar getProgressType() {
        return GuiProgress.ProgressBar.BLUE;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityChanceMachine)this.tileEntity).func_70005_c_(), 45, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return ((TileEntityChanceMachine)this.tileEntity).guiLocation;
    }
}

