/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Arrays;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.inventory.container.ContainerAdvancedElectricMachine;
import mekanism.common.recipe.machines.AdvancedMachineRecipe;
import mekanism.common.tile.prefab.TileEntityAdvancedElectricMachine;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiAdvancedElectricMachine<RECIPE extends AdvancedMachineRecipe<RECIPE>>
extends GuiMekanismTile<TileEntityAdvancedElectricMachine<RECIPE>> {
    public GuiAdvancedElectricMachine(InventoryPlayer inventory, TileEntityAdvancedElectricMachine<RECIPE> tile) {
        super(tile, new ContainerAdvancedElectricMachine<RECIPE>(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab(this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityAdvancedElectricMachine)this.tileEntity).energyPerTick);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityAdvancedElectricMachine)this.tileEntity).getMaxEnergy() - ((TileEntityAdvancedElectricMachine)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.INPUT, this, resource, 55, 16));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 30, 34).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.EXTRA, this, resource, 55, 52));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT_LARGE, this, resource, 111, 30));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityAdvancedElectricMachine)GuiAdvancedElectricMachine.this.tileEntity).getScaledProgress();
            }
        }, this.getProgressType(), this, resource, 77, 37));
    }

    public GuiProgress.ProgressBar getProgressType() {
        return GuiProgress.ProgressBar.BLUE;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityAdvancedElectricMachine)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityAdvancedElectricMachine)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= 61 && xAxis <= 67 && yAxis >= 37 && yAxis <= 49) {
            this.displayTooltip(((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getGas() != null ? ((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getGas().getGas().getLocalizedName() + ": " + ((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getStored() : LangUtils.localize("gui.none"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        if (((TileEntityAdvancedElectricMachine)this.tileEntity).getScaledGasLevel(12) > 0) {
            int displayInt = ((TileEntityAdvancedElectricMachine)this.tileEntity).getScaledGasLevel(12);
            this.displayGauge(61, 49 - displayInt, 6, displayInt, ((TileEntityAdvancedElectricMachine)this.tileEntity).gasTank.getGas());
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return ((TileEntityAdvancedElectricMachine)this.tileEntity).guiLocation;
    }

    public void displayGauge(int xPos, int yPos, int sizeX, int sizeY, GasStack gas) {
        if (gas != null) {
            this.field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            MekanismRenderer.color(gas);
            this.func_175175_a(this.field_147003_i + xPos, this.field_147009_r + yPos, gas.getGas().getSprite(), sizeX, sizeY);
            MekanismRenderer.resetColor();
        }
    }
}

