/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.transmitters;

import mekanism.api.transmitters.ITransmitter;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.translation.I18n;

public enum TransmissionType {
    ENERGY("EnergyNetwork", "Energy"),
    FLUID("FluidNetwork", "Fluids"),
    GAS("GasNetwork", "Gases"),
    ITEM("InventoryNetwork", "Items"),
    HEAT("HeatNetwork", "Heat");

    private String name;
    private String transmission;

    private TransmissionType(String n2, String t) {
        this.name = n2;
        this.transmission = t;
    }

    public static boolean checkTransmissionType(ITransmitter sideTile, TransmissionType type) {
        return type.checkTransmissionType(sideTile);
    }

    public static boolean checkTransmissionType(TileEntity tile1, TransmissionType type) {
        return TransmissionType.checkTransmissionType(tile1, type, null);
    }

    public static boolean checkTransmissionType(TileEntity tile1, TransmissionType type, TileEntity tile2) {
        return type.checkTransmissionType(tile1, tile2);
    }

    public String getName() {
        return this.name;
    }

    public String getTransmission() {
        return this.transmission;
    }

    public String localize() {
        return I18n.func_74838_a((String)this.getTranslationKey());
    }

    public String getTranslationKey() {
        return "transmission." + this.getTransmission();
    }

    public boolean checkTransmissionType(ITransmitter transmitter) {
        return transmitter.getTransmissionType() == this;
    }

    public boolean checkTransmissionType(TileEntity sideTile, TileEntity currentTile) {
        return sideTile instanceof ITransmitter && ((ITransmitter)sideTile).getTransmissionType() == this;
    }
}

