/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.reactor.tileentity;

import com.google.common.base.Supplier;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.reactor.IReactorChamber;
import ic2.core.block.TileEntityBlock;
import ic2.core.block.comp.Fluids;
import ic2.core.block.comp.Redstone;
import ic2.core.block.reactor.tileentity.TileEntityNuclearReactorElectric;
import ic2.core.util.StackUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityReactorChamberElectric
extends TileEntityBlock
implements IInventory,
IReactorChamber,
IEnergyEmitter {
    public final Redstone redstone = this.addComponent(new Redstone(this));
    protected final Fluids fluids = this.addComponent(new Fluids(this));
    private TileEntityNuclearReactorElectric reactor;
    private long lastReactorUpdate;

    public TileEntityReactorChamberElectric() {
        this.fluids.addUnmanagedTankHook((Supplier<? extends Collection<Fluids.InternalFluidTank>>)new Supplier<Collection<Fluids.InternalFluidTank>>(){

            public Collection<Fluids.InternalFluidTank> get() {
                TileEntityNuclearReactorElectric reactor = TileEntityReactorChamberElectric.this.getReactor();
                if (reactor == null) {
                    return Collections.emptySet();
                }
                return Arrays.asList(reactor.inputTank, reactor.outputTank);
            }
        });
    }

    @Override
    protected void onLoaded() {
        super.onLoaded();
        this.updateRedstoneLink();
    }

    private void updateRedstoneLink() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            this.redstone.linkTo(reactor.redstone);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void updateEntityClient() {
        super.updateEntityClient();
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            TileEntityNuclearReactorElectric.showHeatEffects(this.func_145831_w(), this.field_174879_c, reactor.getHeat());
        }
    }

    @Override
    protected boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            World world = this.func_145831_w();
            return reactor.getBlockType().func_180639_a(world, reactor.func_174877_v(), world.func_180495_p(reactor.func_174877_v()), player, hand, side, hitX, hitY, hitZ);
        }
        return false;
    }

    @Override
    protected void onNeighborChange(Block neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        this.lastReactorUpdate = 0L;
        if (this.getReactor() == null) {
            this.destoryChamber(true);
        }
    }

    public void destoryChamber(boolean wrench) {
        World world = this.func_145831_w();
        world.func_175698_g(this.field_174879_c);
        for (ItemStack drop : this.getSelfDrops(0, wrench)) {
            StackUtil.dropAsEntity(world, this.field_174879_c, drop);
        }
    }

    public String func_70005_c_() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70005_c_() : "<null>";
    }

    public boolean func_145818_k_() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_145818_k_() : false;
    }

    public ITextComponent func_145748_c_() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_145748_c_() : new TextComponentString("<null>");
    }

    public int func_70302_i_() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70302_i_() : 0;
    }

    public boolean func_191420_l() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_191420_l() : true;
    }

    public ItemStack func_70301_a(int index) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70301_a(index) : null;
    }

    public ItemStack func_70298_a(int index, int count) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70298_a(index, count) : null;
    }

    public ItemStack func_70304_b(int index) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70304_b(index) : null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            reactor.func_70299_a(index, stack);
        }
    }

    public int func_70297_j_() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70297_j_() : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_70300_a(player) : false;
    }

    public void func_174889_b(EntityPlayer player) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            reactor.func_174889_b(player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            reactor.func_174886_c(player);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_94041_b(index, stack) : false;
    }

    public int func_174887_a_(int id) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_174887_a_(id) : 0;
    }

    public void func_174885_b(int id, int value) {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            reactor.func_174885_b(id, value);
        }
    }

    public int func_174890_g() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        return reactor != null ? reactor.func_174890_g() : 0;
    }

    public void func_174888_l() {
        TileEntityNuclearReactorElectric reactor = this.getReactor();
        if (reactor != null) {
            reactor.func_174888_l();
        }
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    public TileEntityNuclearReactorElectric getReactorInstance() {
        return this.reactor;
    }

    @Override
    public boolean isWall() {
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (super.hasCapability(capability, facing)) {
            return super.getCapability(capability, facing);
        }
        if (this.reactor != null) {
            return this.reactor.getCapability(capability, facing);
        }
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return super.hasCapability(capability, facing) || this.reactor != null && this.reactor.hasCapability(capability, facing);
    }

    private TileEntityNuclearReactorElectric getReactor() {
        long time = this.func_145831_w().func_82737_E();
        if (time != this.lastReactorUpdate) {
            this.updateReactor();
            this.lastReactorUpdate = time;
        } else if (this.reactor != null && this.reactor.func_145837_r()) {
            this.reactor = null;
        }
        return this.reactor;
    }

    private void updateReactor() {
        World world = this.func_145831_w();
        this.reactor = null;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity te = world.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (!(te instanceof TileEntityNuclearReactorElectric)) continue;
            this.reactor = (TileEntityNuclearReactorElectric)te;
            break;
        }
    }
}

