/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import ic2.api.recipe.ISemiFluidFuelManager;
import ic2.api.recipe.Recipes;
import ic2.core.SemiFluidFuelManager;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.comp.Fluids;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.block.invslot.InvSlotConsumableLiquid;
import ic2.core.block.invslot.InvSlotConsumableLiquidByManager;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.init.MainConfig;
import ic2.core.network.GuiSynced;
import ic2.core.profile.NotClassic;
import ic2.core.util.ConfigUtil;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;

@NotClassic
public class TileEntitySemifluidGenerator
extends TileEntityBaseGenerator {
    public final InvSlotConsumableLiquid fluidSlot;
    public final InvSlotOutput outputSlot;
    @GuiSynced
    protected final FluidTank fluidTank;
    protected final Fluids fluids = this.addComponent(new Fluids(this));

    public TileEntitySemifluidGenerator() {
        super(32.0, 1, 32000);
        this.fluidTank = this.fluids.addTankInsert("fluid", 10000, Fluids.fluidPredicate(Recipes.semiFluidGenerator));
        this.fluidSlot = new InvSlotConsumableLiquidByManager((TileEntityInventory)this, "fluidSlot", 1, Recipes.semiFluidGenerator);
        this.outputSlot = new InvSlotOutput(this, "output", 1);
    }

    public static void init() {
        Recipes.semiFluidGenerator = new SemiFluidFuelManager();
        if (ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/semiFluidOil") > 0.0f) {
            TileEntitySemifluidGenerator.addFuel("oil", 10, Math.round(8.0f * ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/semiFluidOil")));
        }
        if (ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/semiFluidFuel") > 0.0f) {
            TileEntitySemifluidGenerator.addFuel("fuel", 5, Math.round(32.0f * ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/semiFluidFuel")));
        }
        if (ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/semiFluidBiomass") > 0.0f) {
            TileEntitySemifluidGenerator.addFuel("biomass", 20, Math.round(8.0f * ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/semiFluidBiomass")));
        }
        if (ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/semiFluidBioethanol") > 0.0f) {
            TileEntitySemifluidGenerator.addFuel("bio.ethanol", 10, Math.round(16.0f * ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/semiFluidBioethanol")));
        }
        if (ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/semiFluidBiogas") > 0.0f) {
            TileEntitySemifluidGenerator.addFuel("ic2biogas", 10, Math.round(16.0f * ConfigUtil.getFloat(MainConfig.get(), "balance/energy/generator/semiFluidBiogas")));
        }
    }

    public static void addFuel(String fluidName, int amount, int eu) {
        Recipes.semiFluidGenerator.addFluid(fluidName, amount, eu);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.fluidSlot.processIntoTank((IFluidTank)this.fluidTank, this.outputSlot)) {
            this.func_70296_d();
        }
    }

    @Override
    public boolean gainFuel() {
        ISemiFluidFuelManager.BurnProperty property;
        boolean dirty = false;
        FluidStack ret = this.fluidTank.drain(Integer.MAX_VALUE, false);
        if (ret != null && (property = Recipes.semiFluidGenerator.getBurnProperty(ret.getFluid())) != null && ret.amount >= property.amount) {
            this.fluidTank.drainInternal(property.amount, true);
            this.production = property.power;
            this.fuel += property.amount;
            dirty = true;
        }
        return dirty;
    }

    @Override
    public String getOperationSoundFile() {
        return "Generators/GeothermalLoop.ogg";
    }
}

